/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.api;

import java.nio.file.Path;
import tla2sany.api.DefaultResolver;
import tla2sany.api.ModuleSourceCode;
import tla2sany.api.Resolver;

public class RootModuleResolver
implements Resolver {
    private final DefaultResolver innerResolver;
    public final String rootModuleName;

    @Override
    public ModuleSourceCode resolve(String moduleName) {
        return this.innerResolver.resolve(moduleName);
    }

    public RootModuleResolver(Path rootModulePath) {
        Path parentDir = RootModuleResolver.parentDirOf(rootModulePath);
        this.innerResolver = new DefaultResolver(parentDir);
        this.rootModuleName = RootModuleResolver.expectedModuleName(rootModulePath);
    }

    private static Path parentDirOf(Path filepath) {
        Path parent = filepath.getParent();
        return parent == null ? Path.of(".", new String[0]) : parent;
    }

    private static String expectedModuleName(Path filepath) {
        String filename = filepath.getFileName().toString();
        String tlaSuffix = ".tla";
        if (filename.endsWith(".tla")) {
            return filename.substring(0, filename.length() - ".tla".length());
        }
        throw new IllegalArgumentException("File must have .tla suffix: " + filepath.toString());
    }
}

