/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.module.TLCGetSet;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.RLActionSimulationWorker;
import tlc2.tool.RLSimulationWorker;
import tlc2.tool.SimulationWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.coverage.CostModelCreator;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.LiveCheck1;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.DotActionWriter;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import tlc2.util.Vect;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.value.IValue;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.CounterExample;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FileUtil;
import util.FilenameToStream;
import util.UniqueString;

public class Simulator {
    public static boolean EXTENDED_STATISTICS = Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".extendedStatistics");
    public static boolean EXTENDED_STATISTICS_NAIVE = Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".extendedStatistics.naive");
    public static boolean EXPERIMENTAL_LIVENESS_SIMULATION = Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".experimentalLiveness");
    private final String traceActions;
    private final Value config;
    private final ITool tool;
    private final Action[] invariants;
    private final boolean checkDeadlock;
    private final boolean checkLiveness;
    private final LongAdder numOfGenStates = new LongAdder();
    private final AtomicLong numOfGenTraces = new AtomicLong();
    private final AtomicLong welfordM2AndMean = new AtomicLong();
    private final String traceFile;
    private final int traceDepth;
    private final long traceNum;
    private int numWorkers = 1;
    private final RandomGenerator rng;
    private final long seed;
    private long aril;
    protected final BlockingQueue<SimulationWorker.SimulationWorkerResult> workerResultQueue = new LinkedBlockingQueue<SimulationWorker.SimulationWorkerResult>();
    private final long startTime = System.currentTimeMillis();
    protected final List<SimulationWorker> workers;

    public Simulator(String specFile, String configFile, String traceFile, boolean deadlock, int traceDepth, long traceNum, RandomGenerator rng, long seed, FilenameToStream resolver, int numWorkers) throws IOException {
        this(new FastTool(Simulator.extracted(specFile), configFile, resolver, Tool.Mode.Simulation, new HashMap<String, Object>()), "", traceFile, deadlock, traceDepth, traceNum, null, rng, seed, resolver, numWorkers);
    }

    private static String extracted(String specFile) {
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        return specFile.substring(lastSep + 1);
    }

    public Simulator(ITool tool, String metadir, String traceFile, boolean deadlock, int traceDepth, long traceNum, String traceActions, RandomGenerator rng, long seed, FilenameToStream resolver, int numWorkers) throws IOException {
        this.tool = tool;
        this.checkDeadlock = deadlock && tool.getModelConfig().getCheckDeadlock();
        this.checkLiveness = !tool.livenessIsTrue();
        this.invariants = tool.getInvariants();
        this.traceDepth = traceDepth != -1 ? traceDepth : Integer.MAX_VALUE;
        this.traceFile = traceFile;
        this.traceNum = traceNum;
        this.traceActions = traceActions;
        this.rng = rng;
        this.seed = seed;
        this.aril = 0L;
        ILiveCheck liveCheck = new NoOpLiveCheck(tool, metadir);
        AtomicBoolean errorFound = new AtomicBoolean(false);
        this.numWorkers = numWorkers;
        this.workers = new ArrayList<SimulationWorker>(numWorkers);
        int i = 0;
        while (i < this.numWorkers) {
            ITool t;
            if (this.checkLiveness) {
                if (EXPERIMENTAL_LIVENESS_SIMULATION) {
                    String tmpDir = Files.createTempDirectory(String.format("tlc-simulator-%s-", i), new FileAttribute[0]).toString();
                    liveCheck = new LiveCheck(tool.noDebug(), tmpDir, new DummyBucketStatistics());
                } else {
                    liveCheck = new LiveCheck1(tool.noDebug(), errorFound, i != 0);
                }
            }
            ITool iTool = t = i == 0 ? tool : tool.noDebug();
            if (Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".rl")) {
                this.workers.add(new RLSimulationWorker(i, t, this.workerResultQueue, this.rng.nextLong(), this.traceDepth, this.traceNum, this.traceActions, this.checkDeadlock, this.traceFile, liveCheck, this.numOfGenStates, this.numOfGenTraces, this.welfordM2AndMean));
            } else if (Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".rlaction")) {
                this.workers.add(new RLActionSimulationWorker(i, t, this.workerResultQueue, this.rng.nextLong(), this.traceDepth, this.traceNum, this.traceActions, this.checkDeadlock, this.traceFile, liveCheck, this.numOfGenStates, this.numOfGenTraces, this.welfordM2AndMean));
            } else {
                this.workers.add(new SimulationWorker(i, t, this.workerResultQueue, this.rng.nextLong(), this.traceDepth, this.traceNum, this.traceActions, this.checkDeadlock, this.traceFile, liveCheck, this.numOfGenStates, this.numOfGenTraces, this.welfordM2AndMean));
            }
            ++i;
        }
        this.config = this.createConfig();
        if (TLCGlobals.isCoverageEnabled() || TLCGlobals.Coverage.isEnabled()) {
            CostModelCreator.create(this.tool);
        }
        AbstractChecker.scheduleTermination(new TimerTask(){

            @Override
            public void run() {
                Simulator.this.stop();
            }
        });
    }

    protected boolean isNonContinuableError(int ec) {
        return ec == 2111 || ec == 2113 || ec == 2109;
    }

    private void shutdownAndJoinWorkers(List<SimulationWorker> workers) throws InterruptedException {
        for (SimulationWorker worker : workers) {
            worker.interrupt();
        }
        for (SimulationWorker worker : workers) {
            worker.join(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int simulate() throws Exception {
        StateVec initStates;
        int res = this.tool.checkAssumptions();
        if (res != 0) {
            return res;
        }
        TLCState curState = null;
        try {
            StateVec inits = this.tool.getInitStates();
            initStates = new StateVec(inits.size());
            assert (this.numOfGenStates.longValue() == 0L);
            this.numOfGenStates.add(inits.size());
            MP.printMessage(2269, this.numOfGenStates.toString());
            int i = 0;
            while (i < inits.size()) {
                curState = inits.elementAt(i);
                if (this.tool.isGoodState(curState)) {
                    int j = 0;
                    while (j < this.invariants.length) {
                        if (!this.tool.isValid(this.invariants[j], curState)) {
                            int err = MP.printError(2107, new String[]{this.tool.getInvNames()[j], this.tool.evalAlias(curState, curState).toString()});
                            this.tool.checkPostConditionWithCounterExample(new CounterExample(curState));
                            return err;
                        }
                        ++j;
                    }
                } else {
                    return MP.printError(2106, curState.toString());
                }
                if (this.tool.isInModel(curState)) {
                    initStates.addElement(curState);
                }
                ++i;
            }
        }
        catch (Exception e) {
            int errorCode = curState != null ? MP.printError(2102, new String[]{e.getMessage() == null ? e.toString() : e.getMessage(), curState.toString()}) : MP.printError(1000, e);
            this.printSummary();
            return errorCode;
        }
        if (this.numOfGenStates.longValue() == 0L) {
            return MP.printError(2118);
        }
        if (this.numOfGenStates.longValue() > 0L && initStates.isEmpty()) {
            return MP.printError(2256);
        }
        MP.printMessage(2190, String.valueOf(initStates.size()), "");
        initStates.deepNormalize();
        ProgressReport report = new ProgressReport();
        report.start();
        this.aril = this.rng.getAril();
        SimulationWorker.SimulationWorkerResult result = this.simulate(initStates);
        int errorCode = result.isError() ? result.error().errorCode : 0;
        errorCode = result.isError() && result.error().hasTrace() ? Math.max(this.tool.checkPostConditionWithCounterExample(result.error().getCounterExample()), errorCode) : Math.max(this.tool.checkPostCondition(), errorCode);
        report.isRunning = false;
        ProgressReport progressReport = report;
        synchronized (progressReport) {
            report.notify();
        }
        report.join();
        if (errorCode == 0) {
            this.printSummary();
        }
        return errorCode;
    }

    protected SimulationWorker.SimulationWorkerResult simulate(StateVec initStates) throws InterruptedException {
        SimulationWorker.SimulationWorkerResult result;
        HashSet<Integer> runningWorkers = new HashSet<Integer>();
        int i = 0;
        while (i < this.workers.size()) {
            SimulationWorker worker = this.workers.get(i);
            worker.start(initStates);
            runningWorkers.add(i);
            ++i;
        }
        while (true) {
            if ((result = this.workerResultQueue.take()).workerId() == -1) {
                runningWorkers.clear();
                break;
            }
            if (result.isError()) {
                SimulationWorker.SimulationWorkerError error = result.error();
                if (error.exception != null) {
                    if (error.exception instanceof LiveException) {
                        this.printSummary();
                        error.errorCode = ((LiveException)error.exception).errorCode;
                        break;
                    }
                    if (error.exception instanceof Assert.TLCRuntimeException) {
                        Assert.TLCRuntimeException exception = (Assert.TLCRuntimeException)error.exception;
                        this.printBehavior(exception, error.stateTrace);
                        error.errorCode = exception.errorCode;
                        break;
                    }
                    this.printBehavior(1000, new String[]{MP.ECGeneralMsg("", error.exception)}, error.stateTrace);
                    error.errorCode = 1000;
                    break;
                }
                this.printBehavior(error);
                if (this.isNonContinuableError(error.errorCode)) {
                    error.errorCode = error.errorCode;
                    break;
                }
                if (!TLCGlobals.continuation) {
                    error.errorCode = error.errorCode;
                    break;
                }
                if (error.errorCode != 0) continue;
                error.errorCode = 1000;
                continue;
            }
            runningWorkers.remove(result.workerId());
            if (runningWorkers.isEmpty()) break;
        }
        this.shutdownAndJoinWorkers(this.workers);
        return result;
    }

    protected final void printBehavior(Assert.TLCRuntimeException exception, StateVec stateTrace) {
        MP.printTLCRuntimeException(exception);
        this.printBehavior(stateTrace);
    }

    protected final void printBehavior(SimulationWorker.SimulationWorkerError error) {
        this.printBehavior(error.errorCode, error.parameters, error.stateTrace);
    }

    protected final void printBehavior(int errorCode, String[] parameters, StateVec stateTrace) {
        MP.printError(errorCode, parameters);
        this.printBehavior(stateTrace);
        this.printSummary();
    }

    private final void printBehavior(StateVec stateTrace) {
        if (this.traceDepth == Integer.MAX_VALUE) {
            MP.printMessage(2120);
            StatePrinter.printStandaloneErrorState(stateTrace.last());
        } else {
            MP.printError(2121);
            TLCState lastState = null;
            int omitted = 0;
            int i = 0;
            while (i < stateTrace.size()) {
                TLCStateInfo sinfo;
                TLCState curState = stateTrace.elementAt(i);
                TLCState sucState = stateTrace.elementAt(Math.min(i + 1, stateTrace.size() - 1));
                if (lastState == null) {
                    sinfo = new TLCStateInfo(curState);
                    StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(sinfo, sucState), lastState, curState.getLevel(), i + 1 == stateTrace.size());
                    lastState = curState;
                } else {
                    sinfo = new TLCStateInfo(curState);
                    if (TLCGlobals.printDiffsOnly && curState.fingerPrint() == lastState.fingerPrint()) {
                        ++omitted;
                    } else {
                        StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(sinfo, sucState), lastState, curState.getLevel(), i + 1 == stateTrace.size());
                    }
                    lastState = curState;
                }
                ++i;
            }
            if (omitted > 0) {
                assert (TLCGlobals.printDiffsOnly);
                MP.printMessage(1000, String.format("difftrace requested: Shortened behavior by omitting finite stuttering (%s states), which is an artifact of simulation mode.\n", omitted));
            }
        }
    }

    public IValue getLocalValue(int idx) {
        Iterator<SimulationWorker> iterator = this.workers.iterator();
        if (iterator.hasNext()) {
            SimulationWorker w = iterator.next();
            return w.getLocalValue(idx);
        }
        return null;
    }

    public void setAllValues(int idx, IValue val) {
        for (SimulationWorker w : this.workers) {
            w.setLocalValue(idx, val);
        }
    }

    public List<IValue> getAllValues(int idx) {
        return this.workers.stream().map(w -> w.getLocalValue(idx)).collect(Collectors.toList());
    }

    public final Value getAllValues() {
        IValue[] localValues = this.workers.get(0).getLocalValues();
        HashMap<Value, Value> m = new HashMap<Value, Value>(localValues.length);
        int i = 0;
        while (i < localValues.length) {
            IValue iValue = localValues[i];
            if (iValue != null) {
                Value[] vals = new Value[this.workers.size()];
                int j = 0;
                while (j < vals.length) {
                    vals[j] = (Value)this.workers.get(j).getLocalValue(i);
                    ++j;
                }
                m.put(IntValue.gen(i), new TupleValue(vals));
            }
            ++i;
        }
        return new FcnRcdValue(m);
    }

    protected final void printSummary() {
        this.reportCoverage();
        try {
            this.writeActionFlowGraph();
        }
        catch (Exception e) {
            MP.printTLCBug(2124, null);
        }
        if (TLCGlobals.tool) {
            MP.printMessage(2209, String.valueOf(this.numOfGenStates.longValue()), String.valueOf(this.numOfGenTraces.longValue()));
        }
        MP.printMessage(2210, String.valueOf(this.numOfGenStates.longValue()), String.valueOf(this.seed), String.valueOf(this.aril));
    }

    public final void reportCoverage() {
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.report(this.tool, this.startTime);
        }
    }

    public final ITool getTool() {
        return this.tool;
    }

    private void writeActionFlowGraph() throws IOException {
        if ("BASIC".equals(this.traceActions)) {
            this.writeActionFlowGraphBasic();
        } else if ("FULL".equals(this.traceActions)) {
            this.writeActionFlowGraphFull();
        }
    }

    private void writeActionFlowGraphFull() throws IOException {
        Vect<Action> initAndNext = this.tool.getSpecActions();
        int len = initAndNext.size();
        HashMap clusters = new HashMap();
        int i = 0;
        while (i < len) {
            String con = initAndNext.elementAt((int)i).con.toString();
            if (!clusters.containsKey(con)) {
                clusters.put(con, new HashSet());
            }
            ((Set)clusters.get(con)).add(i);
            ++i;
        }
        DotActionWriter dotActionWriter = new DotActionWriter(String.valueOf(this.tool.getRootName()) + "_actions.dot", "");
        for (Map.Entry cluster : clusters.entrySet()) {
            String key = Integer.toString(Math.abs(((String)cluster.getKey()).hashCode()));
            dotActionWriter.writeSubGraphStart(key, ((String)cluster.getKey()).toString());
            Set ids = (Set)cluster.getValue();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                Integer id = (Integer)iterator.next();
                dotActionWriter.write(initAndNext.elementAt(id), (int)id);
            }
            dotActionWriter.writeSubGraphEnd();
        }
        long[][] aggregateActionStats = new long[len][len];
        List<SimulationWorker> workers = this.workers;
        for (SimulationWorker sw : workers) {
            long[][] s = sw.statistics.actionStats;
            int i2 = 0;
            while (i2 < len) {
                int j = 0;
                while (j < len) {
                    long[] lArray = aggregateActionStats[i2];
                    int n = j;
                    lArray[n] = lArray[n] + s[i2][j];
                    ++j;
                }
                ++i2;
            }
        }
        HashMap<Integer, Action> idToActionName = new HashMap<Integer, Action>();
        int i3 = 0;
        while (i3 < initAndNext.size()) {
            Action action = initAndNext.elementAt(i3);
            idToActionName.put(action.getId(), action);
            ++i3;
        }
        i3 = 0;
        while (i3 < len) {
            int j = 0;
            while (j < len) {
                long l = aggregateActionStats[i3][j];
                if (l > 0L) {
                    double loglogWeight = Math.log10(Math.log10(l + 1L));
                    dotActionWriter.write(i3, j, BigDecimal.valueOf(loglogWeight).setScale(2, RoundingMode.HALF_UP).doubleValue());
                } else if (!((Action)idToActionName.get(j)).isInitPredicate()) {
                    dotActionWriter.write(i3, j);
                }
                ++j;
            }
            ++i3;
        }
        dotActionWriter.close();
    }

    private void writeActionFlowGraphBasic() throws IOException {
        Vect<Action> initAndNext = this.tool.getSpecActions();
        int len = initAndNext.size();
        long[][] aggregateActionStats = new long[len][len];
        List<SimulationWorker> workers = this.workers;
        for (SimulationWorker sw : workers) {
            long[][] s = sw.statistics.actionStats;
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < len) {
                    long[] lArray = aggregateActionStats[i];
                    int n = j;
                    lArray[n] = lArray[n] + s[i][j];
                    ++j;
                }
                ++i;
            }
        }
        HashMap<Integer, Action> idToAction = new HashMap<Integer, Action>();
        HashMap<Location, Integer> actionToId = new HashMap<Location, Integer>();
        int i = 0;
        while (i < initAndNext.size()) {
            Action action = initAndNext.elementAt(i);
            if (!actionToId.containsKey(action.getDefinition())) {
                int id2 = idToAction.size();
                idToAction.put(id2, action);
                actionToId.put(action.getDefinition(), id2);
            }
            ++i;
        }
        HashMap<Integer, Integer> actionsToDistinctActions = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < initAndNext.size()) {
            Action action = initAndNext.elementAt(i2);
            actionsToDistinctActions.put(action.getId(), (Integer)actionToId.get(action.getDefinition()));
            ++i2;
        }
        DotActionWriter dotActionWriter = new DotActionWriter(String.valueOf(this.tool.getRootName()) + "_actions.dot", "");
        idToAction.forEach((id, a) -> dotActionWriter.write((Action)a, (int)id));
        long[][] reducedAggregateActionStats = new long[idToAction.size()][idToAction.size()];
        int i3 = 0;
        while (i3 < len) {
            int originActionId = (Integer)actionsToDistinctActions.get(i3);
            int j = 0;
            while (j < len) {
                int nextActionId = (Integer)actionsToDistinctActions.get(j);
                long[] lArray = reducedAggregateActionStats[originActionId];
                int n = nextActionId;
                lArray[n] = lArray[n] + aggregateActionStats[i3][j];
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < idToAction.size()) {
            int j = 0;
            while (j < idToAction.size()) {
                long l = reducedAggregateActionStats[i3][j];
                if (l > 0L) {
                    double loglogWeight = Math.abs(Math.log10(Math.log10(l + 1L)));
                    dotActionWriter.write(i3, j, BigDecimal.valueOf(loglogWeight).setScale(2, RoundingMode.HALF_UP).doubleValue());
                } else if (!((Action)idToAction.get(j)).isInitPredicate()) {
                    dotActionWriter.write(i3, j);
                }
                ++j;
            }
            ++i3;
        }
        dotActionWriter.close();
    }

    public final StateVec getTrace(TLCState s) {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getTrace(s);
        }
        assert (this.numWorkers == 1 && this.workers.size() == this.numWorkers);
        return this.workers.get(0).getTrace(s);
    }

    public void stop() {
        for (SimulationWorker worker : this.workers) {
            worker.setStopped();
            worker.interrupt();
        }
    }

    public RandomGenerator getRNG() {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getRNG();
        }
        return this.rng;
    }

    public int getTraceDepth() {
        return this.traceDepth;
    }

    public final SimulationWorker.SimulationWorkerStatistics getWorkerStatistics() {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.statistics;
        }
        return this.workers.get((int)0).statistics;
    }

    public final Value getStatistics(TLCState s) {
        UniqueString[] n = new UniqueString[11];
        Value[] v = new Value[n.length];
        long genTrace = this.numOfGenTraces.longValue();
        n[0] = TLCGetSet.TRACES;
        v[0] = IntValue.narrowToIntValue(genTrace);
        n[1] = TLCGetSet.DURATION;
        v[1] = IntValue.narrowToIntValue((System.currentTimeMillis() - this.startTime) / 1000L);
        n[2] = TLCGetSet.GENERATED;
        v[2] = IntValue.narrowToIntValue(this.numOfGenStates.longValue());
        n[3] = TLCGetSet.BEHAVIOR;
        v[3] = this.getWorkerStatistics().getTraceStatistics(s);
        n[4] = TLCGetSet.WORKER;
        v[4] = IntValue.gen(Thread.currentThread() instanceof IdThread ? IdThread.GetId() : 0);
        n[5] = TLCGetSet.DISTINCT;
        v[5] = this.getWorkerStatistics().getDistinctStates();
        n[6] = TLCGetSet.DISTINCT_VALUES;
        v[6] = this.getWorkerStatistics().getDistinctValues();
        n[7] = TLCGetSet.RETRIES;
        v[7] = this.getWorkerStatistics().getNextRetries();
        n[8] = TLCGetSet.SPEC_ACTIONS;
        v[8] = this.getWorkerStatistics().getActions();
        long m2AndMean = this.welfordM2AndMean.get();
        long mean = m2AndMean & 0xFFFFFFFFL;
        n[9] = TLCGetSet.LEVEL_MEAN;
        v[9] = IntValue.narrowToIntValue(mean);
        long m2 = m2AndMean >>> 32;
        n[10] = TLCGetSet.LEVEL_VARIANCE;
        v[10] = IntValue.narrowToIntValue(Math.round((double)m2 / ((double)genTrace + 1.0)));
        return new RecordValue(n, v, false);
    }

    public final Value getConfig() {
        return this.config;
    }

    private final Value createConfig() {
        UniqueString[] n = new UniqueString[9];
        Value[] v = new Value[n.length];
        n[0] = TLCGetSet.MODE;
        v[0] = Tool.isProbabilistic() ? new StringValue("generate") : new StringValue("simulate");
        n[1] = TLCGetSet.DEPTH;
        v[1] = IntValue.gen(this.traceDepth == Integer.MAX_VALUE ? -1 : this.traceDepth);
        n[2] = TLCGetSet.TRACES;
        v[2] = IntValue.gen((int)((long)this.numWorkers * this.traceNum));
        n[3] = TLCGetSet.DEADLOCK;
        v[3] = this.checkDeadlock ? BoolValue.ValTrue : BoolValue.ValFalse;
        n[4] = TLCGetSet.SEED;
        v[4] = new StringValue(Long.toString(this.seed));
        n[5] = TLCGetSet.ARIL;
        v[5] = new StringValue(Long.toString(this.aril));
        n[6] = TLCGetSet.WORKER;
        v[6] = IntValue.gen(this.numWorkers);
        n[7] = TLCGetSet.INSTALL;
        v[7] = new StringValue(TLCGlobals.getInstallLocation());
        n[8] = TLCGetSet.SCHED;
        v[8] = new StringValue(Simulator.getScheduler());
        return new RecordValue(n, v, false);
    }

    private static String getScheduler() {
        if (Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".rl")) {
            return "rl";
        }
        if (Boolean.getBoolean(String.valueOf(Simulator.class.getName()) + ".rlaction")) {
            return "rlaction";
        }
        return "random";
    }

    final class ProgressReport
    extends Thread {
        volatile boolean isRunning = true;

        ProgressReport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExprNode periodic = Simulator.this.tool.getSpecProcessor().getPeriodic();
            int count = TLCGlobals.coverageInterval / TLCGlobals.progressInterval;
            try {
                while (this.isRunning) {
                    ProgressReport progressReport = this;
                    synchronized (progressReport) {
                        this.wait(TLCGlobals.progressInterval);
                    }
                    long genTrace = Simulator.this.numOfGenTraces.longValue();
                    long m2AndMean = Simulator.this.welfordM2AndMean.get();
                    long mean = m2AndMean & 0xFFFFFFFFL;
                    long m2 = m2AndMean >>> 32;
                    MP.printMessage(2209, String.valueOf(Simulator.this.numOfGenStates.longValue()), String.valueOf(genTrace), String.valueOf(mean), String.valueOf(Math.round((double)m2 / ((double)genTrace + 1.0))), String.valueOf(Math.round(Math.sqrt((double)m2 / ((double)genTrace + 1.0)))));
                    if (count > 1) {
                        --count;
                    } else {
                        Simulator.this.reportCoverage();
                        count = TLCGlobals.coverageInterval / TLCGlobals.progressInterval;
                    }
                    Simulator.this.writeActionFlowGraph();
                    if (periodic == null || !BoolValue.ValFalse.equals(Simulator.this.tool.noDebug().eval(periodic))) continue;
                    MP.printError(2104, periodic.toString());
                    Simulator.this.workerResultQueue.add(SimulationWorker.SimulationWorkerResult.OK(-1));
                }
            }
            catch (Exception e) {
                MP.printTLCBug(2124, null);
            }
        }
    }
}

