/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Test;
import tlc2.tool.TLCIsolatedExecutor;

public class RunTwiceIsolatedClassLoaderTest {
    private static final Path SPEC_FILE = Paths.get("test-model/IsolatedDynamicSpec.tla", new String[0]);
    private static final Path CFG_FILE = Paths.get("test-model/IsolatedDynamicSpec.cfg", new String[0]);

    @Test
    public void testIsolatedRunsStartFromPristineState() throws Exception {
        RunTwiceIsolatedClassLoaderTest.writeSpecVariantOne();
        TLCIsolatedExecutor.RunOutcome runOne = RunTwiceIsolatedClassLoaderTest.runWithIsolatedExecutor("run1");
        if (runOne.getExitCode() != 2110) {
            throw new AssertionError((Object)("Expected exit code 2110 for variant one but got " + runOne.getExitCode()));
        }
        if (runOne.getLastIntValue() == null || runOne.getLastIntValue() != 3) {
            throw new AssertionError((Object)("Expected final x state of 3 for variant one but got " + runOne.getLastIntValue()));
        }
        RunTwiceIsolatedClassLoaderTest.writeSpecVariantTwo();
        TLCIsolatedExecutor.RunOutcome runTwo = RunTwiceIsolatedClassLoaderTest.runWithIsolatedExecutor("run2");
        if (runTwo.getExitCode() == runOne.getExitCode()) {
            throw new AssertionError((Object)("Second run should not mirror first run exit code; got " + runTwo.getExitCode()));
        }
        if (runTwo.getMainCheckerIdentity() == runOne.getMainCheckerIdentity()) {
            throw new AssertionError((Object)"Main checker identity should differ across isolated runs");
        }
        RunTwiceIsolatedClassLoaderTest.assertMetaDir(runOne.getMetaDir(), "states/RunTwiceIsolatedClassLoaderTest/run1");
        RunTwiceIsolatedClassLoaderTest.assertMetaDir(runTwo.getMetaDir(), "states/RunTwiceIsolatedClassLoaderTest/run2");
        if (runOne.getNumWorkers() != 1 || runTwo.getNumWorkers() != 1) {
            throw new AssertionError((Object)"Isolated runs should reflect configured worker count of 1");
        }
    }

    private static TLCIsolatedExecutor.RunOutcome runWithIsolatedExecutor(String runId) throws ReflectiveOperationException {
        String[] args = new String[]{"-workers", "1", "-metadir", "states/RunTwiceIsolatedClassLoaderTest/" + runId, "-noTE", "-noTEBin", SPEC_FILE.toString()};
        return TLCIsolatedExecutor.runWithErrorTrace(args, "x");
    }

    private static void assertMetaDir(String actual, String expected) {
        String normalized;
        if (actual == null) {
            throw new AssertionError((Object)"Metadir should not be null");
        }
        String string = normalized = actual.endsWith("/") ? actual.substring(0, actual.length() - 1) : actual;
        if (!expected.equals(normalized)) {
            throw new AssertionError((Object)("Expected metadir " + expected + " but saw " + actual));
        }
    }

    private static void writeSpecVariantOne() throws IOException {
        String content = String.join((CharSequence)"\n", "---- MODULE IsolatedDynamicSpec ----", "EXTENDS Integers", "VARIABLE x", "TheOp == 1 + 1", "Init == x = 0", "Action == /\\ x < 5 /\\ x' = x + 1", "Next == Action \\/ (x = 5 /\\ UNCHANGED x)", "Inv == x <= TheOp", "Spec == Init /\\ [][Next]_x", "====", "");
        RunTwiceIsolatedClassLoaderTest.writeFiles(content);
    }

    private static void writeSpecVariantTwo() throws IOException {
        String content = String.join((CharSequence)"\n", "---- MODULE IsolatedDynamicSpec ----", "EXTENDS Integers", "VARIABLE x", "TheOp == 4 + 4", "Init == x = 0", "Action == ( /\\ x < 8 /\\ x' = x + 1 ) \\/ ( /\\ x = 8 /\\ UNCHANGED x )", "Next == Action", "Inv == x <= TheOp", "Spec == Init /\\ [][Next]_x", "====", "");
        RunTwiceIsolatedClassLoaderTest.writeFiles(content);
    }

    private static void writeFiles(String specContent) throws IOException {
        Files.createDirectories(SPEC_FILE.getParent(), new FileAttribute[0]);
        Files.writeString(SPEC_FILE, (CharSequence)specContent, new OpenOption[0]);
        Files.writeString(CFG_FILE, (CharSequence)String.join((CharSequence)"\n", "INIT Init", "NEXT Next", "INVARIANT Inv", ""), new OpenOption[0]);
    }
}

