/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TypedSet {
    public static final TypedSet EMPTY_SET = new TypedSet();
    private static final String SEPARATOR = "_";
    private static final String PATTERN = "[\\s]*,[\\s]*";
    private String[] values = new String[0];
    private String type = null;

    public static TypedSet parseSet(String set) {
        TypedSet result = new TypedSet();
        if (set == null) {
            return result;
        }
        if ((set = set.trim()).length() > 0 && set.charAt(0) == '{' && set.charAt(set.length() - 1) == '}') {
            set = set.substring(1, set.length() - 1);
            set = set.trim();
        }
        if ("".equals(set)) {
            return result;
        }
        String[] parsedSet = null;
        parsedSet = set.split(PATTERN);
        if (parsedSet.length > 0) {
            int typeSeparatorPosition = parsedSet[0].indexOf(SEPARATOR);
            if (typeSeparatorPosition == -1 || typeSeparatorPosition == 0) {
                result.setValues(parsedSet);
                return result;
            }
            result.setType(parsedSet[0].substring(0, typeSeparatorPosition));
            parsedSet[0] = parsedSet[0].substring(typeSeparatorPosition + 1);
            boolean typePatternViolated = parsedSet[0].length() == 0;
            int i = 1;
            while (i < parsedSet.length) {
                if (parsedSet[i].startsWith(String.valueOf(result.getType()) + SEPARATOR)) {
                    parsedSet[i] = parsedSet[i].substring(typeSeparatorPosition + 1);
                    if (parsedSet[i].length() == 0) {
                        typePatternViolated = true;
                    }
                } else {
                    typePatternViolated = true;
                }
                if (typePatternViolated) break;
                ++i;
            }
            if (typePatternViolated) {
                result.setValues(set.split(PATTERN));
                result.setType(null);
            } else {
                result.setValues(parsedSet);
            }
        }
        return result;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public static String getTypeOfId(String id) {
        if (id == null || id.length() < 2 || !id.substring(1, 2).equals(SEPARATOR)) {
            return null;
        }
        return id.substring(0, 1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void unsetType() {
        this.setType(null);
    }

    public boolean contains(String value) {
        if (value != null) {
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String aValue = stringArray[n2];
                if (value.equals(aValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String[] getValues() {
        return this.values;
    }

    public List<String> getValuesAsList() {
        if (!this.hasType()) {
            return Arrays.asList(this.values);
        }
        ArrayList<String> typedList = new ArrayList<String>(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            String value = String.valueOf(this.type) + SEPARATOR + this.values[i];
            typedList.add(value);
            ++i;
        }
        return typedList;
    }

    public int getValueCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public String getValue(int index) {
        if (index >= this.getValueCount()) {
            return null;
        }
        return String.valueOf(this.hasType() ? String.valueOf(this.getType()) + SEPARATOR : "") + this.values[index];
    }

    public void setValues(String[] values) {
        this.values = values == null ? new String[0] : values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + TypedSet.hashCode(this.values);
        return result;
    }

    private static int hashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedSet other = (TypedSet)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        int i = 0;
        while (i < this.values.length) {
            if (this.type != null) {
                buffer.append(this.type).append(SEPARATOR);
            }
            buffer.append(this.values[i]);
            if (i != this.values.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toStringWithoutBraces() {
        String set = this.toString();
        return set.substring(1, set.length() - 1);
    }

    @Deprecated
    public boolean hasANumberOnlyValue() {
        if (this.hasType()) {
            return !this.hasValidType();
        }
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].matches("[0-9]*")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasValidType() {
        return this.type == null || this.type.matches("[A-Za-z]{1}[A-Za-z0-9]*");
    }
}

