/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tlc2.tool.distributed.InternRMI;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;
import util.UniqueString;

public final class InternTable
implements Serializable {
    private int count;
    private int length;
    private int thresh;
    private UniqueString[] table;
    private int tokenCnt = 0;
    private InternRMI internSource = null;

    public InternTable(int size) {
        this.table = new UniqueString[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
    }

    private void grow() {
        UniqueString[] old = this.table;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.table = new UniqueString[this.length];
        for (int i = 0; i < old.length; ++i) {
            UniqueString var = old[i];
            if (var == null) continue;
            this.put(var);
        }
    }

    private void put(UniqueString var) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (var.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            UniqueString ent;
            if ((ent = this.table[loc]) == null) {
                this.table[loc] = var;
                ++this.count;
                return;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public UniqueString get(int id) {
        for (int i = 0; i < this.table.length; ++i) {
            UniqueString var = this.table[i];
            if (var == null || var.getTok() != id) continue;
            return var;
        }
        return null;
    }

    private UniqueString create(String str2) {
        if (this.internSource == null) {
            return new UniqueString(str2, ++this.tokenCnt);
        }
        try {
            return this.internSource.intern(str2);
        }
        catch (Exception e2) {
            Assert.fail("Failed to intern " + str2 + ".");
            return null;
        }
    }

    public UniqueString put(String str2) {
        Class<InternTable> clazz = InternTable.class;
        synchronized (InternTable.class) {
            if (this.count >= this.thresh) {
                this.grow();
            }
            int loc = (str2.hashCode() & Integer.MAX_VALUE) % this.length;
            while (true) {
                UniqueString ent;
                if ((ent = this.table[loc]) == null) {
                    UniqueString var;
                    this.table[loc] = var = this.create(str2);
                    ++this.count;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return var;
                }
                if (ent.toString().equals(str2)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ent;
                }
                loc = (loc + 1) % this.length;
            }
        }
    }

    public void beginChkpt(String filename) throws IOException {
        BufferedDataOutputStream dos = new BufferedDataOutputStream(this.chkptName(filename, "tmp"));
        dos.writeInt(this.tokenCnt);
        for (int i = 0; i < this.table.length; ++i) {
            UniqueString var = this.table[i];
            if (var == null) continue;
            var.write(dos);
        }
        dos.close();
    }

    public void commitChkpt(String filename) throws IOException {
        File oldChkpt = new File(this.chkptName(filename, "chkpt"));
        File newChkpt = new File(this.chkptName(filename, "tmp"));
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("InternTable.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public synchronized void recover(String filename) throws IOException {
        BufferedDataInputStream dis = new BufferedDataInputStream(this.chkptName(filename, "chkpt"));
        this.tokenCnt = dis.readInt();
        try {
            while (!dis.atEOF()) {
                UniqueString var = UniqueString.read(dis);
                this.put(var);
            }
        }
        catch (EOFException e2) {
            Assert.fail(2126, e2.getMessage());
        }
        dis.close();
    }

    private String chkptName(String filename, String ext) {
        return filename + FileUtil.separator + "vars." + ext;
    }

    public void setSource(InternRMI source2) {
        this.internSource = source2;
    }

    public UniqueString find(String str2) {
        for (int i = 0; i < this.table.length; ++i) {
            UniqueString var = this.table[i];
            if (var == null || !str2.equals(var.toString())) continue;
            return var;
        }
        return null;
    }

    public final Map<String, UniqueString> toMap() {
        HashMap<String, UniqueString> map2 = new HashMap<String, UniqueString>();
        for (int i = 0; i < this.table.length; ++i) {
            UniqueString var = this.table[i];
            if (var == null) continue;
            map2.put(var.toString(), var);
        }
        return map2;
    }
}

