/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

public final class LongObjTable {
    private int count;
    private int length;
    private int thresh;
    private long[] keys;
    private Object[] elems;

    public LongObjTable(int size) {
        this.keys = new long[size];
        this.elems = new Object[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
    }

    private final void grow() {
        long[] oldKeys = this.keys;
        Object[] oldElems = this.elems;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.keys = new long[this.length];
        this.elems = new Object[this.length];
        for (int i = 0; i < oldKeys.length; ++i) {
            Object elem = oldElems[i];
            if (elem == null) continue;
            this.put(oldKeys[i], elem);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int put(long k, Object elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            if (this.elems[loc] == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (this.keys[loc] == k) {
                this.elems[loc] = elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final Object get(long k) {
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        Object elem;
        while ((elem = this.elems[loc]) != null) {
            if (this.keys[loc] == k) {
                return elem;
            }
            loc = (loc + 1) % this.length;
        }
        return null;
    }
}

