/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tlc2.TLCGlobals;
import tlc2.module.BuiltInModuleHelper;
import tlc2.output.MP;
import tlc2.overrides.Evaluation;
import tlc2.overrides.ITLCOverrides;
import tlc2.overrides.TLAPlusCallable;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.Defns;
import tlc2.tool.EvalException;
import tlc2.tool.Specs;
import tlc2.tool.TLAPlusExecutorState;
import tlc2.tool.TLCStateMut;
import tlc2.tool.ToolGlobals;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.OpDefEvaluator;
import tlc2.tool.impl.SymbolNodeValueLookupProvider;
import tlc2.tool.impl.TLAClass;
import tlc2.tool.impl.TLARegistry;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.util.List;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.IValue;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.CallableValue;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MethodValue;
import tlc2.value.impl.OpRcdValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class SpecProcessor
implements ValueConstants,
ToolGlobals {
    private final String rootFile;
    private final FilenameToStream resolver;
    private final int toolId;
    private final Defns defns;
    private final ModelConfig config;
    private final OpDefEvaluator opDefEvaluator;
    private final SymbolNodeValueLookupProvider symbolNodeValueLookupProvider;
    private final TLAClass tlaClass;
    private OpDeclNode[] variablesNodes;
    private ExternalModuleTable moduleTbl;
    private ModuleNode rootModule;
    private Set<OpDefNode> processedDefs;
    private SpecObj specObj;
    private Defns snapshot;
    private Vect<Action> initPredVec;
    private Action nextPred;
    private Action[] temporals;
    private String[] temporalNames;
    private Action[] impliedTemporals;
    private String[] impliedTemporalNames;
    private Action[] invariants;
    private String[] invNames;
    private Action[] impliedInits;
    private String[] impliedInitNames;
    private Action[] impliedActions;
    private String[] impliedActNames;
    private ExprNode[] modelConstraints;
    private ExprNode[] actionConstraints;
    private ExprNode[] assumptions;
    private boolean[] assumptionIsAxiom;
    private Vect<Action> invVec = new Vect();
    private Vect<String> invNameVec = new Vect();
    private Vect<Action> impliedInitVec = new Vect();
    private Vect<String> impliedInitNameVec = new Vect();
    private Vect<Action> impliedActionVec = new Vect();
    private Vect<String> impliedActNameVec = new Vect();
    private Vect<Action> temporalVec = new Vect();
    private Vect<String> temporalNameVec = new Vect();
    private Vect<Action> impliedTemporalVec = new Vect();
    private Vect<String> impliedTemporalNameVec = new Vect();
    public static final String LAZY_CONSTANT_OPERATORS = SpecProcessor.class.getName() + ".vetoed";
    private static final Set<String> vetos = new HashSet<String>(Arrays.asList(System.getProperty(LAZY_CONSTANT_OPERATORS, "")));

    public SpecProcessor(String rootFile, FilenameToStream resolver, int toolId, Defns defns, ModelConfig config, SymbolNodeValueLookupProvider snvlp, OpDefEvaluator ode, TLAClass tlaClass) {
        this.rootFile = rootFile;
        this.resolver = resolver;
        this.toolId = toolId;
        this.defns = defns;
        this.config = config;
        this.tlaClass = tlaClass;
        this.processedDefs = new HashSet<OpDefNode>();
        this.initPredVec = new Vect(5);
        this.opDefEvaluator = ode;
        this.symbolNodeValueLookupProvider = snvlp;
        this.processSpec();
        this.snapshot = defns.snapshot();
        if (this.opDefEvaluator != null) {
            this.processConstantDefns();
        }
        this.processConfig();
    }

    private void processConstantDefns() {
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i].isInstantiated() && (mods[i].getConstantDecls().length != 0 || mods[i].getVariableDecls().length != 0)) continue;
            this.processConstantDefns(mods[i]);
        }
    }

    private void processConstantDefns(ModuleNode mod2) {
        OpDefNode opDef;
        OpDeclNode[] consts = mod2.getConstantDecls();
        for (int i = 0; i < consts.length; ++i) {
            Object val2 = consts[i].getToolObject(this.toolId);
            if (val2 != null && val2 instanceof IValue) {
                ((IValue)val2).initialize();
                continue;
            }
            if (val2 == null || !(val2 instanceof OpDefNode)) continue;
            opDef = (OpDefNode)val2;
            Assert.check(opDef.getArity() == consts[i].getArity(), 2225, new String[]{consts[i].getName().toString(), opDef.getName().toString()});
            if (opDef.getArity() != 0) continue;
            try {
                Object defVal = WorkerValue.demux(this.opDefEvaluator, consts[i], opDef);
                opDef.setToolObject(this.toolId, defVal);
                continue;
            }
            catch (EvalException | Assert.TLCRuntimeException e2) {
                String addendum = e2 instanceof EvalException ? "" : " - specifically: " + e2.getMessage();
                Assert.fail(2281, new String[]{consts[i].getName().toString(), opDef.getName().toString(), addendum});
            }
        }
        OpDefNode[] opDefs = mod2.getOpDefs();
        for (int i = 0; i < opDefs.length; ++i) {
            Object realDef;
            boolean evaluate;
            opDef = opDefs[i];
            ModuleNode moduleNode = opDef.getOriginallyDefinedInModuleNode();
            boolean bl = evaluate = moduleNode == null || !moduleNode.isInstantiated() || moduleNode.getConstantDecls().length == 0 && moduleNode.getVariableDecls().length == 0;
            if (!evaluate || opDef.getArity() != 0 || !((realDef = this.symbolNodeValueLookupProvider.lookup(opDef, Context.Empty, false, this.toolId)) instanceof OpDefNode) || this.symbolNodeValueLookupProvider.getLevelBound((opDef = (OpDefNode)realDef).getBody(), Context.Empty, this.toolId) != 0) continue;
            try {
                UniqueString opName = opDef.getName();
                if (this.isVetoed(opName)) continue;
                Object val3 = WorkerValue.demux(this.opDefEvaluator, opDef);
                opDef.setToolObject(this.toolId, val3);
                Object def2 = this.defns.get(opName);
                if (def2 != opDef) continue;
                this.defns.put(opName, val3);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ModuleNode[] imods = mod2.getInnerModules();
        for (int i = 0; i < imods.length; ++i) {
            this.processConstantDefns(imods[i]);
        }
    }

    private boolean isVetoed(UniqueString us) {
        return vetos.contains(us.toString());
    }

    private final void processSpec() {
        int i;
        UniqueString modName;
        this.specObj = new SpecObj(this.rootFile, this.resolver);
        if (TLCGlobals.tool) {
            MP.printMessage(2220);
        }
        try {
            SANY.frontEndMain(this.specObj, this.rootFile, ToolIO.out);
        }
        catch (FrontEndException e2) {
            Assert.fail(2171, e2);
        }
        if (TLCGlobals.tool) {
            MP.printMessage(2219);
        }
        MP.printMessage(2185);
        if (!(this.specObj.initErrors.isSuccess() && this.specObj.parseErrors.isSuccess() && this.specObj.semanticErrors.isSuccess())) {
            Assert.fail(3002);
        }
        this.moduleTbl = this.specObj.getExternalModuleTable();
        UniqueString rootName = UniqueString.uniqueStringOf(this.rootFile);
        this.rootModule = this.moduleTbl.getModuleNode(rootName);
        Assert.check(this.rootModule != null, 2171, String.format(" Module-Table lookup failure for module name %s derived from %s file name.", rootName.toString(), this.rootFile));
        OpDeclNode[] varDecls = this.rootModule.getVariableDecls();
        this.variablesNodes = new OpDeclNode[varDecls.length];
        UniqueString[] varNames = new UniqueString[varDecls.length];
        for (int i3 = 0; i3 < varDecls.length; ++i3) {
            this.variablesNodes[i3] = varDecls[i3];
            varNames[i3] = varDecls[i3].getName();
            varNames[i3].setLoc(i3);
        }
        UniqueString.setVariableCount(varDecls.length);
        this.defns.setDefnCount(varDecls.length);
        this.defns.put("TRUE", (Object)BoolValue.ValTrue);
        this.defns.put("FALSE", (Object)BoolValue.ValFalse);
        Value[] elems = new Value[]{BoolValue.ValFalse, BoolValue.ValTrue};
        this.defns.put("BOOLEAN", (Object)new SetEnumValue(elems, true));
        Class stringModule = this.tlaClass.loadClass("Strings");
        if (stringModule == null) {
            Assert.fail(2119);
        }
        Method[] ms = stringModule.getDeclaredMethods();
        for (int i4 = 0; i4 < ms.length; ++i4) {
            int mod2 = ms[i4].getModifiers();
            if (!Modifier.isStatic(mod2)) continue;
            String name2 = TLARegistry.mapName(ms[i4].getName());
            int acnt = ms[i4].getParameterTypes().length;
            if (ms[i4].isSynthetic()) continue;
            this.defns.put(name2, (Object)MethodValue.get(ms[i4]));
        }
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        HashMap<String, ModuleNode> modSet = new HashMap<String, ModuleNode>();
        for (int i5 = 0; i5 < mods.length; ++i5) {
            this.processConstants(mods[i5]);
            modSet.put(mods[i5].getName().toString(), mods[i5]);
        }
        AssumeNode[] assumes = this.rootModule.getAssumptions();
        this.assumptions = new ExprNode[assumes.length];
        this.assumptionIsAxiom = new boolean[assumes.length];
        for (int i6 = 0; i6 < assumes.length; ++i6) {
            this.assumptions[i6] = assumes[i6].getAssume();
            this.assumptionIsAxiom[i6] = assumes[i6].getIsAxiom();
        }
        Hashtable constants = this.initializeConstants();
        Hashtable<String, String> overrides = this.config.getOverrides();
        OpDeclNode[] rootConsts = this.rootModule.getConstantDecls();
        for (int i7 = 0; i7 < rootConsts.length; ++i7) {
            UniqueString name3 = rootConsts[i7].getName();
            Object val2 = constants.get(name3.toString());
            if (val2 == null && !overrides.containsKey(name3.toString())) {
                Assert.fail(2222, name3.toString());
            }
            rootConsts[i7].setToolObject(this.toolId, val2);
            this.defns.put(name3, val2);
        }
        OpDefNode[] rootOpDefs = this.rootModule.getOpDefs();
        for (int i8 = 0; i8 < rootOpDefs.length; ++i8) {
            UniqueString name4 = rootOpDefs[i8].getName();
            Object val3 = constants.get(name4.toString());
            if (val3 == null) {
                this.defns.put(name4, (Object)rootOpDefs[i8]);
                continue;
            }
            rootOpDefs[i8].setToolObject(this.toolId, val3);
            this.defns.put(name4, val3);
        }
        Hashtable<String, Hashtable> modConstants = this.initializeModConstants();
        for (int i2 = 0; i2 < mods.length; ++i2) {
            modName = mods[i2].getName();
            Hashtable mConsts = modConstants.get(modName.toString());
            if (mConsts == null) continue;
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString name5 = opDefs[j].getName();
                Object val4 = mConsts.get(name5.toString());
                if (val4 == null) continue;
                opDefs[j].getBody().setToolObject(this.toolId, val4);
            }
        }
        for (int i2 = 0; i2 < mods.length; ++i2) {
            modName = mods[i2].getName();
            Class userModule = this.tlaClass.loadClass(modName.toString());
            if (userModule == null) continue;
            HashMap<UniqueString, Integer> opname2arity = new HashMap<UniqueString, Integer>();
            if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                for (OpDefNode opDefNode : rootOpDefs) {
                    if (!opDefNode.getOriginallyDefinedInModuleNode().getName().equals(modName)) continue;
                    opname2arity.put(opDefNode.getName(), opDefNode.getArity());
                }
            }
            Hashtable<UniqueString, Value> javaDefs = new Hashtable<UniqueString, Value>();
            Method[] mds = userModule.getDeclaredMethods();
            for (int j = 0; j < mds.length; ++j) {
                Method method = mds[j];
                int mdf = method.getModifiers();
                if (!Modifier.isPublic(mdf) || !Modifier.isStatic(mdf)) continue;
                String string2 = TLARegistry.mapName(method.getName());
                UniqueString uname = UniqueString.uniqueStringOf(string2);
                if (method.getAnnotation(TLAPlusOperator.class) != null) continue;
                int acnt = method.getParameterCount();
                Value val5 = MethodValue.get(method);
                if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                    URL resource2 = userModule.getResource(userModule.getSimpleName() + ".class");
                    Integer arity = (Integer)opname2arity.get(uname);
                    if (arity == null || arity != acnt) {
                        MP.printWarning(2400, uname.toString(), resource2.toExternalForm(), val5.toString());
                        continue;
                    }
                    javaDefs.put(uname, val5);
                    MP.printMessage(2168, uname.toString(), resource2.toExternalForm(), val5.toString());
                    continue;
                }
                javaDefs.put(uname, val5);
            }
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString uname = opDefs[j].getName();
                Object v = javaDefs.get(uname);
                if (v == null) continue;
                opDefs[j].getBody().setToolObject(this.toolId, v);
                this.defns.put(uname, v);
            }
        }
        boolean hasCallableValue = false;
        Class idx = this.tlaClass.loadClass("tlc2.overrides.TLCOverrides");
        if (idx != null && ITLCOverrides.class.isAssignableFrom(idx)) {
            try {
                Class[] candidateClasses;
                ITLCOverrides index2 = (ITLCOverrides)idx.newInstance();
                for (Class c : candidateClasses = index2.get()) {
                    Method[] candidateMethods;
                    for (Method m : candidateMethods = c.getDeclaredMethods()) {
                        OpDefNode opDef;
                        ModuleNode moduleNode;
                        Evaluation evaluation = m.getAnnotation(Evaluation.class);
                        if (evaluation != null) {
                            EvaluatingValue val7 = new EvaluatingValue(m, evaluation.minLevel());
                            ModuleNode moduleNode2 = (ModuleNode)modSet.get(evaluation.module());
                            if (moduleNode2 == null) {
                                if (!evaluation.warn()) continue;
                                MP.printMessage(2402, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val7.toString());
                                continue;
                            }
                            OpDefNode opDef2 = moduleNode2.getOpDef(evaluation.definition());
                            if (opDef2 == null) {
                                if (!evaluation.warn()) continue;
                                MP.printMessage(2403, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val7.toString());
                                continue;
                            }
                            opDef2.getBody().setToolObject(this.toolId, val7);
                            this.defns.put(evaluation.definition(), (Object)val7);
                            MP.printMessage(2168, evaluation.module() + "!" + evaluation.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val7.toString());
                            continue;
                        }
                        TLAPlusCallable jev = m.getAnnotation(TLAPlusCallable.class);
                        if (jev != null) {
                            CallableValue val8 = new CallableValue(m, jev.minLevel());
                            moduleNode = (ModuleNode)modSet.get(jev.module());
                            if (moduleNode == null) {
                                if (!jev.warn()) continue;
                                MP.printMessage(2402, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val8.toString());
                                continue;
                            }
                            opDef = moduleNode.getOpDef(jev.definition());
                            if (opDef == null) {
                                if (!jev.warn()) continue;
                                MP.printMessage(2403, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val8.toString());
                                continue;
                            }
                            opDef.getBody().setToolObject(this.toolId, val8);
                            this.defns.put(jev.definition(), (Object)val8);
                            hasCallableValue = true;
                            MP.printMessage(2168, jev.module() + "!" + jev.definition(), c.getResource(c.getSimpleName() + ".class").toExternalForm(), val8.toString());
                            continue;
                        }
                        TLAPlusOperator opOverrideCandidate = m.getAnnotation(TLAPlusOperator.class);
                        if (opOverrideCandidate == null) continue;
                        moduleNode = (ModuleNode)modSet.get(opOverrideCandidate.module());
                        if (moduleNode == null) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2402, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                            continue;
                        }
                        opDef = moduleNode.getOpDef(opOverrideCandidate.identifier());
                        if (opDef == null) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2403, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                            continue;
                        }
                        Value val9 = MethodValue.get(m, opOverrideCandidate.minLevel());
                        if (opDef.getArity() != m.getParameterCount()) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2400, opDef.getName().toString(), c.getName(), val9.toString());
                            continue;
                        }
                        if (opOverrideCandidate.warn()) {
                            MP.printMessage(2168, opDef.getName().toString(), c.getName(), val9 instanceof MethodValue ? val9.toString() : val9.getClass().getName());
                        }
                        opDef.getBody().setToolObject(this.toolId, val9);
                        this.defns.put(opOverrideCandidate.identifier(), (Object)val9);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException e3) {
                Assert.fail(1000);
                return;
            }
        }
        HashSet<String> overriden = new HashSet<String>();
        for (i = 0; i < rootConsts.length; ++i) {
            Object myVal;
            UniqueString lhs = rootConsts[i].getName();
            String rhs = overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail(2223, rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail(2224, new String[]{lhs.toString(), rhs});
            }
            rootConsts[i].setToolObject(this.toolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        if (hasCallableValue) {
            TLAPlusExecutorState.setVariables(this.variablesNodes);
        } else {
            TLCStateMut.setVariables(this.variablesNodes);
        }
        for (i = 0; i < rootOpDefs.length; ++i) {
            Object myVal;
            UniqueString lhs = rootOpDefs[i].getName();
            String rhs = overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail(2223, rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail(2224, new String[]{lhs.toString(), rhs});
            }
            if (myVal instanceof OpDefNode && rootOpDefs[i].getNumberOfArgs() != ((OpDefNode)myVal).getNumberOfArgs()) {
                Assert.fail(2225, new String[]{lhs.toString(), rhs});
            }
            rootOpDefs[i].setToolObject(this.toolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        Enumeration<String> keys2 = overrides.keys();
        while (keys2.hasMoreElements()) {
            String key2 = keys2.nextElement();
            if (overriden.contains(key2)) continue;
            Assert.fail(2226, key2.toString());
        }
        Hashtable modOverrides = this.config.getModOverrides();
        for (int i9 = 0; i9 < mods.length; ++i9) {
            UniqueString modName2 = mods[i9].getName();
            Hashtable mDefs = (Hashtable)modOverrides.get(modName2.toString());
            HashSet<String> modOverriden = new HashSet<String>();
            if (mDefs == null) continue;
            OpDefNode[] opDefNodeArray = mods[i9].getOpDefs();
            for (int j = 0; j < opDefNodeArray.length; ++j) {
                Object myVal;
                UniqueString lhs = opDefNodeArray[j].getName();
                String rhs = (String)mDefs.get(lhs.toString());
                if (rhs == null) continue;
                if (mDefs.containsKey(rhs)) {
                    Assert.fail(2223, rhs);
                }
                if ((myVal = this.defns.get(rhs)) == null) {
                    Assert.fail(2224, new String[]{lhs.toString(), rhs});
                }
                if (myVal instanceof OpDefNode && opDefNodeArray[j].getNumberOfArgs() != ((OpDefNode)myVal).getNumberOfArgs()) {
                    Assert.fail(2225, new String[]{lhs.toString(), rhs});
                }
                opDefNodeArray[j].getBody().setToolObject(this.toolId, myVal);
                modOverriden.add(lhs.toString());
            }
            Enumeration mkeys = mDefs.keys();
            while (mkeys.hasMoreElements()) {
                Object mkey = mkeys.nextElement();
                if (modOverriden.contains(mkey)) continue;
                Assert.fail(2226, mkey.toString());
            }
        }
        Enumeration modKeys = modOverrides.keys();
        while (modKeys.hasMoreElements()) {
            Object modName3 = modKeys.nextElement();
            if (modSet.keySet().contains(modName3)) continue;
            Assert.fail(2245, modName3.toString());
        }
    }

    private final void processConfig() {
        int i;
        this.processConfigInvariants();
        String specName = this.config.getSpec();
        if (specName.length() == 0) {
            this.processConfigInitAndNext();
        } else {
            Object spec2;
            if (this.config.getInit().length() != 0 || this.config.getNext().length() != 0) {
                Assert.fail(2227);
            }
            if ((spec2 = this.defns.get(specName)) instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)spec2;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{specName});
                }
                this.processConfigSpec(opDef.getBody(), Context.Empty, List.Empty);
            } else if (spec2 == null) {
                Assert.fail(2229, new String[]{"name", specName});
            } else {
                Assert.fail(2230, new String[]{"value", specName, spec2.toString()});
            }
        }
        Vect propNames = this.config.getProperties();
        for (i = 0; i < propNames.size(); ++i) {
            String propName = (String)propNames.elementAt(i);
            Object prop = this.defns.get(propName);
            if (prop instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)prop;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{propName});
                }
                this.processConfigProps(propName, opDef.getBody(), Context.Empty, List.Empty);
                continue;
            }
            if (prop == null) {
                Assert.fail(2229, new String[]{"property", propName});
                continue;
            }
            if (prop instanceof IBoolValue && ((BoolValue)prop).val) continue;
            Assert.fail(2230, new String[]{"property", propName, prop.toString()});
        }
        this.invariants = new Action[this.invVec.size()];
        this.invNames = new String[this.invVec.size()];
        for (i = 0; i < this.invariants.length; ++i) {
            this.invariants[i] = this.invVec.elementAt(i);
            this.invNames[i] = this.invNameVec.elementAt(i);
        }
        this.invVec = null;
        this.invNameVec = null;
        this.impliedInits = new Action[this.impliedInitVec.size()];
        this.impliedInitNames = new String[this.impliedInitVec.size()];
        for (i = 0; i < this.impliedInits.length; ++i) {
            this.impliedInits[i] = this.impliedInitVec.elementAt(i);
            this.impliedInitNames[i] = this.impliedInitNameVec.elementAt(i);
        }
        this.impliedInitVec = null;
        this.impliedInitNameVec = null;
        this.impliedActions = new Action[this.impliedActionVec.size()];
        this.impliedActNames = new String[this.impliedActionVec.size()];
        for (i = 0; i < this.impliedActions.length; ++i) {
            this.impliedActions[i] = this.impliedActionVec.elementAt(i);
            this.impliedActNames[i] = this.impliedActNameVec.elementAt(i);
        }
        this.impliedActionVec = null;
        this.impliedActNameVec = null;
        this.temporals = new Action[this.temporalVec.size()];
        this.temporalNames = new String[this.temporalNameVec.size()];
        for (i = 0; i < this.temporals.length; ++i) {
            this.temporals[i] = this.temporalVec.elementAt(i);
            this.temporalNames[i] = this.temporalNameVec.elementAt(i);
        }
        this.temporalVec = null;
        this.temporalNameVec = null;
        this.impliedTemporals = new Action[this.impliedTemporalVec.size()];
        this.impliedTemporalNames = new String[this.impliedTemporalNameVec.size()];
        for (i = 0; i < this.impliedTemporals.length; ++i) {
            this.impliedTemporals[i] = this.impliedTemporalVec.elementAt(i);
            this.impliedTemporalNames[i] = this.impliedTemporalNameVec.elementAt(i);
        }
        this.impliedTemporalVec = null;
        this.impliedTemporalNameVec = null;
        if (this.initPredVec.size() == 0 && (this.impliedInits.length != 0 || this.impliedActions.length != 0 || this.variablesNodes.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2231);
        }
        if (this.nextPred == null && (this.impliedActions.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2232);
        }
        this.processModelConstraints();
        this.processActionConstraints();
    }

    private void processConfigInitAndNext() {
        OpDefNode def2;
        String name2 = this.config.getInit();
        if (name2.length() != 0) {
            Object init = this.defns.get(name2);
            if (init == null) {
                Assert.fail(2229, new String[]{"initial predicate", name2});
            }
            if (!(init instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"initial predicate", name2});
            }
            if ((def2 = (OpDefNode)init).getArity() != 0) {
                Assert.fail(2228, new String[]{"initial predicate", name2});
            }
            this.initPredVec.addElement(new Action((SemanticNode)def2.getBody(), Context.Empty, def2));
        }
        if ((name2 = this.config.getNext()).length() != 0) {
            Object next2 = this.defns.get(name2);
            if (next2 == null) {
                Assert.fail(2229, new String[]{"next state action", name2});
            }
            if (!(next2 instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"next state action", name2});
            }
            if ((def2 = (OpDefNode)next2).getArity() != 0) {
                Assert.fail(2228, new String[]{"next state action", name2});
            }
            this.nextPred = new Action((SemanticNode)def2.getBody(), Context.Empty, def2);
        }
    }

    private void processConfigInvariants() {
        Vect invs = this.config.getInvariants();
        for (int i = 0; i < invs.size(); ++i) {
            String name2 = (String)invs.elementAt(i);
            Object inv = this.defns.get(name2);
            if (inv instanceof OpDefNode) {
                OpDefNode def2 = (OpDefNode)inv;
                if (def2.getArity() != 0) {
                    Assert.fail(2228, new String[]{"invariant", name2});
                }
                if (def2.getLevel() >= 2) {
                    if (!def2.getBody().levelParams.isEmpty()) {
                        Assert.fail(2146, new String[]{def2.getName().toString(), "includeWarning"});
                    }
                    Assert.fail(2146, def2.getName().toString());
                }
                this.invNameVec.addElement(name2);
                this.invVec.addElement(new Action((SemanticNode)def2.getBody(), Context.Empty, def2));
                continue;
            }
            if (inv == null) {
                Assert.fail(2229, new String[]{"invariant", name2});
                continue;
            }
            if (inv instanceof IBoolValue && ((BoolValue)inv).val) continue;
            Assert.fail(2230, new String[]{"invariant", name2, inv.toString()});
        }
    }

    private final void processConfigSpec(ExprNode pred, Context c, List subs2) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigSpec(pred1.getBody(), c, subs2.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val2 = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
                if (val2 instanceof OpDefNode) {
                    ExprNode body;
                    if (((OpDefNode)val2).getArity() != 0) {
                        Assert.fail(2234, new String[]{opNode.getName().toString()});
                    }
                    if (this.symbolNodeValueLookupProvider.getLevelBound(body = ((OpDefNode)val2).getBody(), c, this.toolId) == 1) {
                        this.initPredVec.addElement(new Action((SemanticNode)Specs.addSubsts(body, subs2), c, (OpDefNode)val2));
                    } else {
                        this.processConfigSpec(body, c, subs2);
                    }
                } else if (val2 == null) {
                    Assert.fail(2235, new String[]{opNode.getName().toString()});
                } else if (val2 instanceof IBoolValue) {
                    if (!((BoolValue)val2).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val2.toString(), "spec"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 55 || opcode == 56) {
                Assert.fail(2301);
            }
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    this.processConfigSpec((ExprNode)args[i], c, subs2);
                }
                return;
            }
            if (opcode == 59) {
                ExprOrOpArgNode boxArg = args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    ExprNode arg = (ExprNode)((OpApplNode)boxArg).getArgs()[0];
                    ExprNode subscript = (ExprNode)((OpApplNode)boxArg).getArgs()[1];
                    Vect<SymbolNode> varsInSubscript = null;
                    try {
                        class SubscriptCollector {
                            Vect<SymbolNode> components = new Vect();

                            SubscriptCollector() {
                            }

                            void enter(ExprNode subscript, Context c) {
                                SymbolNode var = SpecProcessor.this.symbolNodeValueLookupProvider.getVar(subscript, c, false, SpecProcessor.this.toolId);
                                if (var != null) {
                                    this.components.addElement(var);
                                    return;
                                }
                                switch (subscript.getKind()) {
                                    case 9: {
                                        OpApplNode subscript1 = (OpApplNode)subscript;
                                        SymbolNode opNode = subscript1.getOperator();
                                        ExprOrOpArgNode[] args = subscript1.getArgs();
                                        int opCode = BuiltInOPs.getOpCode(opNode.getName());
                                        if (opCode == 23) {
                                            for (int i = 0; i < args.length; ++i) {
                                                this.enter((ExprNode)args[i], c);
                                            }
                                            return;
                                        }
                                        if (opCode != 0) {
                                            return;
                                        }
                                        Object opDef = SpecProcessor.this.symbolNodeValueLookupProvider.lookup(opNode, c, false, SpecProcessor.this.toolId);
                                        if (opDef instanceof OpDefNode) {
                                            OpDefNode opDef1 = (OpDefNode)opDef;
                                            this.enter(opDef1.getBody(), SpecProcessor.this.symbolNodeValueLookupProvider.getOpContext(opDef1, args, c, false, SpecProcessor.this.toolId));
                                            return;
                                        }
                                        if (!(opDef instanceof LazyValue)) break;
                                        LazyValue lv = (LazyValue)opDef;
                                        this.enter((ExprNode)lv.expr, lv.con);
                                        return;
                                    }
                                    case 13: {
                                        SubstInNode subscript1 = (SubstInNode)subscript;
                                        Subst[] subs2 = subscript1.getSubsts();
                                        Context c1 = c;
                                        for (int i = 0; i < subs2.length; ++i) {
                                            c1 = c1.cons(subs2[i].getOp(), SpecProcessor.this.symbolNodeValueLookupProvider.getVal(subs2[i].getExpr(), c, false, SpecProcessor.this.toolId));
                                        }
                                        this.enter(subscript1.getBody(), c1);
                                        return;
                                    }
                                    case 10: {
                                        LetInNode subscript1 = (LetInNode)subscript;
                                        this.enter(subscript1.getBody(), c);
                                        return;
                                    }
                                    case 29: {
                                        LabelNode subscript1 = (LabelNode)subscript;
                                        this.enter((ExprNode)subscript1.getBody(), c);
                                        return;
                                    }
                                    default: {
                                        Assert.fail(2238, subscript.toString());
                                        return;
                                    }
                                }
                            }

                            Vect<SymbolNode> getComponents() {
                                return this.components;
                            }
                        }
                        SubscriptCollector collector = new SubscriptCollector();
                        Context c1 = c;
                        List subs1 = subs2;
                        while (!subs1.isEmpty()) {
                            SubstInNode sn = (SubstInNode)subs1.car();
                            Subst[] snsubs = sn.getSubsts();
                            for (int i = 0; i < snsubs.length; ++i) {
                                c1 = c1.cons(snsubs[i].getOp(), this.symbolNodeValueLookupProvider.getVal(snsubs[i].getExpr(), c, false, this.toolId));
                            }
                            subs1 = subs1.cdr();
                        }
                        collector.enter(subscript, c1);
                        varsInSubscript = collector.getComponents();
                    }
                    catch (Exception e2) {
                        MP.printWarning(2139, new String[0]);
                        varsInSubscript = null;
                    }
                    if (varsInSubscript != null) {
                        for (int i = 0; i < this.variablesNodes.length; ++i) {
                            if (varsInSubscript.contains(this.variablesNodes[i])) continue;
                            MP.printWarning(2140, new String[]{this.variablesNodes[i].getName().toString()});
                        }
                    }
                    if (this.nextPred == null) {
                        this.nextPred = new Action(Specs.addSubsts(arg, subs2), c);
                    } else {
                        Assert.fail(2240);
                    }
                } else {
                    this.temporalVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
                    this.temporalNameVec.addElement(pred.toString());
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigSpec((ExprNode)args[0], c, subs2);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound(pred, c, this.toolId)) <= 1) {
            this.initPredVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
        } else if (level == 3) {
            this.temporalVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
            this.temporalNameVec.addElement(pred.toString());
        } else {
            Assert.fail(2239, pred.toString());
        }
    }

    private final void processConfigProps(String name2, ExprNode pred, Context c, List subs2) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigProps(name2, pred1.getBody(), c, subs2.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val2 = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
                if (val2 instanceof OpDefNode) {
                    if (((OpDefNode)val2).getArity() != 0) {
                        Assert.fail(2234, opNode.getName().toString());
                    }
                    this.processConfigProps(opNode.getName().toString(), ((OpDefNode)val2).getBody(), c, subs2);
                } else if (val2 == null) {
                    Assert.fail(2235, opNode.getName().toString());
                } else if (val2 instanceof IBoolValue) {
                    if (!((BoolValue)val2).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val2.toString(), "property"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    ExprNode conj = (ExprNode)args[i];
                    this.processConfigProps(conj.toString(), conj, c, subs2);
                }
                return;
            }
            if (opcode == 59) {
                ExprNode boxArg = (ExprNode)args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    OpApplNode boxArg1 = (OpApplNode)boxArg;
                    if (boxArg1.getArgs().length == 0) {
                        name2 = boxArg1.getOperator().getName().toString();
                    }
                    this.impliedActNameVec.addElement(name2);
                    this.impliedActionVec.addElement(new Action(Specs.addSubsts(boxArg, subs2), c));
                } else if (this.symbolNodeValueLookupProvider.getLevelBound(boxArg, c, this.toolId) < 2) {
                    this.invVec.addElement(new Action(Specs.addSubsts(boxArg, subs2), c));
                    if (boxArg instanceof OpApplNode && ((OpApplNode)boxArg).getArgs().length == 0) {
                        name2 = ((OpApplNode)boxArg).getOperator().getName().toString();
                    }
                    this.invNameVec.addElement(name2);
                } else {
                    this.impliedTemporalVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
                    this.impliedTemporalNameVec.addElement(name2);
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigProps(name2, (ExprNode)args[0], c, subs2);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound(pred, c, this.toolId)) <= 1) {
            this.impliedInitVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
            this.impliedInitNameVec.addElement(name2);
        } else if (level == 3) {
            this.impliedTemporalVec.addElement(new Action(Specs.addSubsts(pred, subs2), c));
            this.impliedTemporalNameVec.addElement(name2);
        } else {
            Assert.fail(2241, name2);
        }
    }

    private void processActionConstraints() {
        Vect names = this.config.getActionConstraints();
        this.actionConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            Object constr = this.defns.get(name2);
            if (constr instanceof OpDefNode) {
                OpDefNode def2 = (OpDefNode)constr;
                if (def2.getArity() != 0) {
                    Assert.fail(2228, new String[]{"action constraint", name2});
                }
                this.actionConstraints[idx++] = def2.getBody();
                continue;
            }
            if (constr != null) {
                if (constr instanceof IBoolValue && ((BoolValue)constr).val) continue;
                Assert.fail(2230, new String[]{"action constraint", name2, constr.toString()});
                continue;
            }
            Assert.fail(2229, new String[]{"action constraint", name2});
        }
        if (idx < this.actionConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.actionConstraints[i];
            }
            this.actionConstraints = constrs;
        }
    }

    private final void processModelConstraints() {
        Vect names = this.config.getConstraints();
        this.modelConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            Object constr = this.defns.get(name2);
            if (constr instanceof OpDefNode) {
                OpDefNode def2 = (OpDefNode)constr;
                if (def2.getArity() != 0) {
                    Assert.fail(2228, new String[]{"constraint", name2});
                }
                this.modelConstraints[idx++] = def2.getBody();
                continue;
            }
            if (constr != null) {
                if (constr instanceof IBoolValue && ((BoolValue)constr).val) continue;
                Assert.fail(2230, new String[]{"constraint", name2, constr.toString()});
                continue;
            }
            Assert.fail(2229, new String[]{"constraint", name2});
        }
        if (idx < this.modelConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.modelConstraints[i];
            }
            this.modelConstraints = constrs;
        }
    }

    private final void processConstants(SemanticNode expr) {
        switch (expr.getKind()) {
            case 1: {
                ModuleNode expr1 = (ModuleNode)expr;
                OpDefNode[] opDefs = expr1.getOpDefs();
                for (int i = 0; i < opDefs.length; ++i) {
                    Object def2 = opDefs[i].getToolObject(this.toolId);
                    if (def2 instanceof OpDefNode) {
                        this.processedDefs.add((OpDefNode)def2);
                        this.processConstants(((OpDefNode)def2).getBody());
                    }
                    this.processConstants(opDefs[i].getBody());
                }
                ModuleNode[] imods = expr1.getInnerModules();
                for (int i = 0; i < imods.length; ++i) {
                    this.processConstants(imods[i]);
                }
                AssumeNode[] assumps = expr1.getAssumptions();
                for (int i = 0; i < assumps.length; ++i) {
                    this.processConstants(assumps[i]);
                }
                TheoremNode[] thms = expr1.getTheorems();
                for (int i = 0; i < thms.length; ++i) {
                    this.processConstants(thms[i]);
                }
                return;
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                SymbolNode opNode = expr1.getOperator();
                Object val2 = this.defns.get(opNode.getName());
                if (val2 != null) {
                    opNode.setToolObject(this.toolId, val2);
                } else {
                    ExprOrOpArgNode[] args = expr1.getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        this.processConstants(args[i]);
                    }
                    ExprNode[] bnds = expr1.getBdedQuantBounds();
                    for (int i = 0; i < bnds.length; ++i) {
                        this.processConstants(bnds[i]);
                    }
                }
                return;
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                for (int i = 0; i < letDefs.length; ++i) {
                    this.processConstants(letDefs[i].getBody());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs2 = expr1.getSubsts();
                for (int i = 0; i < subs2.length; ++i) {
                    this.processConstants(subs2[i].getExpr());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs3 = expr1.getSubsts();
                for (int i = 0; i < subs3.length; ++i) {
                    this.processConstants(subs3[i].getExpr());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 16: {
                NumeralNode expr1 = (NumeralNode)expr;
                IntValue val3 = IntValue.gen(expr1.val());
                if (expr1.bigVal() != null) {
                    Assert.fail(2265, expr1.toString());
                    return;
                }
                expr1.setToolObject(this.toolId, val3);
                return;
            }
            case 17: {
                DecimalNode expr1 = (DecimalNode)expr;
                Assert.fail(2244, expr1.toString());
                return;
            }
            case 18: {
                StringNode expr1 = (StringNode)expr;
                StringValue val4 = new StringValue(expr1.getRep());
                expr1.setToolObject(this.toolId, val4);
                return;
            }
            case 20: {
                AssumeNode expr1 = (AssumeNode)expr;
                this.processConstants(expr1.getAssume());
                return;
            }
            case 12: {
                TheoremNode expr1 = (TheoremNode)expr;
                this.processConstants(expr1.getTheorem());
                return;
            }
            case 8: {
                OpDefNode opdef;
                SymbolNode opArgNode = ((OpArgNode)expr).getOp();
                if (opArgNode.getKind() == 5 && !this.processedDefs.contains(opdef = (OpDefNode)opArgNode)) {
                    this.processedDefs.add(opdef);
                    this.processConstants(opdef.getBody());
                }
                return;
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                this.processConstants(expr1.getBody());
            }
        }
    }

    private final Hashtable<String, Serializable> makeConstantTable(Vect<Vect<String>> consts) {
        Hashtable<String, Serializable> constTbl = new Hashtable<String, Serializable>();
        for (int i = 0; i < consts.size(); ++i) {
            OpRcdValue opVal;
            Vect<String> line = consts.elementAt(i);
            int len = line.size();
            String name2 = line.elementAt(0);
            if (len <= 2) {
                constTbl.put(name2, (Serializable)((Object)line.elementAt(1)));
                continue;
            }
            Serializable val2 = constTbl.get(name2);
            if (val2 == null) {
                opVal = new OpRcdValue();
                opVal.addLine(line);
                constTbl.put(name2, opVal);
                continue;
            }
            opVal = (OpRcdValue)val2;
            int arity = ((IValue[])opVal.domain.elementAt(0)).length;
            if (len != arity + 2) {
                Assert.fail(2242, name2);
            }
            opVal.addLine(line);
        }
        return constTbl;
    }

    private final Hashtable initializeConstants() {
        Vect consts = this.config.getConstants();
        if (consts == null) {
            return new Hashtable();
        }
        return this.makeConstantTable(consts);
    }

    private final Hashtable<String, Hashtable> initializeModConstants() {
        Hashtable modConstants = this.config.getModConstants();
        Hashtable<String, Hashtable> constants = new Hashtable<String, Hashtable>();
        Enumeration mods = modConstants.keys();
        while (mods.hasMoreElements()) {
            String modName = (String)mods.nextElement();
            constants.put(modName, this.makeConstantTable((Vect)modConstants.get(modName)));
        }
        return constants;
    }

    public ModuleNode getRootModule() {
        return this.rootModule;
    }

    public ExternalModuleTable getModuleTbl() {
        return this.moduleTbl;
    }

    public OpDeclNode[] getVariablesNodes() {
        return this.variablesNodes;
    }

    public Vect<Action> getInitPred() {
        return this.initPredVec;
    }

    public Action getNextPred() {
        return this.nextPred;
    }

    public Action[] getTemporal() {
        return this.temporals;
    }

    public String[] getTemporalNames() {
        return this.temporalNames;
    }

    public Action[] getImpliedTemporals() {
        return this.impliedTemporals;
    }

    public String[] getImpliedTemporalNames() {
        return this.impliedTemporalNames;
    }

    public Action[] getInvariants() {
        return this.invariants;
    }

    public String[] getInvariantsNames() {
        return this.invNames;
    }

    public Action[] getImpliedInits() {
        return this.impliedInits;
    }

    public String[] getImpliedInitNames() {
        return this.impliedInitNames;
    }

    public Action[] getImpliedActions() {
        return this.impliedActions;
    }

    public String[] getImpliedActionNames() {
        return this.impliedActNames;
    }

    public ExprNode[] getModelConstraints() {
        return this.modelConstraints;
    }

    public ExprNode[] getActionConstraints() {
        return this.actionConstraints;
    }

    public ExprNode[] getAssumptions() {
        return this.assumptions;
    }

    public boolean[] getAssumptionIsAxiom() {
        return this.assumptionIsAxiom;
    }

    public SpecObj getSpecObj() {
        return this.specObj;
    }

    public Defns getUnprocessedDefns() {
        return this.snapshot;
    }
}

