/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import util.SetEntry;
import util.SetEnumerator;

public class Set
implements Cloneable,
Serializable {
    private transient SetEntry[] set;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public Set(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.set = new SetEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Set(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Set() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration elements() {
        return new SetEnumerator(this.set);
    }

    public synchronized boolean contains(Object key2) {
        SetEntry[] tab = this.set;
        int hash2 = key2.hashCode();
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        SetEntry e2 = tab[index2];
        while (e2 != null) {
            if (e2.hash == hash2 && e2.key.equals(key2)) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    protected void rehash() {
        int oldCapacity = this.set.length;
        SetEntry[] oldSet = this.set;
        int newCapacity = oldCapacity * 2 + 1;
        SetEntry[] newSet = new SetEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.set = newSet;
        int i = oldCapacity;
        while (i-- > 0) {
            SetEntry old = oldSet[i];
            while (old != null) {
                SetEntry e2 = old;
                old = old.next;
                int index2 = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newSet[index2];
                newSet[index2] = e2;
            }
        }
    }

    public synchronized Object put(Object key2) {
        SetEntry[] tab = this.set;
        int hash2 = key2.hashCode();
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        SetEntry e2 = tab[index2];
        while (e2 != null) {
            if (e2.hash == hash2 && e2.key.equals(key2)) {
                Object old = e2.key;
                e2.key = key2;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key2);
        }
        e2 = new SetEntry();
        e2.hash = hash2;
        e2.key = key2;
        e2.next = tab[index2];
        tab[index2] = e2;
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object key2) {
        SetEntry[] tab = this.set;
        int hash2 = key2.hashCode();
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        SetEntry e2 = tab[index2];
        SetEntry prev2 = null;
        while (e2 != null) {
            if (e2.hash == hash2 && e2.key.equals(key2)) {
                if (prev2 != null) {
                    prev2.next = e2.next;
                } else {
                    tab[index2] = e2.next;
                }
                --this.count;
                return e2.key;
            }
            prev2 = e2;
            e2 = e2.next;
        }
        return null;
    }

    public synchronized void clear() {
        SetEntry[] tab = this.set;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Set t = (Set)super.clone();
            t.set = new SetEntry[this.set.length];
            int i = this.set.length;
            while (i-- > 0) {
                t.set[i] = this.set[i] != null ? (SetEntry)this.set[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int max2 = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e2 = this.elements();
        buf.append("{");
        for (int i = 0; i <= max2; ++i) {
            String s1 = e2.nextElement().toString();
            buf.append(s1);
            if (i >= max2) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.set.length);
        s.writeInt(this.count);
        for (int index2 = this.set.length - 1; index2 >= 0; --index2) {
            SetEntry entry = this.set[index2];
            while (entry != null) {
                s.writeObject(entry.key);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.set = new SetEntry[length];
        this.count = 0;
        while (elements > 0) {
            Object key2 = s.readObject();
            this.put(key2);
            --elements;
        }
    }

    public synchronized boolean in(Object x) {
        return this.contains(x);
    }

    public void intersection(Set x) {
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            Object a = elements.nextElement();
            if (x.in(a)) continue;
            this.remove(a);
        }
    }

    public static Set intersection(Set x, Set y) {
        Set result = new Set();
        if (x.size() < y.size()) {
            result = (Set)x.clone();
            result.intersection(y);
        } else {
            result = (Set)x.clone();
            result.intersection(y);
        }
        return result;
    }

    public void union(Set x) {
        Enumeration elements = x.elements();
        while (elements.hasMoreElements()) {
            this.put(elements.nextElement());
        }
    }

    public static Set union(Set x, Set y) {
        Set result = new Set();
        if (x.size() > y.size()) {
            result = (Set)x.clone();
            result.union(y);
        } else {
            result = (Set)x.clone();
            result.union(y);
        }
        return result;
    }

    public void minus(Set x) {
        if (this.size() > x.size()) {
            Enumeration elements = x.elements();
            while (elements.hasMoreElements()) {
                this.remove(elements.nextElement());
            }
        } else {
            Enumeration elements = this.elements();
            while (elements.hasMoreElements()) {
                Object a = elements.nextElement();
                if (!x.in(a)) continue;
                this.remove(a);
            }
        }
    }

    public static Set minus(Set x, Set y) {
        Set result = (Set)x.clone();
        result.minus(y);
        return result;
    }

    public static Set complement(Set x, Set u) {
        return Set.minus(u, x);
    }

    public boolean subset(Set x) {
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            if (x.in(elements.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static boolean subset(Set x, Set y) {
        return x.subset(y);
    }

    public boolean equal(Set x) {
        return this.subset(x) && x.subset(this);
    }

    public static boolean equal(Set x, Set y) {
        return x.equal(y);
    }
}

