/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.fp;

import java.io.Serializable;
import java.rmi.RemoteException;
import tlc2.tool.distributed.fp.FPSetManager;
import tlc2.tool.distributed.fp.FPSetManagerException;
import tlc2.tool.distributed.fp.FPSetRMI;

public class DynamicFPSetManager
extends FPSetManager
implements Serializable {
    private int expectedNumOfServers;

    public DynamicFPSetManager(int expectedNumOfServers) throws RemoteException {
        this.expectedNumOfServers = expectedNumOfServers;
        if (expectedNumOfServers <= 0) {
            throw new IllegalArgumentException();
        }
        int log = 0;
        while (expectedNumOfServers > 0) {
            expectedNumOfServers /= 2;
            ++log;
        }
        this.mask = (1L << log) - 1L;
    }

    @Override
    public synchronized void register(FPSetRMI aFPSet, String hostname) throws FPSetManagerException {
        if (this.fpSets.size() >= this.expectedNumOfServers) {
            throw new FPSetManagerException("Limit for FPset servers reached (" + this.expectedNumOfServers + "). Cannot handle additional servers");
        }
        this.fpSets.add(new FPSetManager.FPSets(aFPSet, hostname));
    }
}

