/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.management;

import java.lang.management.ManagementFactory;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import tlc2.TLCGlobals;

public abstract class TLCStandardMBean
extends StandardMBean {
    private ObjectName mxbeanName;

    protected TLCStandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    public String getVersion() {
        return TLCGlobals.versionOfTLC;
    }

    public String getRevision() {
        if (TLCGlobals.getRevision() == null) {
            return "N/A";
        }
        return TLCGlobals.getRevision();
    }

    protected boolean registerMBean(String objectName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.mxbeanName = new ObjectName(objectName);
            mbs.registerMBean(this, this.mxbeanName);
        }
        catch (MalformedObjectNameException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (InstanceAlreadyExistsException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e3) {
            e3.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e4) {
            e4.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean unregister() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            if (mbs.isRegistered(this.mxbeanName)) {
                mbs.unregisterMBean(this.mxbeanName);
            }
        }
        catch (MBeanRegistrationException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (InstanceNotFoundException e3) {
            e3.printStackTrace();
            return false;
        }
        return true;
    }

    public static TLCStandardMBean getNullTLCStandardMBean() {
        NullTLCStandardMBean nullTLCStandardMBean = null;
        try {
            nullTLCStandardMBean = new NullTLCStandardMBean();
        }
        catch (NotCompliantMBeanException e2) {
            e2.printStackTrace();
        }
        return nullTLCStandardMBean;
    }

    private static class NullTLCStandardMBean
    extends TLCStandardMBean
    implements DynamicMBean {
        public NullTLCStandardMBean() throws NotCompliantMBeanException {
            super((Class)DynamicMBean.class);
        }

        @Override
        protected boolean registerMBean(String objectName) {
            return true;
        }

        @Override
        public boolean unregister() {
            return true;
        }
    }
}

