/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import model.InJarFilenameToStream;
import model.ModelInJar;
import tlc2.TLCGlobals;
import tlc2.TraceExplorer;
import tlc2.input.MCOutputPipeConsumer;
import tlc2.input.MCParser;
import tlc2.input.MCParserResults;
import tlc2.output.EC;
import tlc2.output.MP;
import tlc2.output.Messages;
import tlc2.output.TLAMonolithCreator;
import tlc2.output.TeeOutputStream;
import tlc2.tool.DFIDModelChecker;
import tlc2.tool.ITool;
import tlc2.tool.ModelChecker;
import tlc2.tool.Simulator;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.SpecProcessor;
import tlc2.tool.management.ModelCheckerMXWrapper;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.DotStateWriter;
import tlc2.util.FP64;
import tlc2.util.IStateWriter;
import tlc2.util.NoopStateWriter;
import tlc2.util.RandomGenerator;
import tlc2.util.StateWriter;
import tlc2.value.RandomEnumerableValues;
import util.Assert;
import util.DebugPrinter;
import util.ExecutionStatisticsCollector;
import util.FileUtil;
import util.FilenameToStream;
import util.MailSender;
import util.SimpleFilenameToStream;
import util.TLCRuntime;
import util.ToolIO;
import util.UniqueString;
import util.UsageGenerator;

public class TLC {
    private static boolean MODEL_PART_OF_JAR = false;
    private RunMode runMode;
    private boolean cleanup = false;
    private boolean deadlock = true;
    private boolean noSeed = true;
    private long seed = 0L;
    private long aril = 0L;
    private long startTime;
    private String mainFile = null;
    private String configFile = null;
    private String metadir;
    private IStateWriter stateWriter = new NoopStateWriter();
    private String fromChkpt = null;
    private int fpIndex;
    private static long traceNum = Long.MAX_VALUE;
    private String traceFile = null;
    private int traceDepth = 100;
    private FilenameToStream resolver = null;
    private boolean welcomePrinted = false;
    private FPSetConfiguration fpSetConfiguration;
    private File temporaryMCOutputLogFile;
    private FileOutputStream temporaryMCOutputStream;
    private File specTETLAFile;
    private MCParserResults mcParserResults;
    private MCOutputPipeConsumer mcOutputConsumer;
    private boolean avoidMonolithSpecTECreation = false;
    private final AtomicBoolean waitingOnGenerationCompletion;

    public TLC() {
        this.runMode = RunMode.MODEL_CHECK;
        this.fpIndex = new Random().nextInt(FP64.Polys.length);
        this.fpSetConfiguration = new FPSetConfiguration();
        this.waitingOnGenerationCompletion = new AtomicBoolean(false);
    }

    public static void main(String[] args) throws Exception {
        TLC tlc = new TLC();
        if (!tlc.handleParameters(args)) {
            System.exit(1);
        }
        if (!tlc.checkEnvironment()) {
            System.exit(1);
        }
        MailSender ms = new MailSender();
        if (MODEL_PART_OF_JAR) {
            tlc.setResolver(new InJarFilenameToStream("/model/"));
        } else {
            String dir2 = FileUtil.parseDirname(tlc.getMainFile());
            if (!dir2.isEmpty()) {
                tlc.setResolver(new SimpleFilenameToStream(dir2));
            } else {
                tlc.setResolver(new SimpleFilenameToStream());
            }
        }
        ms.setModelName(tlc.getModelName());
        ms.setSpecName(tlc.getSpecName());
        int errorCode = tlc.process();
        boolean mailSent = ms.send(tlc.getModuleFiles());
        if (!mailSent) {
            System.exit(1);
        }
        System.exit(EC.ExitStatus.errorConstantToExitStatus(errorCode));
    }

    private boolean checkEnvironment() {
        if (!TLCRuntime.getInstance().isThroughputOptimizedGC()) {
            MP.printWarning(2401);
        }
        return true;
    }

    public static void setTraceNum(int aTraceNum) {
        traceNum = aTraceNum;
    }

    public boolean handleParameters(String[] args) {
        String dumpFile = null;
        boolean asDot = false;
        boolean colorize = false;
        boolean actionLabels = false;
        boolean snapshot = false;
        int index2 = 0;
        while (index2 < args.length) {
            if (args[index2].equals("-simulate")) {
                this.runMode = RunMode.SIMULATE;
                if (++index2 + 1 >= args.length || !args[index2].contains("file=") && !args[index2].contains("num=")) continue;
                String[] simArgs = args[index2].split(",");
                ++index2;
                for (String arg : simArgs) {
                    if (arg.startsWith("num=")) {
                        traceNum = Integer.parseInt(arg.replace("num=", ""));
                        continue;
                    }
                    if (!arg.startsWith("file=")) continue;
                    this.traceFile = arg.replace("file=", "");
                }
                continue;
            }
            if (args[index2].equals("-modelcheck")) {
                ++index2;
                continue;
            }
            if (args[index2].equals("-difftrace")) {
                ++index2;
                TLCGlobals.printDiffsOnly = true;
                continue;
            }
            if (args[index2].equals("-deadlock")) {
                ++index2;
                this.deadlock = false;
                continue;
            }
            if (args[index2].equals("-cleanup")) {
                ++index2;
                this.cleanup = true;
                continue;
            }
            if (args[index2].equals("-nowarning")) {
                ++index2;
                TLCGlobals.warn = false;
                continue;
            }
            if (args[index2].equals("-gzip")) {
                ++index2;
                TLCGlobals.useGZIP = true;
                continue;
            }
            if (args[index2].equals("-terse")) {
                ++index2;
                TLCGlobals.expand = false;
                continue;
            }
            if (args[index2].equals("-continue")) {
                ++index2;
                TLCGlobals.continuation = true;
                continue;
            }
            if (args[index2].equals("-view")) {
                ++index2;
                TLCGlobals.useView = true;
                continue;
            }
            if (args[index2].equals("-debug")) {
                ++index2;
                TLCGlobals.debug = true;
                continue;
            }
            if (args[index2].equals("-tool")) {
                ++index2;
                TLCGlobals.tool = true;
                continue;
            }
            if (args[index2].equals("-generateSpecTE")) {
                TLCGlobals.tool = true;
                if (++index2 < args.length && args[index2].equals("nomonolith")) {
                    ++index2;
                    this.avoidMonolithSpecTECreation = true;
                }
                try {
                    this.temporaryMCOutputLogFile = File.createTempFile("mcout_", ".out");
                    this.temporaryMCOutputLogFile.deleteOnExit();
                    this.temporaryMCOutputStream = new FileOutputStream(this.temporaryMCOutputLogFile);
                    BufferedOutputStream bos = new BufferedOutputStream(this.temporaryMCOutputStream);
                    PipedInputStream pis = new PipedInputStream();
                    TeeOutputStream tos1 = new TeeOutputStream(bos, new PipedOutputStream(pis));
                    TeeOutputStream tos2 = new TeeOutputStream(ToolIO.out, tos1);
                    ToolIO.out = new PrintStream(tos2);
                    this.mcOutputConsumer = new MCOutputPipeConsumer(pis, null);
                    Runnable r = () -> {
                        boolean haveClosedOutputStream = false;
                        try {
                            Object tempTLA;
                            this.waitingOnGenerationCompletion.set(true);
                            this.mcOutputConsumer.consumeOutput(false);
                            bos.flush();
                            this.temporaryMCOutputStream.close();
                            haveClosedOutputStream = true;
                            if (this.mcOutputConsumer.getError() != null) {
                                TLAMonolithCreator monolithCreator;
                                tempTLA = File.createTempFile("temp_tlc_tla_", ".tla");
                                ((File)tempTLA).deleteOnExit();
                                FileUtil.copyFile(this.specTETLAFile, (File)tempTLA);
                                FileOutputStream fos = new FileOutputStream(this.specTETLAFile);
                                FileInputStream mcOutFIS = new FileInputStream(this.temporaryMCOutputLogFile);
                                TLC.copyStream(mcOutFIS, fos);
                                FileInputStream tempTLAFIS = new FileInputStream((File)tempTLA);
                                TLC.copyStream(tempTLAFIS, fos);
                                fos.close();
                                mcOutFIS.close();
                                tempTLAFIS.close();
                                if (this.avoidMonolithSpecTECreation) {
                                    monolithCreator = new TLAMonolithCreator("SpecTE", this.mcOutputConsumer.getSourceDirectory(), this.mcParserResults.getAllExtendedModules());
                                } else {
                                    List<File> extendedModules = this.mcOutputConsumer.getExtendedModuleLocations();
                                    monolithCreator = new TLAMonolithCreator("SpecTE", this.mcOutputConsumer.getSourceDirectory(), extendedModules, this.mcParserResults.getAllExtendedModules(), this.mcParserResults.getAllInstantiatedModules());
                                }
                                monolithCreator.copy();
                            }
                            this.waitingOnGenerationCompletion.set(false);
                            tempTLA = this;
                            synchronized (tempTLA) {
                                this.notifyAll();
                            }
                        }
                        catch (Exception e2) {
                            MP.printMessage(1000, "A model checking error occurred while parsing tool output; the execution ended before the potential SpecTE generation stage.");
                        }
                        finally {
                            if (!haveClosedOutputStream) {
                                try {
                                    bos.flush();
                                    this.temporaryMCOutputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    };
                    new Thread(r).start();
                    MP.printMessage(1000, "Will generate a SpecTE file pair if error states are encountered.");
                }
                catch (IOException ioe) {
                    this.printErrorMsg("Failed to set up piped output consumers; no potential SpecTE will be generated: " + ioe.getMessage());
                    this.mcOutputConsumer = null;
                }
                continue;
            }
            if (args[index2].equals("-help") || args[index2].equals("-h")) {
                this.printUsage();
                return false;
            }
            if (args[index2].equals("-lncheck")) {
                if (++index2 < args.length) {
                    TLCGlobals.lnCheck = args[index2].toLowerCase();
                    ++index2;
                    continue;
                }
                this.printErrorMsg("Error: expect a strategy such as final for -lncheck option.");
                return false;
            }
            if (args[index2].equals("-config")) {
                if (++index2 < args.length) {
                    this.configFile = args[index2];
                    if (this.configFile.endsWith(".cfg")) {
                        this.configFile = this.configFile.substring(0, this.configFile.length() - ".cfg".length());
                    }
                    ++index2;
                    continue;
                }
                this.printErrorMsg("Error: expect a file name for -config option.");
                return false;
            }
            if (args[index2].equals("-dump")) {
                if (++index2 + 1 < args.length && args[index2].startsWith("dot")) {
                    String dotArgs = args[index2].toLowerCase();
                    asDot = true;
                    colorize = dotArgs.contains("colorize");
                    actionLabels = dotArgs.contains("actionlabels");
                    snapshot = dotArgs.contains("snapshot");
                    int n = ++index2;
                    ++index2;
                    dumpFile = TLC.getDumpFile(args[n], ".dot");
                    continue;
                }
                if (index2 < args.length) {
                    dumpFile = TLC.getDumpFile(args[index2++], ".dump");
                    continue;
                }
                this.printErrorMsg("Error: A file name for dumping states required.");
                return false;
            }
            if (args[index2].equals("-coverage")) {
                if (++index2 < args.length) {
                    try {
                        TLCGlobals.coverageInterval = Integer.parseInt(args[index2]) * 60 * 1000;
                        if (TLCGlobals.coverageInterval < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -coverage option.");
                            return false;
                        }
                        ++index2;
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        this.printErrorMsg("Error: An integer for coverage report interval required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: coverage report interval required.");
                return false;
            }
            if (args[index2].equals("-checkpoint")) {
                if (++index2 < args.length) {
                    try {
                        TLCGlobals.chkptDuration = Integer.parseInt(args[index2]) * 1000 * 60;
                        if (TLCGlobals.chkptDuration < 0L) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -checkpoint option.");
                            return false;
                        }
                        ++index2;
                        continue;
                    }
                    catch (Exception e3) {
                        this.printErrorMsg("Error: An integer for checkpoint interval is required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: checkpoint interval required.");
                return false;
            }
            if (args[index2].equals("-depth")) {
                if (++index2 < args.length) {
                    try {
                        this.traceDepth = Integer.parseInt(args[index2]);
                        ++index2;
                        continue;
                    }
                    catch (Exception e4) {
                        this.printErrorMsg("Error: An integer for trace length required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: trace length required.");
                return false;
            }
            if (args[index2].equals("-seed")) {
                if (++index2 < args.length) {
                    try {
                        this.seed = Long.parseLong(args[index2]);
                        ++index2;
                        this.noSeed = false;
                        continue;
                    }
                    catch (Exception e5) {
                        this.printErrorMsg("Error: An integer for seed required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: seed required.");
                return false;
            }
            if (args[index2].equals("-aril")) {
                if (++index2 < args.length) {
                    try {
                        this.aril = Long.parseLong(args[index2]);
                        ++index2;
                        continue;
                    }
                    catch (Exception e6) {
                        this.printErrorMsg("Error: An integer for aril required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: aril required.");
                return false;
            }
            if (args[index2].equals("-maxSetSize")) {
                if (++index2 < args.length) {
                    try {
                        int bound = Integer.parseInt(args[index2]);
                        if (!TLCGlobals.isValidSetSize(bound)) {
                            int maxValue = Integer.MAX_VALUE;
                            this.printErrorMsg("Error: Value in interval [0, " + maxValue + "] for maxSetSize required. But encountered " + args[index2]);
                            return false;
                        }
                        TLCGlobals.setBound = bound;
                        ++index2;
                        continue;
                    }
                    catch (Exception e7) {
                        this.printErrorMsg("Error: An integer for maxSetSize required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: maxSetSize required.");
                return false;
            }
            if (args[index2].equals("-recover")) {
                if (++index2 < args.length) {
                    this.fromChkpt = args[index2++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory for recovery.");
                return false;
            }
            if (args[index2].equals("-metadir")) {
                if (++index2 < args.length) {
                    TLCGlobals.metaDir = args[index2++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory.");
                return false;
            }
            if (args[index2].equals("-userFile")) {
                if (++index2 < args.length) {
                    try {
                        tlc2.module.TLC.OUTPUT = new BufferedWriter(new FileWriter(new File(args[index2++])));
                        continue;
                    }
                    catch (IOException e8) {
                        this.printErrorMsg("Error: Failed to create user output log file.");
                        return false;
                    }
                }
                this.printErrorMsg("Error: need to specify the full qualified file.");
                return false;
            }
            if (args[index2].equals("-workers")) {
                if (++index2 < args.length) {
                    try {
                        int num2 = Integer.parseInt(args[index2]);
                        if (num2 < 1) {
                            this.printErrorMsg("Error: at least one worker required.");
                            return false;
                        }
                        TLCGlobals.setNumWorkers(num2);
                        ++index2;
                        continue;
                    }
                    catch (Exception e9) {
                        this.printErrorMsg("Error: worker number required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer for -workers option.");
                return false;
            }
            if (args[index2].equals("-dfid")) {
                if (++index2 < args.length) {
                    try {
                        TLCGlobals.DFIDMax = Integer.parseInt(args[index2]);
                        if (TLCGlobals.DFIDMax < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                            return false;
                        }
                        ++index2;
                        continue;
                    }
                    catch (Exception e10) {
                        this.printErrorMsg("Errorexpect a nonnegative integer for -dfid option. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                return false;
            }
            if (args[index2].equals("-fp")) {
                if (++index2 < args.length) {
                    try {
                        this.fpIndex = Integer.parseInt(args[index2]);
                        if (this.fpIndex < 0 || this.fpIndex >= FP64.Polys.length) {
                            this.printErrorMsg("Error: The number for -fp must be between 0 and " + (FP64.Polys.length - 1) + " (inclusive).");
                            return false;
                        }
                        ++index2;
                        continue;
                    }
                    catch (Exception e11) {
                        this.printErrorMsg("Error: A number for -fp is required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer for -workers option.");
                return false;
            }
            if (args[index2].equals("-fpmem")) {
                if (++index2 < args.length) {
                    try {
                        double fpMemSize = Double.parseDouble(args[index2]);
                        if (fpMemSize < 0.0) {
                            this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index2]);
                            return false;
                        }
                        if (fpMemSize > 1.0) {
                            ToolIO.out.println("Using -fpmem with an abolute memory value has been deprecated. Please allocate memory for the TLC process via the JVM mechanisms and use -fpmem to set the fraction to be used for fingerprint storage.");
                            this.fpSetConfiguration.setMemory((long)fpMemSize);
                            this.fpSetConfiguration.setRatio(1.0);
                        } else {
                            this.fpSetConfiguration.setRatio(fpMemSize);
                        }
                        ++index2;
                        continue;
                    }
                    catch (Exception e12) {
                        this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpset memory size required.");
                return false;
            }
            if (args[index2].equals("-fpbits")) {
                if (++index2 < args.length) {
                    try {
                        int fpBits = Integer.parseInt(args[index2]);
                        if (!FPSet.isValid(fpBits)) {
                            this.printErrorMsg("Error: Value in interval [0, 30] for fpbits required. But encountered " + args[index2]);
                            return false;
                        }
                        this.fpSetConfiguration.setFpBits(fpBits);
                        ++index2;
                        continue;
                    }
                    catch (Exception e13) {
                        this.printErrorMsg("Error: An integer for fpbits required. But encountered " + args[index2]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpbits required.");
                return false;
            }
            if (args[index2].charAt(0) == '-') {
                this.printErrorMsg("Error: unrecognized option: " + args[index2]);
                return false;
            }
            if (this.mainFile != null) {
                this.printErrorMsg("Error: more than one input files: " + this.mainFile + " and " + args[index2]);
                return false;
            }
            this.mainFile = args[index2++];
            if (!this.mainFile.endsWith(".tla")) continue;
            this.mainFile = this.mainFile.substring(0, this.mainFile.length() - ".tla".length());
        }
        this.startTime = System.currentTimeMillis();
        if (this.mainFile == null) {
            if (ModelInJar.hasModel()) {
                MODEL_PART_OF_JAR = true;
                ModelInJar.loadProperties();
                TLCGlobals.tool = true;
                TLCGlobals.chkptDuration = 0L;
                this.mainFile = "MC";
            } else {
                this.printErrorMsg("Error: Missing input TLA+ module.");
                return false;
            }
        }
        File f = new File(this.mainFile);
        String specDir = "";
        if (f.isAbsolute()) {
            specDir = f.getParent() + FileUtil.separator;
            this.mainFile = f.getName();
            ToolIO.setUserDir(specDir);
        }
        if (this.configFile == null) {
            this.configFile = this.mainFile;
        }
        if (this.cleanup && this.fromChkpt == null) {
            FileUtil.deleteDir("states", true);
        }
        this.metadir = FileUtil.makeMetaDir(new Date(this.startTime), specDir, this.fromChkpt);
        if (dumpFile != null) {
            if (dumpFile.startsWith("${metadir}")) {
                dumpFile = dumpFile.replace("${metadir}", this.metadir);
            }
            try {
                this.stateWriter = asDot ? new DotStateWriter(dumpFile, colorize, actionLabels, snapshot) : new StateWriter(dumpFile);
            }
            catch (IOException e14) {
                this.printErrorMsg(String.format("Error: Given file name %s for dumping states invalid.", dumpFile));
                return false;
            }
        }
        if (TLCGlobals.debug) {
            StringBuilder buffer = new StringBuilder("TLC arguments:");
            for (int i = 0; i < args.length; ++i) {
                buffer.append(args[i]);
                if (i >= args.length - 1) continue;
                buffer.append(" ");
            }
            buffer.append("\n");
            DebugPrinter.print(buffer.toString());
        }
        this.printWelcome();
        return true;
    }

    private static String getDumpFile(String dumpFile, String suffix) {
        if (dumpFile.endsWith(suffix)) {
            return dumpFile;
        }
        return dumpFile + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int process() {
        int tool2222;
        TLCStandardMBean modelCheckerMXWrapper;
        block74: {
            int result;
            modelCheckerMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
            if (this.fromChkpt != null) {
                UniqueString.internTbl.recover(this.fromChkpt);
            }
            FP64.Init(this.fpIndex);
            RandomGenerator rng = new RandomGenerator();
            if (RunMode.SIMULATE.equals((Object)this.runMode)) {
                Simulator simulator;
                if (this.noSeed) {
                    this.seed = rng.nextLong();
                    rng.setSeed(this.seed);
                } else {
                    rng.setSeed(this.seed, this.aril);
                }
                this.printStartupBanner(2188, TLC.getSimulationRuntime(this.seed));
                TLCGlobals.simulator = simulator = new Simulator(this.mainFile, this.configFile, this.traceFile, this.deadlock, this.traceDepth, traceNum, rng, this.seed, this.resolver, TLCGlobals.getNumWorkers());
                result = simulator.simulate();
            } else {
                if (this.noSeed) {
                    this.seed = rng.nextLong();
                }
                RandomEnumerableValues.setSeed(this.seed);
                this.printStartupBanner(TLC.isBFS() ? 2187 : 2271, TLC.getModelCheckingRuntime(this.fpIndex, this.fpSetConfiguration));
                FastTool tool2222 = new FastTool(this.mainFile, this.configFile, this.resolver);
                boolean bl = this.deadlock = this.deadlock && tool2222.getModelConfig().getCheckDeadlock();
                if (TLC.isBFS()) {
                    TLCGlobals.mainChecker = new ModelChecker((ITool)tool2222, this.metadir, this.stateWriter, this.deadlock, this.fromChkpt, FPSetFactory.getFPSetInitialized(this.fpSetConfiguration, this.metadir, new File(this.mainFile).getName()), this.startTime);
                    modelCheckerMXWrapper = new ModelCheckerMXWrapper((ModelChecker)TLCGlobals.mainChecker, this);
                    result = TLCGlobals.mainChecker.modelCheck();
                } else {
                    TLCGlobals.mainChecker = new DFIDModelChecker(tool2222, this.metadir, this.stateWriter, this.deadlock, this.fromChkpt, this.startTime);
                    result = TLCGlobals.mainChecker.modelCheck();
                }
                if (this.mcOutputConsumer != null && this.mcOutputConsumer.getError() != null) {
                    SpecProcessor sp = tool2222.getSpecProcessor();
                    ModelConfig mc = tool2222.getModelConfig();
                    File sourceDirectory = this.mcOutputConsumer.getSourceDirectory();
                    String originalSpecName = this.mcOutputConsumer.getSpecName();
                    MP.printMessage(1000, "The model check run produced error-states - we will generate the SpecTE files now.");
                    this.mcParserResults = MCParser.generateResultsFromProcessorAndConfig(sp, mc);
                    File[] files = TraceExplorer.writeSpecTEFiles(sourceDirectory, originalSpecName, this.mcParserResults, this.mcOutputConsumer.getError());
                    this.specTETLAFile = files[0];
                }
            }
            tool2222 = result;
            if (tlc2.module.TLC.OUTPUT == null) break block74;
            try {
                tlc2.module.TLC.OUTPUT.flush();
                tlc2.module.TLC.OUTPUT.close();
            }
            catch (IOException sp) {
                // empty catch block
            }
        }
        modelCheckerMXWrapper.unregister();
        long runtime = System.currentTimeMillis() - this.startTime;
        MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime) + "ms" : TLC.convertRuntimeToHumanReadable(runtime));
        MP.flush();
        while (this.waitingOnGenerationCompletion.get()) {
            TLC tLC = this;
            synchronized (tLC) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return tool2222;
        catch (Throwable e2) {
            int n;
            block83: {
                block81: {
                    int n2;
                    block82: {
                        block79: {
                            int n3;
                            block80: {
                                block77: {
                                    int n4;
                                    block78: {
                                        block75: {
                                            int n5;
                                            block76: {
                                                if (!(e2 instanceof StackOverflowError)) break block75;
                                                System.gc();
                                                n5 = MP.printError(1005, e2);
                                                if (tlc2.module.TLC.OUTPUT == null) break block76;
                                                try {
                                                    tlc2.module.TLC.OUTPUT.flush();
                                                    tlc2.module.TLC.OUTPUT.close();
                                                }
                                                catch (IOException tool2222) {
                                                    // empty catch block
                                                }
                                            }
                                            modelCheckerMXWrapper.unregister();
                                            long runtime2 = System.currentTimeMillis() - this.startTime;
                                            MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime2) + "ms" : TLC.convertRuntimeToHumanReadable(runtime2));
                                            MP.flush();
                                            while (this.waitingOnGenerationCompletion.get()) {
                                                TLC tLC = this;
                                                synchronized (tLC) {
                                                    try {
                                                        this.wait();
                                                    }
                                                    catch (InterruptedException interruptedException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            return n5;
                                        }
                                        if (!(e2 instanceof OutOfMemoryError)) break block77;
                                        System.gc();
                                        n4 = MP.printError(1001, e2);
                                        if (tlc2.module.TLC.OUTPUT == null) break block78;
                                        try {
                                            tlc2.module.TLC.OUTPUT.flush();
                                            tlc2.module.TLC.OUTPUT.close();
                                        }
                                        catch (IOException runtime2) {
                                            // empty catch block
                                        }
                                    }
                                    modelCheckerMXWrapper.unregister();
                                    long runtime3 = System.currentTimeMillis() - this.startTime;
                                    MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime3) + "ms" : TLC.convertRuntimeToHumanReadable(runtime3));
                                    MP.flush();
                                    while (this.waitingOnGenerationCompletion.get()) {
                                        TLC tLC = this;
                                        synchronized (tLC) {
                                            try {
                                                this.wait();
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    return n4;
                                }
                                if (!(e2 instanceof Assert.TLCRuntimeException)) break block79;
                                n3 = MP.printTLCRuntimeException((Assert.TLCRuntimeException)e2);
                                if (tlc2.module.TLC.OUTPUT == null) break block80;
                                try {
                                    tlc2.module.TLC.OUTPUT.flush();
                                    tlc2.module.TLC.OUTPUT.close();
                                }
                                catch (IOException runtime3) {
                                    // empty catch block
                                }
                            }
                            modelCheckerMXWrapper.unregister();
                            long runtime4 = System.currentTimeMillis() - this.startTime;
                            MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime4) + "ms" : TLC.convertRuntimeToHumanReadable(runtime4));
                            MP.flush();
                            while (this.waitingOnGenerationCompletion.get()) {
                                TLC tLC = this;
                                synchronized (tLC) {
                                    try {
                                        this.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return n3;
                        }
                        if (!(e2 instanceof RuntimeException)) break block81;
                        n2 = MP.printError(1000, e2);
                        if (tlc2.module.TLC.OUTPUT == null) break block82;
                        try {
                            tlc2.module.TLC.OUTPUT.flush();
                            tlc2.module.TLC.OUTPUT.close();
                        }
                        catch (IOException runtime4) {
                            // empty catch block
                        }
                    }
                    modelCheckerMXWrapper.unregister();
                    long runtime5 = System.currentTimeMillis() - this.startTime;
                    MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime5) + "ms" : TLC.convertRuntimeToHumanReadable(runtime5));
                    MP.flush();
                    while (this.waitingOnGenerationCompletion.get()) {
                        TLC tLC = this;
                        synchronized (tLC) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    return n2;
                }
                n = MP.printError(1000, e2);
                if (tlc2.module.TLC.OUTPUT == null) break block83;
                try {
                    tlc2.module.TLC.OUTPUT.flush();
                    tlc2.module.TLC.OUTPUT.close();
                }
                catch (IOException runtime5) {
                    // empty catch block
                }
            }
            modelCheckerMXWrapper.unregister();
            long runtime6 = System.currentTimeMillis() - this.startTime;
            MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime6) + "ms" : TLC.convertRuntimeToHumanReadable(runtime6));
            MP.flush();
            while (this.waitingOnGenerationCompletion.get()) {
                TLC tLC = this;
                synchronized (tLC) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return n;
            catch (Throwable throwable) {
                if (tlc2.module.TLC.OUTPUT != null) {
                    try {
                        tlc2.module.TLC.OUTPUT.flush();
                        tlc2.module.TLC.OUTPUT.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                modelCheckerMXWrapper.unregister();
                long runtime7 = System.currentTimeMillis() - this.startTime;
                MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime7) + "ms" : TLC.convertRuntimeToHumanReadable(runtime7));
                MP.flush();
                while (this.waitingOnGenerationCompletion.get()) {
                    TLC tLC = this;
                    synchronized (tLC) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    private static boolean isBFS() {
        return TLCGlobals.DFIDMax == -1;
    }

    public static Map<String, String> getSimulationRuntime(long seed) {
        Runtime runtime = Runtime.getRuntime();
        long heapMemory = runtime.maxMemory() / 1024L / 1024L;
        TLCRuntime tlcRuntime = TLCRuntime.getInstance();
        long offHeapMemory = tlcRuntime.getNonHeapPhysicalMemory() / 1024L / 1024L;
        long pid = tlcRuntime.pid();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("seed", String.valueOf(seed));
        result.put("workers", String.valueOf(TLCGlobals.getNumWorkers()));
        result.put("plural", TLCGlobals.getNumWorkers() == 1 ? "" : "s");
        result.put("cores", Integer.toString(runtime.availableProcessors()));
        result.put("osName", System.getProperty("os.name"));
        result.put("osVersion", System.getProperty("os.version"));
        result.put("osArch", System.getProperty("os.arch"));
        result.put("jvmVendor", System.getProperty("java.vendor"));
        result.put("jvmVersion", System.getProperty("java.version"));
        result.put("jvmArch", tlcRuntime.getArchitecture().name());
        result.put("jvmHeapMem", Long.toString(heapMemory));
        result.put("jvmOffHeapMem", Long.toString(offHeapMemory));
        result.put("jvmPid", pid == -1L ? "" : String.valueOf(pid));
        return result;
    }

    public static Map<String, String> getModelCheckingRuntime(int fpIndex, FPSetConfiguration fpSetConfig) {
        Runtime runtime = Runtime.getRuntime();
        long heapMemory = runtime.maxMemory() / 1024L / 1024L;
        TLCRuntime tlcRuntime = TLCRuntime.getInstance();
        long offHeapMemory = tlcRuntime.getNonHeapPhysicalMemory() / 1024L / 1024L;
        long pid = tlcRuntime.pid();
        String fpSetClassSimpleName = fpSetConfig.getImplementation().substring(fpSetConfig.getImplementation().lastIndexOf(".") + 1);
        String stateQueueClassSimpleName = ModelChecker.getStateQueueName();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("workers", String.valueOf(TLCGlobals.getNumWorkers()));
        result.put("plural", TLCGlobals.getNumWorkers() == 1 ? "" : "s");
        result.put("cores", Integer.toString(runtime.availableProcessors()));
        result.put("osName", System.getProperty("os.name"));
        result.put("osVersion", System.getProperty("os.version"));
        result.put("osArch", System.getProperty("os.arch"));
        result.put("jvmVendor", System.getProperty("java.vendor"));
        result.put("jvmVersion", System.getProperty("java.version"));
        result.put("jvmArch", tlcRuntime.getArchitecture().name());
        result.put("jvmHeapMem", Long.toString(heapMemory));
        result.put("jvmOffHeapMem", Long.toString(offHeapMemory));
        result.put("seed", Long.toString(RandomEnumerableValues.getSeed()));
        result.put("fpidx", Integer.toString(fpIndex));
        result.put("jvmPid", pid == -1L ? "" : String.valueOf(pid));
        result.put("fpset", fpSetClassSimpleName);
        result.put("queue", stateQueueClassSimpleName);
        return result;
    }

    public static String convertRuntimeToHumanReadable(long runtime) {
        SimpleDateFormat df = null;
        if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else {
            df = runtime > 3600000L ? new SimpleDateFormat("HH'h' mm'min'") : (runtime > 60000L ? new SimpleDateFormat("mm'min' ss's'") : new SimpleDateFormat("ss's'"));
        }
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(runtime);
    }

    public List<File> getModuleFiles() {
        ArrayList<File> result = new ArrayList<File>();
        if (TLCGlobals.mainChecker instanceof ModelChecker) {
            ModelChecker mc = (ModelChecker)TLCGlobals.mainChecker;
            result.addAll(mc.getModuleFiles(this.resolver));
            if (ModelInJar.hasCfg()) {
                result.add(ModelInJar.getCfg());
            }
        }
        return result;
    }

    public void setResolver(FilenameToStream resolver) {
        this.resolver = resolver;
        ToolIO.setDefaultResolver(resolver);
    }

    private void printErrorMsg(String msg) {
        this.printWelcome();
        MP.printError(1102, msg);
    }

    private void printWelcome() {
        if (!this.welcomePrinted) {
            this.welcomePrinted = true;
            if (TLCGlobals.getRevision() == null) {
                MP.printMessage(2262, TLCGlobals.versionOfTLC);
            } else {
                MP.printMessage(2262, TLCGlobals.versionOfTLC + " (rev: " + TLCGlobals.getRevision() + ")");
            }
        }
    }

    private void printStartupBanner(int mode, Map<String, String> parameters) {
        MP.printMessage(mode, parameters.values().toArray(new String[parameters.size()]));
        LinkedHashMap<String, String> udc = new LinkedHashMap<String, String>();
        udc.put("ver", TLCGlobals.getRevisionOrDev());
        udc.put("mode", TLC.mode2String(mode));
        parameters.remove("plural");
        parameters.remove("jvmPid");
        parameters.remove("fpidx");
        parameters.remove("seed");
        udc.putAll(parameters);
        udc.put("toolbox", Boolean.toString(TLCGlobals.tool));
        udc.put("ide", System.getProperty(TLC.class.getName() + ".ide", TLCGlobals.tool ? "toolbox" : "cli"));
        new ExecutionStatisticsCollector().collect(udc);
    }

    private static String mode2String(int mode) {
        switch (mode) {
            case 2187: {
                return "bfs";
            }
            case 2271: {
                return "dfs";
            }
            case 2188: {
                return "simulation";
            }
        }
        return "unknown";
    }

    private static long copyStream(InputStream is2, OutputStream os) throws IOException {
        int n;
        BufferedOutputStream bos;
        byte[] buffer = new byte[4096];
        long byteCount = 0L;
        BufferedInputStream bis = is2 instanceof BufferedInputStream ? (BufferedInputStream)is2 : new BufferedInputStream(is2);
        BufferedOutputStream bufferedOutputStream = bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        while ((n = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, n);
            byteCount += (long)n;
        }
        bos.flush();
        return byteCount;
    }

    private void printUsage() {
        ArrayList<List<UsageGenerator.Argument>> commandVariants = new ArrayList<List<UsageGenerator.Argument>>();
        ArrayList<UsageGenerator.Argument> sharedArguments = new ArrayList<UsageGenerator.Argument>();
        sharedArguments.add(new UsageGenerator.Argument("-checkpoint", "minutes", "interval between check point; defaults to 30", true));
        sharedArguments.add(new UsageGenerator.Argument("-cleanup", "clean up the states directory", true));
        sharedArguments.add(new UsageGenerator.Argument("-config", "file", "provide the configuration file; defaults to SPEC.cfg", true));
        sharedArguments.add(new UsageGenerator.Argument("-continue", "continue running even when an invariant is violated; default\nbehavior is to halt on first violation", true));
        sharedArguments.add(new UsageGenerator.Argument("-coverage", "minutes", "interval between the collection of coverage information;\nif not specified, no coverage will be collected", true));
        sharedArguments.add(new UsageGenerator.Argument("-deadlock", "if specified DO NOT CHECK FOR DEADLOCK. Setting the flag is\nthe same as setting CHECK_DEADLOCK to FALSE in config\nfile. When -deadlock is specified, config entry is\nignored; default behavior is to check for deadlocks", true));
        sharedArguments.add(new UsageGenerator.Argument("-difftrace", "show only the differences between successive states when\nprinting trace information; defaults to printing\nfull state descriptions", true));
        sharedArguments.add(new UsageGenerator.Argument("-debug", "print various debugging information - not for production use\n", true));
        sharedArguments.add(new UsageGenerator.Argument("-dump", "file", "dump all states into the specified file; this parameter takes\noptional parameters for dot graph generation. Specifying\n'dot' allows further options, comma delimited, of zero\nor more of 'actionlabels', 'colorize', 'snapshot' to be\nspecified before the '.dot'-suffixed filename", true, "dot actionlabels,colorize,snapshot"));
        sharedArguments.add(new UsageGenerator.Argument("-fp", "N", "use the Nth irreducible polynomial from the list stored\nin the class FP64", true));
        sharedArguments.add(new UsageGenerator.Argument("-fpbits", "num", "the number of MSB used by MultiFPSet to create nested\nFPSets; defaults to 1", true));
        sharedArguments.add(new UsageGenerator.Argument("-fpmem", "num", "a value in (0.0,1.0) representing the ratio of total\nphysical memory to devote to storing the fingerprints\nof found states; defaults to 0.25", true));
        sharedArguments.add(new UsageGenerator.Argument("-generateSpecTE", null, "if errors are encountered during model checking, generate\na SpecTE tla/cfg file pair which encapsulates Init-Next\ndefinitions to specify the state conditions of the error\nstate; this enables 'tool' mode. The generated SpecTE\nwill include tool output as well as all non-Standard-\nModules dependencies embeded in the module. To prevent\nthe embedding of dependencies, add the parameter\n'nomonolith' to this declaration", true, "nomonolith"));
        sharedArguments.add(new UsageGenerator.Argument("-gzip", "control if gzip is applied to value input/output streams;\ndefaults to 'off'", true));
        sharedArguments.add(new UsageGenerator.Argument("-h", "display these help instructions", true));
        sharedArguments.add(new UsageGenerator.Argument("-maxSetSize", "num", "the size of the largest set which TLC will enumerate; defaults\nto 1000000 (10^6)", true));
        sharedArguments.add(new UsageGenerator.Argument("-metadir", "path", "specify the directory in which to store metadata; defaults to\nSPEC-directory/states if not specified", true));
        sharedArguments.add(new UsageGenerator.Argument("-nowarning", "disable all warnings; defaults to reporting warnings", true));
        sharedArguments.add(new UsageGenerator.Argument("-recover", "id", "recover from the checkpoint with the specified id", true));
        sharedArguments.add(new UsageGenerator.Argument("-terse", "do not expand values in Print statements; defaults to\nexpanding values", true));
        sharedArguments.add(new UsageGenerator.Argument("-tool", "run in 'tool' mode, surrounding output with message codes;\nif '-generateSpecTE' is specified, this is enabled\nautomatically", true));
        sharedArguments.add(new UsageGenerator.Argument("-userFile", "file", "an absolute path to a file in which to log user output (for\nexample, that which is produced by Print)", true));
        sharedArguments.add(new UsageGenerator.Argument("-workers", "num", "the number of TLC worker threads; defaults to 1", true));
        sharedArguments.add(new UsageGenerator.Argument("SPEC", null));
        ArrayList<UsageGenerator.Argument> modelCheckVariant = new ArrayList<UsageGenerator.Argument>(sharedArguments);
        modelCheckVariant.add(new UsageGenerator.Argument("-dfid", "num", "run the model check in depth-first iterative deepening\nstarting with an initial depth of 'num'", true));
        modelCheckVariant.add(new UsageGenerator.Argument("-view", "apply VIEW (if provided) when printing out states", true));
        commandVariants.add(modelCheckVariant);
        ArrayList<UsageGenerator.Argument> simulateVariant = new ArrayList<UsageGenerator.Argument>(sharedArguments);
        simulateVariant.add(new UsageGenerator.Argument("-depth", "num", "specifies the depth of random simulation; defaults to 100", true));
        simulateVariant.add(new UsageGenerator.Argument("-seed", "num", "provide the seed for random simulation; defaults to a\nrandom long pulled from a pseudo-RNG", true));
        simulateVariant.add(new UsageGenerator.Argument("-aril", "num", "adjust the seed for random simulation; defaults to 0", true));
        simulateVariant.add(new UsageGenerator.Argument("-simulate", null, "run in simulation mode; optional parameters may be specified\ncomma delimited: 'num=X' where X is the maximum number of\ntotal traces to generate and/or 'file=Y' where Y is the\nabsolute-pathed prefix for trace file modules to be written\nby the simulation workers; for example Y='/a/b/c/tr' would\nproduce, e.g, '/a/b/c/tr_1_15'", false, "file=X,num=Y"));
        commandVariants.add(simulateVariant);
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("When using the  '-generateSpecTE' you can version the generated specification by doing:\n\t./tla2tools.jar -generateSpecTE MySpec.tla && NAME=\"SpecTE-$(date +%s)\" && sed -e \"s/MODULE SpecTE/MODULE $NAME/g\" SpecTE.tla > $NAME.tla");
        tips.add("If, while checking a SpecTE created via '-generateSpecTE', you get an error message concerning\nCONSTANT declaration and you've previous used 'integers' as model values, rename your\nmodel values to start with a non-numeral and rerun the model check to generate a new SpecTE.");
        tips.add("If, while checking a SpecTE created via '-generateSpecTE', you get a warning concerning\nduplicate operator definitions, this is likely due to the 'monolith' specification\ncreation. Try re-running TLC adding the 'nomonolith' option to the '-generateSpecTE'\nparameter.");
        UsageGenerator.displayUsage(ToolIO.out, "TLC", TLCGlobals.versionOfTLC, "provides model checking and simulation of TLA+ specifications", Messages.getString("TLCDescription"), commandVariants, tips, ' ');
    }

    FPSetConfiguration getFPSetConfiguration() {
        return this.fpSetConfiguration;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public String getMainFile() {
        return this.mainFile;
    }

    public String getModelName() {
        return System.getProperty("modelName", this.mainFile);
    }

    public String getSpecName() {
        return System.getProperty("specName", this.mainFile);
    }

    private static enum RunMode {
        MODEL_CHECK,
        SIMULATE;

    }
}

