/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.StandardModules;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportable;
import tlc2.value.IValue;
import tlc2.value.Values;

public abstract class SemanticNode
implements ASTConstants,
ExploreNode,
LevelConstants,
Comparable<SemanticNode>,
XMLExportable {
    private static final Object[] EmptyArr = new Object[0];
    private static final AtomicInteger uid = new AtomicInteger();
    protected static Errors errors;
    public final int myUID = uid.getAndIncrement();
    public TreeNode stn;
    private Object[] tools;
    private int kind;

    public SemanticNode(int kind, TreeNode stn) {
        this.kind = kind;
        this.stn = stn;
        this.tools = EmptyArr;
    }

    public static void setError(Errors errs) {
        errors = errs;
    }

    public static String levelToString(int level) {
        switch (level) {
            case 0: {
                return level + " (Constant)";
            }
            case 1: {
                return level + " (Variable)";
            }
            case 2: {
                return level + " (Action)";
            }
            case 3: {
                return level + " (Temporal)";
            }
        }
        return level + " (Illegal)";
    }

    public final int getUid() {
        return this.myUID;
    }

    public final Object getToolObject(int toolId) {
        if (this.tools.length <= toolId) {
            return null;
        }
        return this.tools[toolId];
    }

    public final void setToolObject(int toolId, Object obj) {
        if (this.tools.length <= toolId) {
            Object[] newTools = new Object[toolId + 1];
            System.arraycopy(this.tools, 0, newTools, 0, this.tools.length);
            this.tools = newTools;
        }
        this.tools[toolId] = obj;
    }

    public final int getKind() {
        return this.kind;
    }

    public final void setKind(int k) {
        this.kind = k;
    }

    public final TreeNode getTreeNode() {
        return this.stn;
    }

    public String[] getPreComments() {
        return ((SyntaxTreeNode)this.stn).getAttachedComments();
    }

    public String getPreCommentsAsString() {
        return SyntaxTreeNode.PreCommentToString(this.getPreComments());
    }

    public SemanticNode[] getChildren() {
        return null;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    @Override
    public String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "  uid: " + this.myUID + "  kind: " + (this.kind == -1 ? "<none>" : kinds[this.kind]) + this.getPreCommentsAsString();
    }

    public boolean isBuiltIn() {
        return Context.isBuiltIn(this);
    }

    public boolean isStandardModule() {
        return StandardModules.isDefinedInStandardModule(this);
    }

    public final Location getLocation() {
        if (this.stn != null) {
            return this.stn.getLocation();
        }
        return Location.nullLoc;
    }

    @Override
    public int compareTo(SemanticNode s) {
        Location loc1 = this.stn.getLocation();
        Location loc2 = s.stn.getLocation();
        if (loc1.beginLine() < loc2.beginLine()) {
            return -1;
        }
        if (loc1.beginLine() > loc2.beginLine()) {
            return 1;
        }
        if (loc1.beginColumn() == loc2.beginColumn()) {
            return 0;
        }
        return loc1.beginColumn() < loc2.beginColumn() ? -1 : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.kind;
        result = 31 * result + this.myUID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SemanticNode other = (SemanticNode)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return this.myUID == other.myUID;
    }

    public final void toString(StringBuffer sb, String padding) {
        TreeNode treeNode = this.getTreeNode();
        if (treeNode instanceof SyntaxTreeNode && System.getProperty(SemanticNode.class.getName() + ".showPlainFormulae") != null) {
            SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
            sb.append(stn.getHumanReadableImage());
        } else {
            sb.append(this.getLocation());
        }
    }

    public String toString() {
        TreeNode treeNode = this.getTreeNode();
        if (treeNode instanceof SyntaxTreeNode && System.getProperty(SemanticNode.class.getName() + ".showPlainFormulae") != null) {
            SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
            return stn.getHumanReadableImage();
        }
        return this.getLocation().toString();
    }

    public String getHumanReadableImage() {
        return this.getLocation().toString();
    }

    public String toString(IValue aValue) {
        return Values.ppr(aValue.toString());
    }

    protected Element getSemanticElement(Document doc2, SymbolContext context) {
        throw new UnsupportedOperationException("xml export is not yet supported for: " + this.getClass() + " with toString: " + this.toString(100));
    }

    protected Element getLocationElement(Document doc2) {
        Location loc = this.getLocation();
        Element e2 = doc2.createElement("location");
        Element ecol = doc2.createElement("column");
        Element eline = doc2.createElement("line");
        Element fname = doc2.createElement("filename");
        Element bl = doc2.createElement("begin");
        Element el = doc2.createElement("end");
        Element bc = doc2.createElement("begin");
        Element ec = doc2.createElement("end");
        bc.appendChild(doc2.createTextNode(Integer.toString(loc.beginColumn())));
        ec.appendChild(doc2.createTextNode(Integer.toString(loc.endColumn())));
        bl.appendChild(doc2.createTextNode(Integer.toString(loc.beginLine())));
        el.appendChild(doc2.createTextNode(Integer.toString(loc.endLine())));
        fname.appendChild(doc2.createTextNode(this.stn.getFilename()));
        ecol.appendChild(bc);
        ecol.appendChild(ec);
        eline.appendChild(bl);
        eline.appendChild(el);
        e2.appendChild(ecol);
        e2.appendChild(eline);
        e2.appendChild(fname);
        return e2;
    }

    protected Element appendElement(Document doc2, String el, Element e2) {
        Element e3 = doc2.createElement(el);
        e3.appendChild(e2);
        return e3;
    }

    protected Element appendText(Document doc2, String el, String txt) {
        Element e2 = doc2.createElement(el);
        Text n = doc2.createTextNode(txt);
        e2.appendChild(n);
        return e2;
    }

    @Override
    public Element export(Document doc2, SymbolContext context) {
        try {
            Element e2 = this.getSemanticElement(doc2, context);
            try {
                Element loc = this.getLocationElement(doc2);
                e2.insertBefore(loc, e2.getFirstChild());
            }
            catch (UnsupportedOperationException uoe) {
                uoe.printStackTrace();
                throw uoe;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e2;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }
}

