/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNNext;
import tlc2.tool.liveness.LNState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBParVec;
import tlc2.tool.liveness.TBTriple;
import tlc2.util.Vect;
import util.Assert;

public class TBPar
extends Vect<LiveExprNode> {
    public TBPar(int i) {
        super(i);
    }

    public final LiveExprNode exprAt(int i) {
        return (LiveExprNode)this.elementAt(i);
    }

    public final boolean equals(TBPar par) {
        return this.contains(par) && par.contains(this);
    }

    public final boolean member(LiveExprNode e2) {
        for (int i = 0; i < this.size(); ++i) {
            if (!e2.equals(this.exprAt(i))) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(TBPar par) {
        for (int i = 0; i < par.size(); ++i) {
            if (this.member(par.exprAt(i))) continue;
            return false;
        }
        return true;
    }

    public final TBPar union(TBPar par) {
        int i;
        TBPar res2 = new TBPar(this.size() + par.size());
        for (i = 0; i < this.size(); ++i) {
            if (par.member(this.exprAt(i))) continue;
            res2.addElement(this.exprAt(i));
        }
        for (i = 0; i < par.size(); ++i) {
            res2.addElement(par.exprAt(i));
        }
        return res2;
    }

    public final TBPar append(LiveExprNode ln) {
        TBPar res2 = new TBPar(this.size() + 1);
        for (int i = 0; i < this.size(); ++i) {
            res2.addElement(this.exprAt(i));
        }
        res2.addElement(ln);
        return res2;
    }

    public final TBPar append(LiveExprNode ln1, LiveExprNode ln2) {
        TBPar res2 = new TBPar(this.size() + 2);
        for (int i = 0; i < this.size(); ++i) {
            res2.addElement(this.exprAt(i));
        }
        res2.addElement(ln1);
        res2.addElement(ln2);
        return res2;
    }

    public TBParVec particleClosure() {
        TBPar positive_closure = this.positiveClosure();
        Vect<TBTriple> alphas = positive_closure.alphaTriples();
        Vect<TBTriple> betas = positive_closure.betaTriples();
        return this.particleClosure(this, alphas, betas);
    }

    private TBParVec particleClosure(TBPar terms, Vect alphas, Vect betas) {
        boolean done;
        if (!terms.isLocallyConsistent()) {
            return new TBParVec(0);
        }
        TBPar terms1 = terms;
        for (int i = 0; i < terms1.size(); ++i) {
            LiveExprNode ln = terms1.exprAt(i);
            LiveExprNode kappa1 = null;
            LiveExprNode kappa2 = null;
            if (ln instanceof LNAll) {
                kappa1 = ((LNAll)ln).getBody();
                kappa2 = new LNNext(ln);
            } else if (ln instanceof LNConj) {
                kappa1 = ((LNConj)ln).getBody(0);
                kappa2 = ((LNConj)ln).getBody(1);
            }
            if (kappa1 == null) continue;
            if (terms1.member(kappa1)) {
                if (terms1.member(kappa2)) continue;
                terms1 = terms1.append(kappa2);
                continue;
            }
            terms1 = terms1.member(kappa2) ? terms1.append(kappa1) : terms1.append(kappa1, kappa2);
        }
        do {
            done = true;
            for (int i = 0; i < alphas.size(); ++i) {
                TBTriple alpha2 = (TBTriple)alphas.elementAt(i);
                if (!terms1.member(alpha2.getB()) || !terms1.member(alpha2.getC()) || terms1.member(alpha2.getA())) continue;
                terms1.addElement(alpha2.getA());
                done = false;
            }
        } while (!done);
        if (terms1.size() > terms.size() && !terms1.isLocallyConsistent()) {
            return new TBParVec(0);
        }
        return this.particleClosureBeta(terms1, alphas, betas);
    }

    private TBParVec particleClosureBeta(TBPar terms, Vect alphas, Vect betas) {
        int i;
        for (i = 0; i < terms.size(); ++i) {
            LiveExprNode ln = terms.exprAt(i);
            LiveExprNode kappa1 = null;
            LiveExprNode kappa2 = null;
            if (ln instanceof LNEven) {
                kappa1 = ((LNEven)ln).getBody();
                kappa2 = new LNNext(ln);
            } else if (ln instanceof LNDisj) {
                kappa1 = ((LNDisj)ln).getBody(0);
                kappa2 = ((LNDisj)ln).getBody(1);
            }
            if (kappa1 == null || terms.member(kappa1) || terms.member(kappa2)) continue;
            TBParVec ps1 = this.particleClosure(terms.append(kappa1), alphas, betas);
            TBParVec ps2 = this.particleClosure(terms.append(kappa2), alphas, betas);
            return ps1.union(ps2);
        }
        for (i = 0; i < betas.size(); ++i) {
            TBTriple beta = (TBTriple)betas.elementAt(i);
            if (!terms.member(beta.getB()) && !terms.member(beta.getC()) || terms.member(beta.getA())) continue;
            return this.particleClosure(terms.append(beta.getA()), alphas, betas);
        }
        TBParVec res2 = new TBParVec(1);
        res2.addElement(terms);
        return res2;
    }

    public final Vect<TBTriple> alphaTriples() {
        Vect<TBTriple> ts = new Vect<TBTriple>();
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNAll) {
                ts.addElement(new TBTriple(ln, ((LNAll)ln).getBody(), new LNNext(ln)));
                continue;
            }
            if (!(ln instanceof LNConj)) continue;
            LNConj lnc = (LNConj)ln;
            ts.addElement(new TBTriple(lnc, lnc.getBody(0), lnc.getBody(1)));
        }
        return ts;
    }

    public final Vect<TBTriple> betaTriples() {
        Vect<TBTriple> ts = new Vect<TBTriple>();
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNEven) {
                ts.addElement(new TBTriple(ln, ((LNEven)ln).getBody(), new LNNext(ln)));
                continue;
            }
            if (!(ln instanceof LNDisj)) continue;
            LNDisj lnd = (LNDisj)ln;
            ts.addElement(new TBTriple(lnd, lnd.getBody(0), lnd.getBody(1)));
        }
        return ts;
    }

    public final boolean isLocallyConsistent() {
        int i;
        TBPar pos = new TBPar(this.size());
        TBPar neg = new TBPar(this.size());
        for (i = 0; i < this.size(); ++i) {
            LiveExprNode body;
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNState) {
                pos.addElement(ln);
                continue;
            }
            if (!(ln instanceof LNNeg) || !((body = ((LNNeg)ln).getBody()) instanceof LNState)) continue;
            neg.addElement(body);
        }
        for (i = 0; i < pos.size(); ++i) {
            if (!neg.member(pos.exprAt(i))) continue;
            return false;
        }
        return true;
    }

    public final TBPar positiveClosure() {
        TBPar tps = new TBPar(this.size() * 2);
        for (int i = 0; i < this.size(); ++i) {
            tps.addElement((LiveExprNode)this.elementAt(i));
        }
        TBPar res2 = new TBPar(this.size() * 2);
        while (tps.size() > 0) {
            int i;
            LiveExprNode ln = tps.exprAt(tps.size() - 1);
            tps.removeLastElement();
            if (ln instanceof LNNeg) {
                tps.addElement(((LNNeg)ln).getBody());
                continue;
            }
            if (ln instanceof LNNext) {
                res2.addElement(ln);
                tps.addElement(((LNNext)ln).getBody());
                continue;
            }
            if (ln instanceof LNEven) {
                res2.addElement(ln);
                res2.addElement(new LNNext(ln));
                tps.addElement(((LNEven)ln).getBody());
                continue;
            }
            if (ln instanceof LNAll) {
                res2.addElement(ln);
                res2.addElement(new LNNext(ln));
                tps.addElement(((LNAll)ln).getBody());
                continue;
            }
            if (ln instanceof LNConj) {
                LNConj lnc = (LNConj)ln;
                for (i = 0; i < lnc.getCount(); ++i) {
                    tps.addElement(lnc.getBody(i));
                }
                res2.addElement(ln);
                continue;
            }
            if (ln instanceof LNDisj) {
                LNDisj lnd = (LNDisj)ln;
                for (i = 0; i < lnd.getCount(); ++i) {
                    tps.addElement(lnd.getBody(i));
                }
                res2.addElement(ln);
                continue;
            }
            if (ln instanceof LNState) {
                res2.addElement(ln);
                continue;
            }
            if (ln instanceof LNBool) {
                res2.addElement(ln);
                continue;
            }
            Assert.fail(2249);
        }
        return res2;
    }

    public final TBPar impliedSuccessors() {
        TBPar successors = new TBPar(this.size());
        for (int i = 0; i < this.size(); ++i) {
            LiveExprNode ln = this.exprAt(i);
            if (!(ln instanceof LNNext)) continue;
            successors.addElement(((LNNext)ln).getBody());
        }
        return successors;
    }

    public final boolean isFulfilling(LNEven promise2) {
        return !this.member(promise2) || this.member(promise2.getBody());
    }

    public final void toString(StringBuffer sb, String padding) {
        sb.append("{");
        String padding1 = padding + " ";
        if (this.size() != 0) {
            ((LiveExprNode)this.elementAt(0)).toString(sb, padding1);
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append(",\n");
            sb.append(padding1);
            ((LiveExprNode)this.elementAt(i)).toString(sb, padding1);
        }
        sb.append("}");
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.size() != 0) {
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(0);
            sb.append(liveExprNode.toDotViz());
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append(",\n");
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(i);
            sb.append(liveExprNode.toDotViz());
        }
        sb.append("}");
        return sb.toString().replace("\\", "\\\\");
    }
}

