/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.EvalControl;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.impl.UndefValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.ToolIO;

public class LazyValue
extends Value {
    public static final boolean LAZYEVAL_OFF = Boolean.getBoolean(String.valueOf(LazyValue.class.getName()) + ".off");
    public final SemanticNode expr;
    public final Context con;
    private Value val;
    private int toolID;
    private TLCState s0;
    private TLCState s1;
    private int control;
    private int cacheCount = 0;

    static {
        if (LAZYEVAL_OFF) {
            ToolIO.out.println("LazyValue is disabled.");
        }
    }

    public LazyValue(SemanticNode expr, Context con, CostModel cm) {
        this(expr, con, true, coverage ? cm.get(expr) : cm);
    }

    public LazyValue(SemanticNode expr, Context con, boolean cachable, CostModel cm) {
        this.expr = expr;
        this.con = con;
        this.cm = coverage ? cm.get(expr) : cm;
        this.val = null;
        if (LAZYEVAL_OFF || !cachable) {
            this.val = UndefValue.ValUndef;
        }
    }

    private boolean isCachable() {
        return this.val != UndefValue.ValUndef;
    }

    public int getNumTimesThatANewValueWasCached() {
        return this.cacheCount;
    }

    public Value getCachedValue(Tool tool, TLCState s0, TLCState s1, int control) {
        if (this.val != null && this.isCachable() && tool.getId() == this.toolID && TLCState.isSubset(s0, this.s0).isDefinitely(true) && TLCState.isSubset(s1, this.s1).isDefinitely(true) && EvalControl.semanticallyEquivalent(control, this.control).isDefinitely(true)) {
            return this.val;
        }
        return null;
    }

    public Value getValue(Tool tool, TLCState s0, TLCState s1, int control) {
        Value res = this.getCachedValue(tool, s0, s1, control);
        if (res == null) {
            res = tool.eval(this.expr, this.con, s0, s1, control, this.getCostModel());
            if (this.isCachable()) {
                this.val = res;
                this.toolID = tool.getId();
                this.s0 = s0 != null ? s0.copy() : null;
                this.s1 = s1 != null ? s1.copy() : null;
                this.control = control;
                ++this.cacheCount;
            }
        }
        return res;
    }

    @Override
    public final byte getKind() {
        return 25;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to compare lazy values.", this.getSource());
            }
            return this.val.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check equality of lazy values.", this.getSource());
            }
            return this.val.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check set membership of lazy values.", this.getSource());
            }
            return this.val.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check if a lazy value is a finite set.", this.getSource());
            }
            return this.val.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.", this.getSource());
            }
            return this.val.takeExcept(ex);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.", this.getSource());
            }
            return this.val.takeExcept(exs);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to compute size of lazy value.", this.getSource());
            }
            return this.val.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.val = (Value)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.val == null || this.val == UndefValue.ValUndef) {
            Assert.fail("Error(TLC): Attempted to serialize lazy value.", this.getSource());
        }
        oos.writeObject(this.val);
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.", this.getSource());
            }
            return this.val.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.", this.getSource());
            }
            this.val.normalize();
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                return this;
            }
            return this.val.deepCopy();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to fingerprint a lazy value.", this.getSource());
            }
            return this.val.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply permutation to lazy value.", this.getSource());
            }
            return this.val.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                return sb.append("<LAZY " + this.expr + ">");
            }
            return this.val.toString(sb, offset, swallow);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public IValue eval(Tool tool) {
        return this.eval(tool, TLCState.Empty);
    }

    public IValue eval(Tool tool, TLCState s0) {
        return this.eval(tool, s0, null);
    }

    public IValue eval(Tool tool, TLCState s0, TLCState s1) {
        Value eval = tool.eval(this.expr, this.con, s0, s1, 0, this.cm);
        if (!eval.hasSource()) {
            eval.setSource(this.expr);
        }
        return eval;
    }
}

