/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TBParVec;
import tlc2.util.Vect;

public class TBGraph
extends Vect<TBGraphNode> {
    public final LiveExprNode tf;
    private int initCnt;

    public TBGraph() {
        this.tf = null;
        this.initCnt = 0;
    }

    public TBGraph(LiveExprNode tf) {
        this.tf = tf;
        this.initCnt = 0;
        TBPar initTerms = new TBPar(1);
        initTerms.addElement(tf);
        TBParVec pars = initTerms.particleClosure();
        int i = 0;
        while (i < pars.size()) {
            TBGraphNode gn = new TBGraphNode(pars.parAt(i));
            this.addElement(gn);
            ++i;
        }
        this.setInitCnt(this.size());
        i = 0;
        while (i < this.size()) {
            TBGraphNode gnSrc = (TBGraphNode)this.elementAt(i);
            TBPar imps = gnSrc.getPar().impliedSuccessors();
            TBParVec succs = imps.particleClosure();
            int j = 0;
            while (j < succs.size()) {
                TBPar par = succs.parAt(j);
                TBGraphNode gnDst = this.findOrCreateNode(par);
                gnSrc.nexts.addElement(gnDst);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            this.getNode(i).setIndex(i);
            ++i;
        }
    }

    private TBGraphNode findOrCreateNode(TBPar par) {
        int i = 0;
        while (i < this.size()) {
            TBGraphNode gn = (TBGraphNode)this.elementAt(i);
            if (par.equals(gn.getPar())) {
                return gn;
            }
            ++i;
        }
        TBGraphNode gn = new TBGraphNode(par);
        this.addElement(gn);
        return gn;
    }

    public TBGraphNode getNode(int idx) {
        return (TBGraphNode)this.elementAt(idx);
    }

    public final void setInitCnt(int n) {
        this.initCnt = n;
    }

    public int getInitCnt() {
        return this.initCnt;
    }

    private boolean isInitNode(TBGraphNode aNode) {
        return aNode.getIndex() < this.getInitCnt();
    }

    public final void toString(StringBuffer sb, String padding) {
        int i = 0;
        while (i < this.size()) {
            TBGraphNode tnode = this.getNode(i);
            sb.append(padding);
            sb.append("Node " + i + ".\n");
            tnode.getPar().toString(sb, padding);
            sb.append(" --> ");
            int j = 0;
            while (j < tnode.nexts.size()) {
                sb.append(String.valueOf(tnode.nextAt(j).getIndex()) + " ");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("digraph TableauGraph {\n");
        sb.append("nodesep = 0.7\n");
        sb.append("rankdir=LR;\n");
        int i = 0;
        while (i < this.size()) {
            TBGraphNode node = this.getNode(i);
            sb.append(node.toDotViz(this.isInitNode(node)));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

