/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import tlc2.util.ChildFirstClassLoader;
import tlc2.util.ClassPathCollector;

final class TLCIsolatedInstance
implements AutoCloseable {
    private final ChildFirstClassLoader loader;
    private Object delegate;
    private Method handleParameters;
    private Method checkEnvironment;
    private Method process;
    private Method setResolver;
    private Method getMainFile;
    private Field modelPartOfJarField;
    private Method parseDirname;
    private Constructor<?> simpleFilenameToStreamDefaultCtor;
    private Constructor<?> simpleFilenameToStreamDirCtor;
    private Constructor<?> inJarFilenameToStreamCtor;
    private Field modelInJarPathField;
    private Field recorderField;
    private Method recorderGetMCErrorTrace;
    private Method mcErrorGetStates;
    private Method mcStateGetVariables;
    private Method mcVariableGetName;
    private Method mcVariableGetTLCValue;
    private Field intValueValField;
    private Field mainCheckerField;
    private Field metaDirField;
    private Method getNumWorkersMethod;

    private TLCIsolatedInstance(ChildFirstClassLoader loader, Object delegate, Method handleParameters, Method checkEnvironment, Method process, Method setResolver, Method getMainFile, Field modelPartOfJarField, Method parseDirname, Constructor<?> simpleFilenameToStreamDefaultCtor, Constructor<?> simpleFilenameToStreamDirCtor, Constructor<?> inJarFilenameToStreamCtor, Field modelInJarPathField, Field recorderField, Method recorderGetMCErrorTrace, Method mcErrorGetStates, Method mcStateGetVariables, Method mcVariableGetName, Method mcVariableGetTLCValue, Field intValueValField, Field mainCheckerField, Field metaDirField, Method getNumWorkersMethod) {
        this.loader = loader;
        this.delegate = delegate;
        this.handleParameters = handleParameters;
        this.checkEnvironment = checkEnvironment;
        this.process = process;
        this.setResolver = setResolver;
        this.getMainFile = getMainFile;
        this.modelPartOfJarField = modelPartOfJarField;
        this.parseDirname = parseDirname;
        this.simpleFilenameToStreamDefaultCtor = simpleFilenameToStreamDefaultCtor;
        this.simpleFilenameToStreamDirCtor = simpleFilenameToStreamDirCtor;
        this.inJarFilenameToStreamCtor = inJarFilenameToStreamCtor;
        this.modelInJarPathField = modelInJarPathField;
        this.recorderField = recorderField;
        this.recorderGetMCErrorTrace = recorderGetMCErrorTrace;
        this.mcErrorGetStates = mcErrorGetStates;
        this.mcStateGetVariables = mcStateGetVariables;
        this.mcVariableGetName = mcVariableGetName;
        this.mcVariableGetTLCValue = mcVariableGetTLCValue;
        this.intValueValField = intValueValField;
        this.mainCheckerField = mainCheckerField;
        this.metaDirField = metaDirField;
        this.getNumWorkersMethod = getNumWorkersMethod;
    }

    static TLCIsolatedInstance create() throws ReflectiveOperationException {
        ChildFirstClassLoader loader = new ChildFirstClassLoader(ClassPathCollector.collect(), TLCIsolatedInstance.class.getClassLoader());
        Class<?> tlcClass = Class.forName("tlc2.TLC", true, loader);
        Object delegate = tlcClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method handleParameters = tlcClass.getMethod("handleParameters", String[].class);
        Method checkEnvironment = tlcClass.getDeclaredMethod("checkEnvironment", new Class[0]);
        checkEnvironment.setAccessible(true);
        Method process = tlcClass.getMethod("process", new Class[0]);
        Class<?> filenameToStreamClass = Class.forName("util.FilenameToStream", false, loader);
        Method setResolver = tlcClass.getMethod("setResolver", filenameToStreamClass);
        Method getMainFile = tlcClass.getMethod("getMainFile", new Class[0]);
        Field modelPartOfJarField = tlcClass.getDeclaredField("modelPartOfJar");
        modelPartOfJarField.setAccessible(true);
        Class<?> fileUtilClass = Class.forName("util.FileUtil", true, loader);
        Method parseDirname = fileUtilClass.getMethod("parseDirname", String.class);
        Class<?> simpleFilenameToStreamClass = Class.forName("util.SimpleFilenameToStream", true, loader);
        Constructor<?> simpleFilenameToStreamDefaultCtor = simpleFilenameToStreamClass.getConstructor(new Class[0]);
        Constructor<?> simpleFilenameToStreamDirCtor = simpleFilenameToStreamClass.getConstructor(String.class);
        Class<?> inJarFilenameToStreamClass = Class.forName("model.InJarFilenameToStream", true, loader);
        Constructor<?> inJarFilenameToStreamCtor = inJarFilenameToStreamClass.getConstructor(String.class);
        Class<?> modelInJarClass = Class.forName("model.ModelInJar", true, loader);
        Field modelInJarPathField = modelInJarClass.getField("PATH");
        Field recorderField = tlcClass.getDeclaredField("recorder");
        recorderField.setAccessible(true);
        Class<?> recorderClass = Class.forName("tlc2.output.ErrorTraceMessagePrinterRecorder", true, loader);
        Method recorderGetMCErrorTrace = recorderClass.getMethod("getMCErrorTrace", new Class[0]);
        Class<?> mcErrorClass = Class.forName("tlc2.model.MCError", true, loader);
        Method mcErrorGetStates = mcErrorClass.getMethod("getStates", new Class[0]);
        Class<?> mcStateClass = Class.forName("tlc2.model.MCState", true, loader);
        Method mcStateGetVariables = mcStateClass.getMethod("getVariables", new Class[0]);
        Class<?> mcVariableClass = Class.forName("tlc2.model.MCVariable", true, loader);
        Method mcVariableGetName = mcVariableClass.getMethod("getName", new Class[0]);
        Method mcVariableGetTLCValue = mcVariableClass.getMethod("getTLCValue", new Class[0]);
        Class<?> intValueClass = Class.forName("tlc2.value.impl.IntValue", true, loader);
        Field intValueValField = intValueClass.getField("val");
        Class<?> globalsClass = Class.forName("tlc2.TLCGlobals", true, loader);
        Field mainCheckerField = globalsClass.getDeclaredField("mainChecker");
        mainCheckerField.setAccessible(true);
        Field metaDirField = globalsClass.getDeclaredField("metaDir");
        metaDirField.setAccessible(true);
        Method getNumWorkersMethod = globalsClass.getMethod("getNumWorkers", new Class[0]);
        return new TLCIsolatedInstance(loader, delegate, handleParameters, checkEnvironment, process, setResolver, getMainFile, modelPartOfJarField, parseDirname, simpleFilenameToStreamDefaultCtor, simpleFilenameToStreamDirCtor, inJarFilenameToStreamCtor, modelInJarPathField, recorderField, recorderGetMCErrorTrace, mcErrorGetStates, mcStateGetVariables, mcVariableGetName, mcVariableGetTLCValue, intValueValField, mainCheckerField, metaDirField, getNumWorkersMethod);
    }

    boolean handleParameters(String[] args) throws ReflectiveOperationException {
        return (Boolean)this.handleParameters.invoke(this.delegate, new Object[]{args});
    }

    boolean checkEnvironment() throws ReflectiveOperationException {
        return (Boolean)this.checkEnvironment.invoke(this.delegate, new Object[0]);
    }

    void configureResolver() throws ReflectiveOperationException {
        Object resolver;
        boolean modelInJar = this.modelPartOfJarField.getBoolean(this.delegate);
        if (modelInJar) {
            String path = (String)this.modelInJarPathField.get(null);
            resolver = this.inJarFilenameToStreamCtor.newInstance(path);
        } else {
            String mainFile = (String)this.getMainFile.invoke(this.delegate, new Object[0]);
            String dir = (String)this.parseDirname.invoke(null, mainFile);
            resolver = dir != null && !dir.isEmpty() ? this.simpleFilenameToStreamDirCtor.newInstance(dir) : this.simpleFilenameToStreamDefaultCtor.newInstance(new Object[0]);
        }
        this.setResolver.invoke(this.delegate, resolver);
    }

    int process() throws ReflectiveOperationException {
        return (Integer)this.process.invoke(this.delegate, new Object[0]);
    }

    int getLastErrorTraceIntValue(String variableName) throws ReflectiveOperationException {
        Object[] variables;
        Object recorder = this.recorderField.get(this.delegate);
        Optional optional = (Optional)this.recorderGetMCErrorTrace.invoke(recorder, new Object[0]);
        if (!optional.isPresent()) {
            throw new IllegalStateException("No error trace available from TLC run");
        }
        Object mcError = optional.get();
        List states = (List)this.mcErrorGetStates.invoke(mcError, new Object[0]);
        if (states.isEmpty()) {
            throw new IllegalStateException("Error trace did not contain any states");
        }
        Object lastState = states.get(states.size() - 1);
        Object[] objectArray = variables = (Object[])this.mcStateGetVariables.invoke(lastState, new Object[0]);
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Object variable = objectArray[n2];
            String name = (String)this.mcVariableGetName.invoke(variable, new Object[0]);
            if (variableName.equals(name)) {
                Object value = this.mcVariableGetTLCValue.invoke(variable, new Object[0]);
                if (value == null) {
                    throw new IllegalStateException("Variable " + variableName + " lacks TLC value representation");
                }
                return this.intValueValField.getInt(value);
            }
            ++n2;
        }
        throw new IllegalStateException("Variable " + variableName + " not found in error trace");
    }

    int getMainCheckerIdentity() throws ReflectiveOperationException {
        Object checker = this.mainCheckerField.get(null);
        return checker == null ? 0 : System.identityHashCode(checker);
    }

    String getMetaDir() throws ReflectiveOperationException {
        return (String)this.metaDirField.get(null);
    }

    int getNumWorkers() throws ReflectiveOperationException {
        return (Integer)this.getNumWorkersMethod.invoke(null, new Object[0]);
    }

    @Override
    public void close() {
        try {
            try {
                this.loader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.delegate = null;
            this.handleParameters = null;
            this.checkEnvironment = null;
            this.process = null;
            this.setResolver = null;
            this.getMainFile = null;
            this.modelPartOfJarField = null;
            this.parseDirname = null;
            this.simpleFilenameToStreamDefaultCtor = null;
            this.simpleFilenameToStreamDirCtor = null;
            this.inJarFilenameToStreamCtor = null;
            this.modelInJarPathField = null;
            this.recorderField = null;
            this.recorderGetMCErrorTrace = null;
            this.mcErrorGetStates = null;
            this.mcStateGetVariables = null;
            this.mcVariableGetName = null;
            this.mcVariableGetTLCValue = null;
            this.intValueValField = null;
            this.mainCheckerField = null;
            this.metaDirField = null;
            this.getNumWorkersMethod = null;
        }
    }
}

