/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.tool.TLCIsolatedInstance;

public final class TLCIsolatedExecutor {
    private TLCIsolatedExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int run(String[] args) throws ReflectiveOperationException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TLCIsolatedInstance instance = TLCIsolatedInstance.create();){
            if (!instance.handleParameters(args)) {
                return 1;
            }
            if (!instance.checkEnvironment()) {
                return 1;
            }
            instance.configureResolver();
            return instance.process();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static RunOutcome runWithErrorTrace(String[] args, String variableName) throws ReflectiveOperationException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TLCIsolatedInstance instance = TLCIsolatedInstance.create();){
            if (!instance.handleParameters(args)) {
                return new RunOutcome(1, null, 0, null, 0);
            }
            if (!instance.checkEnvironment()) {
                return new RunOutcome(1, null, 0, null, 0);
            }
            instance.configureResolver();
            int exitCode = instance.process();
            Integer lastValue = null;
            if (variableName != null) {
                try {
                    lastValue = instance.getLastErrorTraceIntValue(variableName);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            int checkerId = instance.getMainCheckerIdentity();
            String metaDir = instance.getMetaDir();
            int numWorkers = instance.getNumWorkers();
            return new RunOutcome(exitCode, lastValue, checkerId, metaDir, numWorkers);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final class RunOutcome {
        private final int exitCode;
        private final Integer lastIntValue;
        private final int mainCheckerIdentity;
        private final String metaDir;
        private final int numWorkers;

        private RunOutcome(int exitCode, Integer lastIntValue) {
            this(exitCode, lastIntValue, 0, null, 0);
        }

        private RunOutcome(int exitCode, Integer lastIntValue, int mainCheckerIdentity, String metaDir, int numWorkers) {
            this.exitCode = exitCode;
            this.lastIntValue = lastIntValue;
            this.mainCheckerIdentity = mainCheckerIdentity;
            this.metaDir = metaDir;
            this.numWorkers = numWorkers;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public Integer getLastIntValue() {
            return this.lastIntValue;
        }

        public int getMainCheckerIdentity() {
            return this.mainCheckerIdentity;
        }

        public String getMetaDir() {
            return this.metaDir;
        }

        public int getNumWorkers() {
            return this.numWorkers;
        }
    }
}

