/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import util.ToolIO;

public class StatePrinter {
    private static final int STATE_OVERWRITE_INTERVAL = Integer.getInteger(String.valueOf(StatePrinter.class.getName()) + ".overwrite", -1);

    public static void printRuntimeErrorStateTraceState(TLCState currentState, int num) {
        MP.printState(2216, new String[]{String.valueOf(num), currentState.toString()}, currentState, num);
    }

    public static void printStandaloneErrorState(TLCState currentState) {
        MP.printState(2216, new String[]{"", currentState.toString()}, currentState, -1);
    }

    public static void printInvariantViolationStateTraceState(TLCStateInfo currentStateInfo) {
        if (currentStateInfo.state.isInitial()) {
            StatePrinter.printInvariantViolationStateTraceState(currentStateInfo, null, (int)currentStateInfo.stateNumber);
        } else {
            StatePrinter.printInvariantViolationStateTraceState(currentStateInfo, currentStateInfo.state.getPredecessor(), (int)currentStateInfo.stateNumber);
        }
    }

    public static void printInvariantViolationStateTraceState(TLCStateInfo currentStateInfo, TLCState previousState, int num) {
        StatePrinter.printInvariantViolationStateTraceState(currentStateInfo, previousState, num, false);
    }

    public static void printInvariantViolationStateTraceState(TLCStateInfo currentStateInfo, TLCState previousState, int num, boolean isFinal) {
        String stateString = previousState != null && TLCGlobals.printDiffsOnly ? currentStateInfo.state.toString(previousState) : currentStateInfo.state.toString();
        String fingerprint = currentStateInfo.state.allAssigned() ? String.valueOf(currentStateInfo.fingerPrint()) : "-1";
        String[] metadata = new String[]{String.valueOf(num), currentStateInfo.info.toString(), stateString, fingerprint};
        String message = MP.printState(2217, metadata, currentStateInfo, num);
        if (STATE_OVERWRITE_INTERVAL > 0) {
            try {
                Thread.sleep(STATE_OVERWRITE_INTERVAL);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!isFinal) {
                int lines = (int)(message.chars().filter(x -> x == 10).count() + 1L);
                ToolIO.out.printf("%s", "\u001b[F\u001b[K".repeat(lines));
            }
        }
    }

    public static void printStutteringState(int num) {
        MP.printState(2218, new String[]{String.valueOf(num + 1)}, null, num + 1);
    }

    public static void printBackToState(TLCStateInfo currentStateInfo, int stateNum) {
        if (TLCGlobals.tool) {
            MP.printState(2122, new String[]{Integer.toString(stateNum), currentStateInfo.info.toString()}, null, stateNum);
        } else {
            MP.printMessage(2122, Integer.toString(stateNum), currentStateInfo.info.toString());
        }
    }
}

