/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import tla2sany.semantic.ExprOrOpArgNode;
import tlc2.overrides.Evaluation;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.value.ValueConstants;
import tlc2.value.impl.Value;

public class TLCEval
implements ValueConstants {
    public static final long serialVersionUID = 20220105L;
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private static Value convert(Value eval) {
        Value evalVal = eval.toSetEnum();
        if (evalVal != null) {
            return evalVal;
        }
        evalVal = eval.toFcnRcd();
        if (evalVal != null) {
            return evalVal;
        }
        return eval;
    }

    @Evaluation(definition="TLCEval", module="TLC", warn=false, silent=true)
    public static Value tlcEval(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        ExprOrOpArgNode arg = args[0];
        if (arg.getLevel() > 0) {
            return TLCEval.convert(tool.eval(arg, c, s0, s1, control, cm));
        }
        if (!c.isDeepEmpty()) {
            return TLCEval.convert(tool.eval(arg, c, s0, s1, control, cm));
        }
        return TLCEval.tlcEvalConst(tool, arg, cm);
    }

    private static Value tlcEvalConst(Tool tool, ExprOrOpArgNode arg, CostModel cm) {
        assert (arg.getLevel() == 0);
        lock.readLock().lock();
        Object obj = WorkerValue.mux(arg.getToolObject(tool.getId()));
        if (obj != null) {
            try {
                Value value = (Value)obj;
                return value;
            }
            finally {
                lock.readLock().unlock();
            }
        }
        lock.readLock().unlock();
        lock.writeLock().lock();
        try {
            obj = WorkerValue.mux(arg.getToolObject(tool.getId()));
            if (obj != null) {
                Value value = (Value)obj;
                return value;
            }
            Object demuxed = WorkerValue.demux(tool, arg, cm);
            Value eval = demuxed instanceof Value ? (Value)demuxed : (Value)WorkerValue.mux((WorkerValue)demuxed);
            eval = TLCEval.convert(eval);
            arg.setToolObject(tool.getId(), eval);
            Value value = eval;
            return value;
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

