/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;

public class DecimalNode
extends ExprNode {
    private long mantissa;
    private int exponent;
    private BigDecimal bigVal = null;
    private String image;

    public DecimalNode(String a, String b, TreeNode stn) {
        super(17, stn);
        this.image = String.valueOf(a) + "." + b;
        try {
            this.mantissa = Long.parseLong(String.valueOf(a) + b);
            this.exponent = -b.length();
        }
        catch (NumberFormatException e) {
            this.bigVal = new BigDecimal(this.image);
        }
    }

    public final long mantissa() {
        return this.mantissa;
    }

    public final int exponent() {
        return this.exponent;
    }

    public final BigDecimal bigVal() {
        return this.bigVal;
    }

    @Override
    public final String toString() {
        return this.image;
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        this.levelChecked = iter;
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        return "\n*DecimalNode" + super.toString(depth, errors) + "Mantissa: " + this.mantissa + "; exponent: " + this.exponent + "; big value: " + (this.bigVal != null ? this.bigVal.toString() : "<null>") + "\n; image = " + this.image;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("DecimalNode");
        if (this.bigVal != null) {
            e.appendChild(this.appendText(doc, "mantissa", this.bigVal.unscaledValue().toString()));
            e.appendChild(this.appendText(doc, "exponent", Integer.toString(this.bigVal.scale())));
        } else {
            e.appendChild(this.appendText(doc, "mantissa", Long.toString(this.mantissa)));
            e.appendChild(this.appendText(doc, "exponent", Integer.toString(this.exponent)));
        }
        return e;
    }
}

