/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import tlc2.TLCGlobals;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueRead;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import util.BufferedDataInputStream;
import util.FileUtil;
import util.IDataInputStream;
import util.UniqueString;
import util.WrongInvocationException;

public final class ValueInputStream
implements ValueConstants,
IValueInputStream {
    private final BufferedDataInputStream dis;
    private final HandleTable handles;
    public static final HashMap<Byte, IValueRead> customValues = new HashMap();

    public ValueInputStream(InputStream in) throws IOException {
        this.dis = new BufferedDataInputStream(in);
        this.handles = new HandleTable();
    }

    public ValueInputStream(File file, boolean compressed) throws IOException {
        this(FileUtil.newBdFIS(compressed, file));
    }

    public ValueInputStream(File file) throws IOException {
        this(file, TLCGlobals.useGZIP);
    }

    public ValueInputStream(String fname) throws IOException {
        this(new File(fname));
    }

    @Override
    public final IValue read() throws IOException {
        byte kind = this.dis.readByte();
        switch (kind) {
            case 0: {
                return this.dis.readBoolean() ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 1: {
                return IntValue.gen(this.dis.readInt());
            }
            case 3: {
                return StringValue.createFrom(this);
            }
            case 21: {
                return ModelValue.mvs[this.dis.readShort()];
            }
            case 23: {
                return new IntervalValue(this.dis.readInt(), this.dis.readInt());
            }
            case 4: {
                return RecordValue.createFrom(this);
            }
            case 9: {
                return FcnRcdValue.createFrom(this);
            }
            case 5: {
                return SetEnumValue.createFrom(this);
            }
            case 7: {
                return TupleValue.createFrom(this);
            }
            case 26: {
                return (IValue)this.handles.getValue(this.readNat());
            }
        }
        IValueRead customValue = customValues.get(kind);
        if (customValue != null) {
            return customValue.empty().createFrom(this);
        }
        throw new WrongInvocationException("ValueInputStream: Can not unpickle a value of kind " + kind);
    }

    @Deprecated
    public final IValue read(Map<String, UniqueString> tbl) throws IOException {
        return this.readExternal();
    }

    public final IValue readExternal() throws IOException {
        byte kind = this.dis.readByte();
        switch (kind) {
            case 0: {
                return this.dis.readBoolean() ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 1: {
                return IntValue.gen(this.dis.readInt());
            }
            case 3: {
                return StringValue.createFromExternal(this);
            }
            case 21: {
                return ModelValue.mvs[this.dis.readShort()];
            }
            case 23: {
                return new IntervalValue(this.dis.readInt(), this.dis.readInt());
            }
            case 4: {
                return RecordValue.createFromExternal(this);
            }
            case 9: {
                return FcnRcdValue.createFromExternal(this);
            }
            case 5: {
                return SetEnumValue.createFromExternal(this);
            }
            case 7: {
                return TupleValue.createFromExternal(this);
            }
            case 26: {
                return (IValue)this.handles.getValue(this.readNat());
            }
        }
        IValueRead customValue = customValues.get(kind);
        if (customValue != null) {
            return customValue.empty().createFrom(this);
        }
        throw new WrongInvocationException("ValueInputStream: Can not unpickle a value of kind " + kind);
    }

    @Override
    public final int readShort() throws IOException {
        return this.dis.readShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.dis.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.dis.readLong();
    }

    @Override
    public final void close() throws IOException {
        this.dis.close();
    }

    @Override
    public final int readNat() throws IOException {
        int res = this.dis.readShort();
        if (res >= 0) {
            return res;
        }
        res = res << 16 | this.dis.readShort() & 0xFFFF;
        return -res;
    }

    @Override
    public final short readShortNat() throws IOException {
        byte res = this.dis.readByte();
        if (res >= 0) {
            return res;
        }
        return (short)(-(res << 8 | this.dis.readByte() & 0xFF));
    }

    @Override
    public final long readLongNat() throws IOException {
        long res = this.dis.readInt();
        if (res >= 0L) {
            return res;
        }
        res = res << 32 | (long)this.dis.readInt() & 0xFFFFFFFFL;
        return -res;
    }

    @Override
    public final byte readByte() throws EOFException, IOException {
        return this.dis.readByte();
    }

    @Override
    public final void assign(Object obj, int idx) {
        this.handles.assign(obj, idx);
    }

    @Override
    public final int getIndex() {
        return this.handles.getIndex();
    }

    @Override
    public final IDataInputStream getInputStream() {
        return this.dis;
    }

    @Override
    public final UniqueString getValue(int idx) {
        return (UniqueString)this.handles.getValue(idx);
    }

    private static class HandleTable {
        private Object[] values = new Object[16];
        private int index = 0;

        HandleTable() {
        }

        final int getIndex() {
            if (this.index >= this.values.length) {
                Object[] newValues = new Object[this.index * 2];
                System.arraycopy(this.values, 0, newValues, 0, this.index);
                this.values = newValues;
            }
            return this.index++;
        }

        final void assign(Object val, int idx) {
            this.values[idx] = val;
        }

        final Object getValue(int idx) {
            return this.values[idx];
        }
    }
}

