/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import tlc2.util.AbstractFileState;

public class BufferedRandomAccessFileFuzzTest {
    private static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int TRACES_TO_EXPLORE_PER_THREAD = 10000;
    private static final int BOUND = 16384;

    @Test
    public void fuzz() throws IOException {
        AtomicInteger nextOp = new AtomicInteger(1);
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicReference<Object> badResult = new AtomicReference<Object>(null);
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        Object outputLock = new Object();
        ArrayList<Thread> threads = new ArrayList<Thread>(THREAD_COUNT);
        int i = 0;
        while (i < THREAD_COUNT) {
            int threadID = i++;
            Thread t2 = new Thread(() -> {
                Random rng = new Random(threadID);
                while (running.get()) {
                    int runID = nextOp.getAndIncrement();
                    if (runID > 10000) {
                        return;
                    }
                    Object object2 = outputLock;
                    synchronized (object2) {
                        System.out.println("---- starting run " + runID);
                    }
                    try {
                        RunResult result = this.checkBufferedRandomAccessFileBehavior(this.generateRandomOps(rng, 50));
                        if (result.ok()) continue;
                        badResult.set(result);
                        running.set(false);
                    }
                    catch (Throwable e) {
                        error.set(e);
                        running.set(false);
                        return;
                    }
                }
            });
            t2.setName(String.valueOf(this.getClass().getSimpleName()) + "-worker-" + threadID);
            t2.setDaemon(true);
            t2.start();
            threads.add(t2);
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException t2) {
                // empty catch block
            }
        }
        RunResult result = badResult.get();
        if (result != null && !result.ok()) {
            System.out.println("Violation found on op # " + result.successes + "; minimizing...");
            List<FileOperation<?>> minimalOps = BufferedRandomAccessFileFuzzTest.minimize(result.ops.subList(0, result.successes + 1), subset -> this.wellDefined((List<FileOperation<?>>)subset) && !this.checkBufferedRandomAccessFileBehavior((List<FileOperation<?>>)subset).ok());
            System.out.println("Minimal trace:");
            for (FileOperation<?> op : minimalOps) {
                System.out.println(" --> " + op);
            }
            RunResult minResult = this.checkBufferedRandomAccessFileBehavior(minimalOps);
            throw new RuntimeException("got " + minResult.actual + " but expected " + minResult.expected);
        }
        Throwable thrown = error.get();
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    private List<FileOperation<?>> generateRandomOps(Random rng, int nOps) {
        ArrayList ops = new ArrayList(nOps);
        RandomOperationGenerator gen = new RandomOperationGenerator(rng);
        int i = 0;
        while (i < nOps) {
            ops.add(gen.nextRandomOperation());
            ++i;
        }
        if (!this.wellDefined(ops)) {
            throw new IllegalStateException("generated not-well-defined ops: " + ops);
        }
        return ops;
    }

    private static <T> List<T> minimize(List<T> list, IOPredicate<List<T>> test) throws IOException {
        int stride = list.size() / 2;
        while (stride > 0) {
            boolean listModified = false;
            int i = 0;
            while (i < list.size()) {
                int cutStart = i;
                int cutEnd = Math.min(i + stride, list.size());
                List<T> candidate = BufferedRandomAccessFileFuzzTest.append(list.subList(0, cutStart), list.subList(cutEnd, list.size()));
                if (test.test(candidate)) {
                    list = candidate;
                    i -= stride;
                    listModified = true;
                }
                i += stride;
            }
            if (listModified) continue;
            stride /= 2;
        }
        return list;
    }

    private static <T> List<T> append(List<T> a, List<T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    /*
     * Exception decompiling
     */
    private RunResult checkBufferedRandomAccessFileBehavior(List<FileOperation<?>> ops) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean wellDefined(List<FileOperation<?>> ops) {
        AbstractFileState state = new AbstractFileState();
        for (FileOperation<?> op : ops) {
            if (op.simulateIfWellDefined(state)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testWellDefined() {
        throw new Error("Unresolved compilation problem: \n\tAssert cannot be resolved\n");
    }

    private static byte[] randomByteArray(Random rng) {
        int len = rng.nextInt(16384) + 1;
        byte[] result = new byte[len];
        rng.nextBytes(result);
        return result;
    }

    private static interface FileOperation<T> {
        public T execute(RandomAccessFile var1) throws IOException;

        public boolean simulateIfWellDefined(AbstractFileState var1);
    }

    private static class GetFilePointerOperation
    implements FileOperation<Long> {
        private GetFilePointerOperation() {
        }

        @Override
        public Long execute(RandomAccessFile file) throws IOException {
            return file.getFilePointer();
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            return true;
        }

        public String toString() {
            return "getFilePointer()";
        }
    }

    private static class GetLengthOperation
    implements FileOperation<Long> {
        private GetLengthOperation() {
        }

        @Override
        public Long execute(RandomAccessFile file) throws IOException {
            return file.length();
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            return true;
        }

        public String toString() {
            return "length()";
        }
    }

    private static interface IOPredicate<T> {
        public boolean test(T var1) throws IOException;
    }

    private static class RandomOperationGenerator {
        private final AbstractFileState state = new AbstractFileState();
        private final Random rng;

        public RandomOperationGenerator(Random rng) {
            this.rng = rng;
        }

        public FileOperation<?> nextRandomOperation() {
            FileOperation<?> result;
            while (!(result = this.arbitraryRandomOperation()).simulateIfWellDefined(this.state)) {
            }
            return result;
        }

        private FileOperation<?> arbitraryRandomOperation() {
            switch (this.rng.nextInt(8)) {
                case 0: {
                    return new Write1Operation((byte)this.rng.nextInt(255));
                }
                case 1: {
                    byte[] bytes = BufferedRandomAccessFileFuzzTest.randomByteArray(this.rng);
                    int offset = this.rng.nextInt(bytes.length);
                    int len = this.rng.nextInt(bytes.length - offset);
                    return new WriteArrayOperation(bytes, offset, len);
                }
                case 2: {
                    return new Read1Operation();
                }
                case 3: {
                    byte[] bytes = BufferedRandomAccessFileFuzzTest.randomByteArray(this.rng);
                    int offset = this.rng.nextInt(bytes.length);
                    int len = this.rng.nextInt(bytes.length - offset);
                    return new ReadArrayOperation(bytes, offset, len);
                }
                case 4: {
                    int pos = this.rng.nextInt(16384);
                    return new SeekOperation(pos);
                }
                case 5: {
                    return new GetFilePointerOperation();
                }
                case 6: {
                    return new GetLengthOperation();
                }
                case 7: {
                    int newLength = this.rng.nextInt(16384);
                    return new SetLengthOperation(newLength);
                }
            }
            throw new IllegalStateException("Unexpected random number");
        }
    }

    private static class Read1Operation
    implements FileOperation<Integer> {
        private Read1Operation() {
        }

        @Override
        public Integer execute(RandomAccessFile file) throws IOException {
            return file.read();
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            if (state.readWouldBeWellDefined(1)) {
                state.readBytes(1);
                return true;
            }
            return false;
        }

        public String toString() {
            return "read()";
        }
    }

    private static class ReadArrayOperation
    implements FileOperation<List<Byte>> {
        private final byte[] buffer;
        private final int offset;
        private final int length;

        public ReadArrayOperation(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public List<Byte> execute(RandomAccessFile file) throws IOException {
            ArrayList<Byte> result = null;
            while (result == null || result.size() < this.length) {
                int nread = file.read(this.buffer, this.offset, this.length - (result == null ? 0 : result.size()));
                if (nread == -1) break;
                if (result == null) {
                    result = new ArrayList<Byte>(this.length);
                }
                int i = 0;
                while (i < nread) {
                    result.add(this.buffer[this.offset + i]);
                    ++i;
                }
            }
            return result;
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            if (state.readWouldBeWellDefined(this.length)) {
                state.readBytes(this.length);
                return true;
            }
            return false;
        }

        public String toString() {
            return "read(buffer, " + this.offset + ", " + this.length + ")";
        }
    }

    private static class RunResult {
        final List<FileOperation<?>> ops;
        final int successes;
        final Object expected;
        final Object actual;

        public RunResult(List<FileOperation<?>> ops, int successes, Object expected, Object actual) {
            this.ops = ops;
            this.successes = successes;
            this.expected = expected;
            this.actual = actual;
        }

        public boolean ok() {
            return Objects.equals(this.expected, this.actual);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunResult runResult = (RunResult)o;
            return this.successes == runResult.successes && Objects.equals(this.expected, runResult.expected) && Objects.equals(this.actual, runResult.actual);
        }

        public int hashCode() {
            return Objects.hash(this.successes, this.expected, this.actual);
        }

        public String toString() {
            return "RunResult{opsExecuted=" + this.successes + ", expected=" + this.expected + ", actual=" + this.actual + '}';
        }
    }

    private static class SeekOperation
    implements FileOperation<Void> {
        private final int offset;

        public SeekOperation(int offset) {
            this.offset = offset;
        }

        @Override
        public Void execute(RandomAccessFile file) throws IOException {
            file.seek(this.offset);
            return null;
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            state.seek(this.offset);
            return true;
        }

        public String toString() {
            return "seek(" + this.offset + ")";
        }
    }

    private static class SetLengthOperation
    implements FileOperation<Void> {
        private final int newLength;

        public SetLengthOperation(int newLength) {
            this.newLength = newLength;
        }

        @Override
        public Void execute(RandomAccessFile file) throws IOException {
            file.setLength(this.newLength);
            return null;
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            state.setLength(this.newLength);
            return true;
        }

        public String toString() {
            return "setLength(" + this.newLength + ")";
        }
    }

    private static class Write1Operation
    implements FileOperation<Void> {
        private final byte x;

        public Write1Operation(byte x) {
            this.x = x;
        }

        @Override
        public Void execute(RandomAccessFile file) throws IOException {
            file.write(this.x);
            return null;
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            state.writeBytes(1);
            return true;
        }

        public String toString() {
            return "write(" + this.x + ")";
        }
    }

    private static class WriteArrayOperation
    implements FileOperation<Void> {
        private final byte[] buffer;
        private final int offset;
        private final int length;

        public WriteArrayOperation(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public Void execute(RandomAccessFile file) throws IOException {
            file.write(this.buffer, this.offset, this.length);
            return null;
        }

        @Override
        public boolean simulateIfWellDefined(AbstractFileState state) {
            state.writeBytes(this.length);
            return true;
        }

        public String toString() {
            return "write(" + Arrays.toString(this.buffer) + ", " + this.offset + ", " + this.length + ")";
        }
    }
}

