/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.util.BitSet;

public class AbstractFileState {
    private int cursor = 0;
    private int length = 0;
    private final BitSet writtenPositions = new BitSet(1024);

    public void writeBytes(int count) {
        int newPos = this.cursor + count;
        this.writtenPositions.set(this.cursor, newPos);
        this.cursor = newPos;
        this.length = Math.max(this.length, this.cursor);
    }

    public void readBytes(int count) {
        this.cursor = Math.max(Math.min(this.cursor + count, this.length), this.cursor);
    }

    public boolean readWouldBeWellDefined(int count) {
        int end = Math.min(this.cursor + count, this.length);
        return this.writtenPositions.nextClearBit(this.cursor) >= end;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength < this.writtenPositions.length()) {
            this.writtenPositions.clear(newLength, this.writtenPositions.length());
        }
        this.cursor = Math.min(this.cursor, newLength);
        this.length = newLength;
    }

    public void seek(int pos) {
        this.cursor = pos;
    }

    public String toString() {
        return "AbstractFileState[cursor=" + this.cursor + ", length=" + this.length + ", |writtenPositions|=" + this.writtenPositions.cardinality() + "]";
    }
}

