/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.IOException;
import tlc2.tool.ModelChecker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.queue.DiskByteArrayQueue;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.MemStateQueue;
import tlc2.tool.queue.StateDeque;

public interface IStateQueue {
    public static String getStateQueueName() {
        return System.getProperty(IStateQueue.class.getName(), "DiskStateQueue");
    }

    public static IStateQueue get(String metaDir) {
        if (Factory.sq != null) {
            return Factory.sq;
        }
        if (Boolean.getBoolean(String.valueOf(ModelChecker.class.getName()) + ".BAQueue")) {
            return new DiskByteArrayQueue(metaDir);
        }
        String name = System.getProperty(IStateQueue.class.getName());
        if ("MemStateQueue".equals(name)) {
            return new MemStateQueue(metaDir);
        }
        if ("StateDeque".equals(name)) {
            return new StateDeque();
        }
        if ("DiskByteArrayQueue".equals(name)) {
            return new DiskByteArrayQueue(metaDir);
        }
        return new DiskStateQueue(metaDir);
    }

    public void enqueue(TLCState var1);

    public TLCState dequeue();

    public void sEnqueue(TLCState var1);

    public void sEnqueue(TLCState[] var1);

    public void sEnqueue(StateVec var1);

    public TLCState sDequeue();

    public TLCState sPeek();

    public TLCState[] sDequeue(int var1);

    public void finishAll();

    public boolean suspendAll();

    public void resumeAll();

    public void resumeAllStuck();

    public long size();

    public void beginChkpt() throws IOException;

    public void commitChkpt() throws IOException;

    public void recover() throws IOException;

    public boolean isEmpty();

    public void delete() throws IOException;

    public static class Factory {
        public static IStateQueue sq = null;
    }
}

