/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.Vect;
import util.Assert;

class LNConj
extends LiveExprNode {
    private final Vect<LiveExprNode> conjs;
    private int info;

    public LNConj(int size) {
        this.conjs = new Vect(size);
        this.info = 0;
    }

    public LNConj(LiveExprNode n) {
        this.conjs = new Vect(1);
        this.conjs.addElement(n);
        int level = n.getLevel();
        this.info = n.containAction() ? level + 8 : level;
    }

    public LNConj(LiveExprNode n1, LiveExprNode n2) {
        this.conjs = new Vect(2);
        this.conjs.addElement(n1);
        this.conjs.addElement(n2);
        boolean hasAct = n1.containAction() || n2.containAction();
        int level = Math.max(n1.getLevel(), n2.getLevel());
        this.info = hasAct ? level + 8 : level;
    }

    public LNConj(Vect<LiveExprNode> conjs) {
        this.conjs = conjs;
        boolean hasAct = false;
        int level = 0;
        int i = 0;
        while (i < conjs.size()) {
            LiveExprNode lexpr = conjs.elementAt(i);
            level = Math.max(level, lexpr.getLevel());
            hasAct = hasAct || lexpr.containAction();
            ++i;
        }
        this.info = hasAct ? level + 8 : level;
    }

    public final int getCount() {
        return this.conjs.size();
    }

    public final LiveExprNode getBody(int i) {
        return this.conjs.elementAt(i);
    }

    public final void addConj(LiveExprNode elem) {
        if (elem instanceof LNConj) {
            LNConj elem1 = (LNConj)elem;
            int i = 0;
            while (i < elem1.getCount()) {
                this.addConj(elem1.getBody(i));
                ++i;
            }
        } else {
            this.conjs.addElement(elem);
        }
        int level = Math.max(this.getLevel(), elem.getLevel());
        boolean hasAct = this.containAction() || elem.containAction();
        this.info = hasAct ? level + 8 : level;
    }

    @Override
    public final int getLevel() {
        return this.info & 7;
    }

    @Override
    public final boolean containAction() {
        return (this.info & 8) > 0;
    }

    @Override
    public final boolean isPositiveForm() {
        int i = 0;
        while (i < this.conjs.size()) {
            LiveExprNode lexpr = this.conjs.elementAt(i);
            if (!lexpr.isPositiveForm()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        int sz = this.conjs.size();
        int i = 0;
        while (i < sz) {
            LiveExprNode item = this.conjs.elementAt(i);
            if (!item.eval(tool, s1, s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        int len = this.getCount();
        String padding1 = String.valueOf(padding) + "    ";
        int i = 0;
        while (i < len) {
            if (i != 0) {
                sb.append(padding);
            }
            sb.append("/\\ (");
            this.getBody(i).toString(sb, padding1);
            sb.append(")");
            if (i != len - 1) {
                sb.append("\n");
            }
            ++i;
        }
    }

    @Override
    public String toDotViz() {
        int len = this.getCount();
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            sb.append("/\\ (");
            sb.append(this.getBody(i).toDotViz());
            sb.append(")");
            if (i != len - 1) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void extractPromises(TBPar promises) {
        this.getBody(0).extractPromises(promises);
        this.getBody(1).extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        int i = 0;
        while (i < this.getCount()) {
            tag = this.getBody(i).tagExpr(tag);
            ++i;
        }
        return tag;
    }

    @Override
    public final LiveExprNode makeBinary() {
        if (this.getCount() == 1) {
            return this.getBody(0).makeBinary();
        }
        int mid = this.getCount() / 2;
        LNConj left = new LNConj(0);
        LNConj right = new LNConj(0);
        int i = 0;
        while (i < this.getCount()) {
            if (i < mid) {
                left.addConj(this.getBody(i));
            } else {
                right.addConj(this.getBody(i));
            }
            ++i;
        }
        return new LNConj(left.makeBinary(), right.makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        if (this.getCount() == 1) {
            return this.getBody(0).flattenSingleJunctions();
        }
        LNConj lnc2 = new LNConj(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            lnc2.addConj(this.getBody(i).flattenSingleJunctions());
            ++i;
        }
        return lnc2;
    }

    @Override
    public final LiveExprNode toDNF() {
        int count = this.getCount();
        LiveExprNode[] temp = new LiveExprNode[count];
        int i = 0;
        while (i < count) {
            temp[i] = this.getBody(i).toDNF();
            ++i;
        }
        Vect<LiveExprNode> nes = new Vect<LiveExprNode>(count);
        int total = 1;
        int i2 = 0;
        while (i2 < count) {
            LiveExprNode elem = temp[i2];
            if (elem instanceof LNDisj) {
                nes.addElement(elem);
                try {
                    total = Math.multiplyExact(total, ((LNDisj)elem).getCount());
                }
                catch (ArithmeticException e) {
                    Assert.fail(2213, "because it exceeds the maximum supported size in disjunctive normal form.");
                }
            } else if (elem instanceof LNConj) {
                LNConj elem1 = (LNConj)elem;
                int count1 = elem1.getCount();
                int j = 0;
                while (j < count1) {
                    nes.addElement(elem1.getBody(j));
                    ++j;
                }
            } else {
                nes.addElement(elem);
            }
            ++i2;
        }
        if (total == 1) {
            return new LNConj(nes);
        }
        int nesSize = nes.size();
        Vect<LiveExprNode> res = new Vect<LiveExprNode>(total);
        int i3 = 0;
        while (i3 < total) {
            res.addElement(new LNConj(nesSize));
            ++i3;
        }
        int num = 1;
        int rCount = total;
        int i4 = 0;
        while (i4 < nesSize) {
            LiveExprNode ln = nes.elementAt(i4);
            if (ln instanceof LNDisj) {
                LNDisj disj = (LNDisj)ln;
                rCount /= disj.getCount();
                int idx = 0;
                int j = 0;
                while (j < num) {
                    int k = 0;
                    while (k < disj.getCount()) {
                        LiveExprNode elem = disj.getBody(k);
                        int l = 0;
                        while (l < rCount) {
                            ((LNConj)res.elementAt(idx++)).addConj(elem);
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                num *= disj.getCount();
            } else {
                int j = 0;
                while (j < total) {
                    ((LNConj)res.elementAt(j)).addConj(ln);
                    ++j;
                }
            }
            ++i4;
        }
        return new LNDisj(res);
    }

    @Override
    public LiveExprNode simplify() {
        LNConj lnc1 = new LNConj(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            LiveExprNode elem = this.getBody(i).simplify();
            if (elem instanceof LNBool) {
                if (!((LNBool)elem).b) {
                    return LNBool.FALSE;
                }
            } else {
                lnc1.addConj(elem);
            }
            ++i;
        }
        if (lnc1.getCount() == 0) {
            return LNBool.TRUE;
        }
        if (lnc1.getCount() == 1) {
            return lnc1.getBody(0);
        }
        return lnc1;
    }

    @Override
    public boolean isGeneralTF() {
        int i = 0;
        while (i < this.getCount()) {
            if (!this.getBody(i).isGeneralTF()) {
                return false;
            }
            ++i;
        }
        return super.isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        LNDisj lnd = new LNDisj(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            lnd.addDisj(this.getBody(i).pushNeg());
            ++i;
        }
        return lnd;
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            LNDisj lnd = new LNDisj(this.getCount());
            int i = 0;
            while (i < this.getCount()) {
                lnd.addDisj(this.getBody(i).pushNeg(true));
                ++i;
            }
            return lnd;
        }
        LNConj lnc1 = new LNConj(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            lnc1.addConj(this.getBody(i).pushNeg(false));
            ++i;
        }
        return lnc1;
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNConj) {
            LNConj exp2 = (LNConj)exp;
            if (this.getCount() != exp2.getCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getCount()) {
                if (!this.getBody(i).equals(exp2.getBody(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

