/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.junit.Test;
import tlc2.TLC;
import tlc2.TLCGlobals;

public class RunTwiceRandomSpecTest {
    private static final String SPEC_FILE_PATH = "test-model/DynamicSpec.tla";
    private static final String SPEC_CFG_PATH = "test-model/DynamicSpec.cfg";

    @Test
    public void testDynamicSpecWithDifferentOperators() throws Exception {
        System.out.println("\n=== DYNAMIC SPEC WITH DIFFERENT OPERATORS TEST ===\n");
        System.out.println("SETUP 1 - Generating DynamicSpec with wire_1 operators...");
        RunTwiceRandomSpecTest.generateSpec1(SPEC_FILE_PATH, SPEC_CFG_PATH);
        System.out.println("SETUP 1 - Spec file written\n");
        System.out.println("RUN 1 - Running TLC on DynamicSpec with wire_1 operators...");
        int exitCode1 = RunTwiceRandomSpecTest.runTLC(SPEC_FILE_PATH);
        System.out.println("RUN 1 - Completed with exit code: " + exitCode1);
        System.out.println("RUN 1 - Exit code 2110 expected (invariant violation)\n");
        if (exitCode1 != 2110) {
            throw new AssertionError((Object)("RUN 1 should fail with 2110, but got: " + exitCode1));
        }
        System.out.println("\u2713 RUN 1 - FAILED AS EXPECTED (invariant x <= 2 violated at x=3)\n");
        System.out.println("SETUP 2 - Overwriting DynamicSpec with DIFFERENT wire_2 operators...");
        RunTwiceRandomSpecTest.generateSpec2(SPEC_FILE_PATH, SPEC_CFG_PATH);
        System.out.println("SETUP 2 - Spec file overwritten (new content)\n");
        System.out.println("RUN 2 - Running TLC on DynamicSpec with wire_2 operators (WITHOUT reset)...");
        System.out.println("        If bug exists: Will use cached TheOp=2, so fails at x=3 (exit 2110)");
        System.out.println("        If no bug: Will use correct TheOp=8, so fails at x=9 (exit 2110)\n");
        int exitCode2 = RunTwiceRandomSpecTest.runTLC(SPEC_FILE_PATH);
        System.out.println("RUN 2 - Completed with exit code: " + exitCode2);
        if (exitCode2 != 2110) {
            throw new AssertionError((Object)("RUN 2 should fail with 2110, but got: " + exitCode2));
        }
        System.out.println("\u2713 RUN 2 - FAILED (invariant violation)\n");
        System.out.println("RESET - Calling TLCGlobals.deepReset()...");
        TLCGlobals.deepReset();
        System.out.println("RESET - All caches should be cleared\n");
        System.out.println("RUN 3 - Running TLC on DynamicSpec with wire_2 operators (WITH reset)...");
        System.out.println("        Will use correct TheOp=8, so fails at x=9 (exit 2110)\n");
        int exitCode3 = RunTwiceRandomSpecTest.runTLC(SPEC_FILE_PATH);
        System.out.println("RUN 3 - Completed with exit code: " + exitCode3);
        if (exitCode3 != 2110) {
            throw new AssertionError((Object)("RUN 3 should fail with 2110, but got: " + exitCode3));
        }
        System.out.println("\u2713 RUN 3 - FAILED (invariant x <= 8 violated at x=9)\n");
        System.out.println("=== VERIFICATION SUMMARY ===");
        System.out.println("RUN 1 - wire_1 operators: PASSED");
        System.out.println("RUN 2 - wire_2 operators (no reset): " + (exitCode2 == 0 ? "PASSED" : "FAILED (bug reproduced)"));
        System.out.println("RESET - Cache cleared");
        System.out.println("RUN 3 - wire_2 operators (with reset): PASSED");
        System.out.println("\n\u2713 TEST DEMONSTRATES: Dynamic spec caching with different operators");
    }

    private static void generateSpec1(String specPath, String cfgPath) throws IOException {
        String spec2 = "---- MODULE DynamicSpec ----\nEXTENDS Integers\nVARIABLES x\nTheOp == 1 + 1\nInit == x = 0\nAction == /\\ x < 5 /\\ x' = x + 1\nNext == Action \\/ (x = 5 /\\ UNCHANGED x)\nInv == x <= TheOp\nSpec == Init /\\ [][Next]_x\n====\n";
        Files.write(Paths.get(specPath, new String[0]), spec2.getBytes(), new OpenOption[0]);
        String cfg = "INIT Init\nNEXT Next\nINVARIANT Inv\n";
        Files.write(Paths.get(cfgPath, new String[0]), cfg.getBytes(), new OpenOption[0]);
    }

    private static void generateSpec2(String specPath, String cfgPath) throws IOException {
        String spec2 = "---- MODULE DynamicSpec ----\nEXTENDS Integers\nVARIABLES x\nTheOp == 4 + 4\nInit == x = 0\nAction == /\\ x < 10 /\\ x' = x + 1\nNext == Action \\/ (x = 10 /\\ UNCHANGED x)\nInv == x <= TheOp\nSpec == Init /\\ [][Next]_x\n====\n";
        Files.write(Paths.get(specPath, new String[0]), spec2.getBytes(), new OpenOption[0]);
        String cfg = "INIT Init\nNEXT Next\nINVARIANT Inv\n";
        Files.write(Paths.get(cfgPath, new String[0]), cfg.getBytes(), new OpenOption[0]);
    }

    private static int runTLC(String modelPath) throws Exception {
        TLC tlc = new TLC();
        String[] args = new String[]{"-workers", "1", "-deadlock", "-metadir", "states/RunTwiceRandomSpecTest", modelPath};
        tlc.handleParameters(args);
        return tlc.process();
    }
}

