/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.SetOfLong;
import tlc2.util.Vect;

public class TBGraphNode {
    private final TBPar par;
    public final Vect<TBGraphNode> nexts;
    private int index;
    private final LiveExprNode[] statePreds;

    public TBGraphNode(TBPar par) {
        this.par = par;
        this.index = 0;
        this.nexts = new Vect();
        TBPar preds = new TBPar(par.size());
        int i = 0;
        while (i < par.size()) {
            LiveExprNode ln = par.exprAt(i);
            if (ln.getLevel() <= 1) {
                preds.addElement(ln);
            }
            ++i;
        }
        this.statePreds = new LiveExprNode[preds.size()];
        i = 0;
        while (i < preds.size()) {
            this.statePreds[i] = preds.exprAt(i);
            ++i;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        assert (i >= 0);
        this.index = i;
    }

    public final TBPar getPar() {
        return this.par;
    }

    public int nextSize() {
        return this.nexts.size();
    }

    public TBGraphNode nextAt(int i) {
        return this.nexts.elementAt(i);
    }

    public final boolean hasLink(TBGraphNode target) {
        int sz = this.nexts.size();
        int i = 0;
        while (i < sz) {
            if (this.nexts.elementAt(i) == target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConsistent(TLCState state, ITool tool) {
        int j = 0;
        while (j < this.statePreds.length) {
            if (!this.statePreds[j].eval(tool, state, null)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private final boolean isSelfLoop() {
        if (this.nextSize() == 1) {
            return this.nextAt(0) == this;
        }
        return false;
    }

    public final boolean isAccepting() {
        return this.par.isEmpty() && this.isSelfLoop();
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        SetOfLong visited = new SetOfLong(16);
        this.toString(buf, visited);
        return buf.toString();
    }

    private final void toString(StringBuffer buf, SetOfLong visited) {
        if (!visited.put(this.index)) {
            buf.append(this.par.toString());
            int i = 0;
            while (i < this.nexts.size()) {
                buf.append(String.valueOf(this.nextAt((int)i).index) + " ");
                ++i;
            }
            buf.append("\n");
            i = 0;
            while (i < this.nexts.size()) {
                this.nextAt(i).toString(buf, visited);
                ++i;
            }
        }
    }

    public String toDotViz(boolean isInitNode) {
        String label = "\"Id: " + this.index + "\n" + this.par.toDotViz() + "\"";
        StringBuffer buf = new StringBuffer(this.nextSize());
        buf.append(String.valueOf(this.index) + " [label=" + label + "]\n");
        if (isInitNode) {
            buf.append("[style = filled]\n");
        }
        int i = 0;
        while (i < this.nextSize()) {
            TBGraphNode successor = this.nextAt(i);
            buf.append(String.valueOf(this.index) + " -> " + successor.index);
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }
}

