/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.output.EC;
import tlc2.output.StatePrinter;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.util.IStateWriter;
import tlc2.util.NoopStateWriter;
import util.ToolIO;

public abstract class CheckImpl
extends ModelChecker {
    private static int TraceDuration = 30000;
    private int depth;
    private FPSet coverSet;
    private TLCState curState;
    private TLCTrace.Enumerator stateEnum;
    private long lastTraceTime;

    public CheckImpl(ITool tool, String metadir, boolean deadlock, int depth, String fromChkpt, FPSetConfiguration fpSetConfig) throws IOException {
        super(tool, metadir, (IStateWriter)new NoopStateWriter(), deadlock, fromChkpt, fpSetConfig, System.currentTimeMillis());
        this.depth = depth;
        this.curState = null;
        this.coverSet = FPSetFactory.getFPSet();
        this.coverSet.init(TLCGlobals.getNumWorkers(), this.metadir, String.valueOf(tool.getRootName()) + "_cs");
        this.stateEnum = null;
    }

    public final void init() throws Throwable {
        boolean recovered = this.recover();
        if (!recovered) {
            this.checkAssumptions();
            this.doInit(false);
        }
        ToolIO.out.println("Creating a partial state space of depth " + this.depth + " ... ");
        int result = this.runTLC(this.depth);
        if (result != 0) {
            ToolIO.out.println("\nExit: failed to create the partial state space.");
            System.exit(EC.ExitStatus.errorConstantToExitStatus(result));
        }
        ToolIO.out.println("completed.");
        this.lastTraceTime = System.currentTimeMillis();
        this.stateEnum = this.trace.elements();
    }

    public final void reset() throws IOException {
        this.curState = null;
        this.stateEnum.reset(-1L);
    }

    public final void makeStateSpace(TLCState st, int depth) throws Exception {
        int depth1 = this.trace.getLevel(st.uid) + depth;
        this.theStateQueue = new DiskStateQueue(this.metadir);
        this.theStateQueue.enqueue(st);
        int result = this.runTLC(depth1);
        if (result != 0) {
            System.exit(EC.ExitStatus.errorConstantToExitStatus(result));
        }
    }

    public abstract TLCState getState();

    public abstract void exportTrace(TLCStateInfo[] var1) throws IOException;

    public final boolean checkReachability(TLCState s0, TLCState s1) {
        Action next = this.tool.getNextStateSpec();
        if (!this.tool.isValid(next, s0, s1)) {
            ToolIO.out.println("The following transition is illegal: ");
            StatePrinter.printStandaloneErrorState(s0);
            StatePrinter.printStandaloneErrorState(s1);
            return false;
        }
        int cnt = this.tool.getImpliedActions().length;
        int i = 0;
        while (i < cnt) {
            if (!this.tool.isValid(this.tool.getImpliedActions()[i], s0, s1)) {
                ToolIO.out.println("Error: Action property " + this.tool.getImpliedActNames()[i] + " is violated.");
                StatePrinter.printStandaloneErrorState(s0);
                StatePrinter.printStandaloneErrorState(s1);
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean checkState(TLCState state) throws IOException {
        long fp = state.fingerPrint();
        boolean seen = this.coverSet.put(fp);
        if (!seen && !this.theFPSet.contains(fp)) {
            state.uid = this.trace.writeState(this.curState, fp);
            int cnt = this.tool.getInvariants().length;
            int j = 0;
            while (j < cnt) {
                if (!this.tool.isValid(this.tool.getInvariants()[j], state)) {
                    ToolIO.out.println("Error: Invariant " + this.tool.getInvNames()[j] + " is violated. The behavior up to this point is:");
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public final TLCStateInfo[] generateNewTrace() throws IOException {
        long pos = -1L;
        while ((pos = this.stateEnum.nextPos()) != -1L) {
            long fp = this.stateEnum.nextFP();
            if (this.coverSet.contains(fp)) continue;
            return this.trace.getTrace(pos, true);
        }
        return null;
    }

    public final void checkTrace() throws IOException {
        TLCState state;
        this.curState = this.getState();
        if (this.curState == null) {
            return;
        }
        this.checkState(this.curState);
        while ((state = this.getState()) != null) {
            this.checkState(state);
            this.checkReachability(this.curState, state);
            this.curState = state;
        }
    }

    public final void export() throws IOException {
        long curTime = System.currentTimeMillis();
        if (curTime - this.lastTraceTime > (long)TraceDuration) {
            TLCStateInfo[] states = this.generateNewTrace();
            if (states != null) {
                this.exportTrace(states);
            }
            this.lastTraceTime = curTime;
        }
    }
}

