/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.HeapBasedDiskFPSet;
import tlc2.util.BufferedRandomAccessFile;
import util.Assert;

public class LSBDiskFPSet
extends HeapBasedDiskFPSet {
    protected LSBDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        this.flusher = new LSBFlusher();
    }

    @Override
    protected double getAuxiliaryStorageRequirement() {
        return 2.5;
    }

    public class LSBFlusher
    extends DiskFPSet.Flusher {
        private long[] buff;

        @Override
        protected void prepareTable() {
            int cnt = (int)LSBDiskFPSet.this.getTblCnt();
            Assert.check(cnt > 0, 1000);
            this.buff = new long[cnt];
            int idx = 0;
            int j = 0;
            while (j < LSBDiskFPSet.this.tbl.length) {
                long[] bucket = LSBDiskFPSet.this.tbl[j];
                if (bucket != null) {
                    int blen = bucket.length;
                    int k = 0;
                    while (k < blen && bucket[k] > 0L) {
                        this.buff[idx++] = bucket[k];
                        int n = k++;
                        bucket[n] = bucket[n] | Long.MIN_VALUE;
                    }
                }
                ++j;
            }
            Arrays.sort(this.buff, 0, this.buff.length);
        }

        @Override
        protected void mergeNewEntries(BufferedRandomAccessFile[] inRAFs, BufferedRandomAccessFile outRAF) throws IOException {
            int buffLen = this.buff.length;
            long maxVal = this.buff[buffLen - 1];
            if (LSBDiskFPSet.this.index != null) {
                maxVal = Math.max(maxVal, LSBDiskFPSet.this.index[LSBDiskFPSet.this.index.length - 1]);
            }
            int indexLen = LSBDiskFPSet.this.calculateIndexLen(buffLen);
            LSBDiskFPSet.this.index = new long[indexLen];
            LSBDiskFPSet.this.index[indexLen - 1] = maxVal;
            LSBDiskFPSet.this.currIndex = 0;
            LSBDiskFPSet.this.counter = 0;
            int i = 0;
            long value = 0L;
            boolean eof = false;
            if (LSBDiskFPSet.this.fileCnt > 0L) {
                try {
                    value = inRAFs[0].readLong();
                }
                catch (EOFException e) {
                    eof = true;
                }
            } else {
                eof = true;
            }
            while (!eof && i < buffLen) {
                if (value < this.buff[i]) {
                    LSBDiskFPSet.this.writeFP(outRAF, value);
                    try {
                        value = inRAFs[0].readLong();
                    }
                    catch (EOFException e) {
                        eof = true;
                    }
                    continue;
                }
                if (value == this.buff[i]) {
                    Assert.check(false, 2166, String.valueOf(value));
                }
                LSBDiskFPSet.this.writeFP(outRAF, this.buff[i++]);
            }
            if (eof) {
                while (i < buffLen) {
                    LSBDiskFPSet.this.writeFP(outRAF, this.buff[i++]);
                }
            } else {
                do {
                    LSBDiskFPSet.this.writeFP(outRAF, value);
                    try {
                        value = inRAFs[0].readLong();
                    }
                    catch (EOFException e) {
                        eof = true;
                    }
                } while (!eof);
            }
            Assert.check(LSBDiskFPSet.this.currIndex == indexLen - 1, 2134);
            LSBDiskFPSet.this.fileCnt += (long)buffLen;
        }
    }
}

