/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import org.junit.Test;
import tlc2.TLC;
import tlc2.TLCGlobals;

public class RunTwicePersistentFlagTest {
    @Test
    public void testTLCGlobalsReset() throws Exception {
        if (TLCGlobals.mainChecker != null) {
            throw new AssertionError((Object)"TLCGlobals.mainChecker should be null before any run");
        }
        Object[] checkers = new Object[7];
        int[] exitCodes = new int[7];
        exitCodes[0] = RunTwicePersistentFlagTest.runTLC("test-model/ModelCounter.tla");
        if (exitCodes[0] == 0) {
            throw new AssertionError((Object)"ModelCounter should fail with invariant violation, but passed");
        }
        if (TLCGlobals.mainChecker == null) {
            throw new AssertionError((Object)"TLCGlobals.mainChecker should be set after ModelCounter run");
        }
        checkers[0] = TLCGlobals.mainChecker;
        System.out.println("RUN 1 - ModelCounter (FAIL): " + checkers[0]);
        exitCodes[1] = RunTwicePersistentFlagTest.runTLC("test-model/ModelString.tla");
        if (exitCodes[1] != 0) {
            throw new AssertionError((Object)("ModelString should pass, but failed with exit code: " + exitCodes[1]));
        }
        checkers[1] = TLCGlobals.mainChecker;
        if (checkers[0] == checkers[1]) {
            throw new AssertionError((Object)"Run 1 and 2 should have different checker instances");
        }
        System.out.println("RUN 2 - ModelString (PASS): " + checkers[1]);
        exitCodes[2] = RunTwicePersistentFlagTest.runTLC("test-model/ModelSequence.tla");
        if (exitCodes[2] != 0) {
            throw new AssertionError((Object)("ModelSequence should pass, but failed with exit code: " + exitCodes[2]));
        }
        checkers[2] = TLCGlobals.mainChecker;
        if (checkers[1] == checkers[2]) {
            throw new AssertionError((Object)"Run 2 and 3 should have different checker instances");
        }
        System.out.println("RUN 3 - ModelSequence (PASS): " + checkers[2]);
        TLCGlobals.reset();
        if (TLCGlobals.mainChecker != null) {
            throw new AssertionError((Object)"TLCGlobals.mainChecker should be null after reset 1");
        }
        System.out.println("RESET 1 - State cleared");
        exitCodes[3] = RunTwicePersistentFlagTest.runTLC("test-model/ModelQueue.tla");
        if (exitCodes[3] != 0) {
            throw new AssertionError((Object)("ModelQueue should pass, but failed with exit code: " + exitCodes[3]));
        }
        checkers[3] = TLCGlobals.mainChecker;
        int i = 0;
        while (i < 3) {
            if (checkers[i] == checkers[3]) {
                throw new AssertionError((Object)("Run 4 checker should differ from run " + (i + 1) + " checker"));
            }
            ++i;
        }
        System.out.println("RUN 4 - ModelQueue (PASS): " + checkers[3]);
        exitCodes[4] = RunTwicePersistentFlagTest.runTLC("test-model/ModelSet.tla");
        if (exitCodes[4] != 0) {
            throw new AssertionError((Object)("ModelSet should pass, but failed with exit code: " + exitCodes[4]));
        }
        checkers[4] = TLCGlobals.mainChecker;
        i = 0;
        while (i < 4) {
            if (checkers[i] == checkers[4]) {
                throw new AssertionError((Object)("Run 5 checker should differ from run " + (i + 1) + " checker"));
            }
            ++i;
        }
        System.out.println("RUN 5 - ModelSet (PASS): " + checkers[4]);
        exitCodes[5] = RunTwicePersistentFlagTest.runTLC("test-model/ModelTuple.tla");
        if (exitCodes[5] != 0) {
            throw new AssertionError((Object)("ModelTuple should pass, but failed with exit code: " + exitCodes[5]));
        }
        checkers[5] = TLCGlobals.mainChecker;
        i = 0;
        while (i < 5) {
            if (checkers[i] == checkers[5]) {
                throw new AssertionError((Object)("Run 6 checker should differ from run " + (i + 1) + " checker"));
            }
            ++i;
        }
        System.out.println("RUN 6 - ModelTuple (PASS): " + checkers[5]);
        TLCGlobals.reset();
        if (TLCGlobals.mainChecker != null) {
            throw new AssertionError((Object)"TLCGlobals.mainChecker should be null after reset 2");
        }
        System.out.println("RESET 2 - State cleared");
        exitCodes[6] = RunTwicePersistentFlagTest.runTLC("test-model/ModelComplexQueue.tla");
        if (exitCodes[6] == 0) {
            throw new AssertionError((Object)"ModelComplexQueue should fail with invariant violation, but passed");
        }
        checkers[6] = TLCGlobals.mainChecker;
        i = 0;
        while (i < 6) {
            if (checkers[i] == checkers[6]) {
                throw new AssertionError((Object)("Run 7 checker should differ from run " + (i + 1) + " checker"));
            }
            ++i;
        }
        System.out.println("RUN 7 - ModelComplexQueue (FAIL - INVARIANT VIOLATION): " + checkers[6]);
        System.out.println("\n=== VERIFICATION SUMMARY ===");
        System.out.println("Total runs: 7");
        System.out.println("Pass runs: 5 (ModelString, ModelSequence, ModelQueue, ModelSet, ModelTuple)");
        System.out.println("Fail runs: 2 (ModelCounter with invariant violation, ModelComplexQueue with invariant violation)");
        System.out.println("All 7 checker instances are unique: YES");
        System.out.println("Reset clears state: YES (checked 2x)");
        System.out.println("\n\u2713 TEST PASSED: 7 models demonstrate persistent global state and effective reset");
    }

    private static int runTLC(String modelPath) throws Exception {
        TLC tlc = new TLC();
        String[] args = new String[]{"-workers", "1", "-deadlock", "-metadir", "states/RunTwicePersistentFlagTest", modelPath};
        tlc.handleParameters(args);
        return tlc.process();
    }
}

