/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayDeque;
import java.util.Deque;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class SymbolTable
implements ASTConstants {
    private final Deque<Context> contextStack;
    private Context topContext;
    private Context baseContext;
    private ExternalModuleTable mt;
    private ModuleNode modNode;
    private Errors errors;

    public SymbolTable(ExternalModuleTable mt, Errors errs) {
        this.baseContext = this.topContext = Context.getGlobalContext().duplicate(mt);
        this.errors = errs;
        this.contextStack = new ArrayDeque<Context>();
        this.contextStack.addFirst(this.topContext);
        this.mt = mt;
    }

    public SymbolTable(ExternalModuleTable mt, Errors errs, SymbolTable st) {
        this.modNode = st.modNode;
        this.errors = errs;
        this.contextStack = new ArrayDeque<Context>(st.contextStack);
        this.baseContext = this.contextStack.peekLast();
        this.mt = mt;
    }

    public final Context getExternalContext() {
        return this.baseContext;
    }

    public final Context getContext() {
        return this.topContext;
    }

    public final void pushContext(Context ct) {
        this.contextStack.addFirst(ct);
        this.topContext = ct;
    }

    public final void popContext() {
        this.contextStack.removeFirst();
        this.topContext = this.contextStack.peekFirst();
    }

    public final void setModuleNode(ModuleNode mn) {
        this.modNode = mn;
    }

    public final ModuleNode getModuleNode() {
        return this.modNode;
    }

    public final SymbolNode resolveSymbol(UniqueString name) {
        for (Context ct : this.contextStack) {
            SymbolNode r = ct.getSymbol(name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public final ModuleNode resolveModule(UniqueString name) {
        ModuleName modName = new ModuleName(name);
        for (Context ct : this.contextStack) {
            SymbolNode res = ct.getSymbol(modName);
            if (res == null) continue;
            return (ModuleNode)res;
        }
        return this.mt.getModuleNode(name);
    }

    public final boolean addSymbol(UniqueString name, SymbolNode symbol) {
        SymbolNode currentBinding = this.resolveSymbol(name);
        if (currentBinding == symbol) {
            return true;
        }
        if (currentBinding == null) {
            this.topContext.addSymbolToContext(name, symbol);
            return true;
        }
        if (currentBinding.getTreeNode().getLocation().source().equals("--TLA+ BUILTINS--")) {
            this.errors.addError(ErrorCode.BUILT_IN_SYMBOL_REDEFINED, symbol.getTreeNode().getLocation(), "Symbol " + name + " is a built-in operator, and cannot be redefined.");
            return false;
        }
        if (symbol.getKind() == 11 || symbol.getKind() == 4 || currentBinding.getKind() != symbol.getKind() || currentBinding.getArity() != symbol.getArity()) {
            this.errors.addError(ErrorCode.SYMBOL_REDEFINED, symbol.getTreeNode().getLocation(), "Multiply-defined symbol '" + name + "': this definition or declaration conflicts \nwith the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
            return false;
        }
        if (symbol.sameOriginallyDefinedInModule(currentBinding)) {
            return true;
        }
        this.errors.addWarning(ErrorCode.INSTANCED_MODULES_SYMBOL_UNIFICATION_AMBIGUITY, symbol.getTreeNode().getLocation(), "Multiple declarations or definitions for symbol " + name + ".  \nThis duplicates the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
        return true;
    }

    public final boolean addModule(UniqueString name, ModuleNode symbol) {
        ModuleNode currentBinding = this.resolveModule(name);
        if (currentBinding == symbol) {
            return true;
        }
        if (currentBinding == null) {
            ModuleName modName = new ModuleName(name);
            this.topContext.addSymbolToContext(modName, symbol);
            return true;
        }
        this.errors.addError(ErrorCode.MODULE_REDEFINED, symbol.getTreeNode().getLocation(), "Multiply-defined module '" + name + "': this definition or declaration conflicts \nwith the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
        return false;
    }

    public String toString() {
        String ret = "\n\n***SymbolTable\n\n*** top context";
        for (Context ct : this.contextStack) {
            Vector<String> v = ct.getContextEntryStringVector(1, true, this.errors);
            int i = 0;
            while (i < v.size()) {
                ret = String.valueOf(ret) + v.elementAt(i);
                ++i;
            }
            ret = String.valueOf(ret) + "\n\n*** next context\n";
        }
        return ret;
    }

    static class ModuleName {
        UniqueString name;

        ModuleName(UniqueString name) {
            this.name = name;
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof ModuleName && this.name.equals(((ModuleName)obj).name);
        }

        public final String toString() {
            return this.name.toString();
        }
    }
}

