/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import tla2sany.api.ModuleSourceCode;
import tla2sany.api.Resolver;
import tla2sany.api.SANYFrontend;

public class DefaultResolver
implements Resolver {
    private final List<Path> searchPaths;
    private static final String[] STANDARD_MODULES = new String[]{"Naturals", "Sequences", "FiniteSets", "TLC", "Bags", "Integers", "Reals", "Json", "Randomization", "RealTime", "TLCExt", "Toolbox"};

    @Override
    public ModuleSourceCode resolve(String moduleName) {
        String moduleFileName = String.valueOf(moduleName) + ".tla";
        if (DefaultResolver.isStandardModule(moduleName)) {
            String resourcePath = "/tla2sany/StandardModules/" + moduleFileName;
            try {
                Throwable throwable = null;
                Object var5_9 = null;
                try (InputStream module = SANYFrontend.class.getResourceAsStream(resourcePath);){
                    if (module == null) {
                        throw new RuntimeException("ERROR: Missing standard module " + moduleName);
                    }
                    byte[] text = module.readAllBytes();
                    return new ModuleSourceCode(text, ModuleSourceCode.ModuleOrigin.STANDARD_MODULES, Path.of(resourcePath, new String[0]));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("ERROR: Unable to read standard module " + moduleName);
            }
        }
        for (Path directory : this.searchPaths) {
            Path modulePath = directory.resolve(moduleFileName);
            try {
                Throwable throwable = null;
                Object var7_17 = null;
                try (FileInputStream module = new FileInputStream(modulePath.toFile());){
                    byte[] text = ((InputStream)module).readAllBytes();
                    return new ModuleSourceCode(text, ModuleSourceCode.ModuleOrigin.FILESYSTEM, modulePath);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public DefaultResolver(Path ... searchPaths) {
        this.searchPaths = Arrays.asList(searchPaths);
    }

    private static boolean isStandardModule(String moduleName) {
        String[] stringArray = STANDARD_MODULES;
        int n = STANDARD_MODULES.length;
        int n2 = 0;
        while (n2 < n) {
            String standardModule = stringArray[n2];
            if (moduleName.equals(standardModule)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

