/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import util.AstNode;

public class SyntaxCorpusFileParser {
    private static final Pattern headerRegex = Pattern.compile("^===+\\|\\|\\|\r?\n(?<testName>.*?(?=\r?\n===+\\|\\|\\|))\r?\n===+\\|\\|\\|\r?\n", 40);
    private static final Pattern separatorRegex = Pattern.compile("^---+\\|\\|\\|\r?\n", 8);

    private static List<Token> tokenize(String input) throws ParseException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int[] codepoints = input.codePoints().toArray();
        StringBuilder sb = null;
        int i = 0;
        while (i < codepoints.length) {
            int codepoint = codepoints[i];
            if (Character.isLetter(codepoint) || Character.isDigit(codepoint) || 95 == codepoint) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.appendCodePoint(codepoint);
            } else {
                if (sb != null) {
                    tokens.add(new Token(sb.toString(), Token.Kind.IDENTIFIER));
                    sb = null;
                }
                if (!Character.isWhitespace(codepoint)) {
                    if (58 == codepoint) {
                        tokens.add(new Token(Character.toString(codepoint), Token.Kind.COLON));
                    } else if (40 == codepoint) {
                        tokens.add(new Token(Character.toString(codepoint), Token.Kind.LPAREN));
                    } else if (41 == codepoint) {
                        tokens.add(new Token(Character.toString(codepoint), Token.Kind.RPAREN));
                    } else {
                        throw new ParseException(String.format("Unhandled char %s", Character.toString(codepoint)), i);
                    }
                }
            }
            ++i;
        }
        return tokens;
    }

    private static AstNode parseAst(ParserState parser) throws ParseException {
        parser.consume(Token.Kind.LPAREN);
        Token nodeKind = parser.consume(Token.Kind.IDENTIFIER);
        AstNode node = AstNode.Kind.fromString(nodeKind.lexeme).asNode();
        while (!parser.isAtEnd() && !parser.check(Token.Kind.RPAREN)) {
            if (parser.check(Token.Kind.LPAREN)) {
                node.addChild(SyntaxCorpusFileParser.parseAst(parser));
                continue;
            }
            String fieldName = parser.consume((Token.Kind)Token.Kind.IDENTIFIER).lexeme;
            parser.consume(Token.Kind.COLON);
            node.addField(fieldName, SyntaxCorpusFileParser.parseAst(parser));
        }
        parser.consume(Token.Kind.RPAREN);
        return node;
    }

    private static AstNode parseAst(String input) throws ParseException {
        ParserState parser = new ParserState(SyntaxCorpusFileParser.tokenize(input), false);
        AstNode parseTree = SyntaxCorpusFileParser.parseAst(parser);
        if (!parser.isAtEnd()) {
            throw new ParseException("Unparsed tokens remain", parser.current);
        }
        return parseTree;
    }

    private static List<CorpusTest> getCorpusTests(Path path, String content) throws ParseException {
        ArrayList<CorpusTest> tests = new ArrayList<CorpusTest>();
        Matcher headerMatcher = headerRegex.matcher(content);
        Matcher separatorMatcher = separatorRegex.matcher(content);
        boolean hasNext = headerMatcher.find();
        while (hasNext) {
            String testName = headerMatcher.group("testName");
            if (!separatorMatcher.find()) {
                throw new ParseException(String.format("%s: Test %s does not have separator", path, testName), 0);
            }
            String tlaplusInput = content.substring(headerMatcher.end(), separatorMatcher.start());
            hasNext = headerMatcher.find();
            String expectedAst = hasNext ? content.substring(separatorMatcher.end(), headerMatcher.start()) : content.substring(separatorMatcher.end());
            tests.add(new CorpusTest(path, testName, tlaplusInput, expectedAst));
        }
        if (tests.isEmpty()) {
            throw new ParseException(String.format("%s: Failed to find any tests", path), 0);
        }
        return tests;
    }

    public static List<CorpusTest> getAllTestsUnder(Path corpusDir) throws IOException, ParseException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/*.txt");
        ArrayList<CorpusTest> corpus = new ArrayList<CorpusTest>();
        for (Path path : Files.walk(corpusDir, new FileVisitOption[0]).filter(matcher::matches).collect(Collectors.toList())) {
            String content = Files.readString(path);
            corpus.addAll(SyntaxCorpusFileParser.getCorpusTests(path, content));
        }
        return corpus;
    }

    public static class CorpusTest {
        public final Path file;
        public final String name;
        public final String tlaplusInput;
        public final AstNode expectedAst;
        public final List<Attribute> attributes;

        public CorpusTest(Path file, String header, String tlaplusInput, String expectedAst) throws ParseException {
            this.file = file;
            this.name = CorpusTest.getTestName(header);
            this.attributes = CorpusTest.getTestAttributes(header);
            this.tlaplusInput = tlaplusInput;
            this.expectedAst = this.attributes.contains((Object)Attribute.ERROR) ? null : SyntaxCorpusFileParser.parseAst(expectedAst);
        }

        public String toString() {
            return this.name;
        }

        private static String getTestName(String header) {
            return header.lines().takeWhile(line -> !line.startsWith(":")).collect(Collectors.joining("\n")).trim();
        }

        private static List<Attribute> getTestAttributes(String header) {
            return header.lines().filter(line -> line.startsWith(":")).map(tag -> CorpusTest.tagToAttribute(tag)).collect(Collectors.toList());
        }

        private static Attribute tagToAttribute(String tag) {
            String tagName = tag.strip().substring(1);
            return Stream.of(Attribute.values()).filter(attribute -> attribute.name().equalsIgnoreCase(tagName)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Invalid test attribute %s", tag)));
        }

        public static enum Attribute {
            SKIP,
            ERROR;

        }
    }

    private static class ParserState {
        public int current = 0;
        public final List<Token> tokens;
        private final boolean log;

        public ParserState(List<Token> tokens, boolean log) {
            this.tokens = tokens;
            this.log = log;
        }

        public boolean isAtEnd() {
            return this.current == this.tokens.size();
        }

        public Token peek() {
            return this.tokens.get(this.current);
        }

        public Token previous() {
            return this.tokens.get(this.current - 1);
        }

        public boolean check(Token.Kind kind) {
            if (this.isAtEnd()) {
                return false;
            }
            return this.peek().kind == kind;
        }

        public Token advance() {
            if (!this.isAtEnd()) {
                ++this.current;
            }
            if (this.log) {
                System.out.println(this.previous().lexeme);
            }
            return this.previous();
        }

        public Token consume(Token.Kind kind) throws ParseException {
            if (this.check(kind)) {
                return this.advance();
            }
            throw new ParseException(String.format("Expected %s", new Object[]{kind}), this.current);
        }
    }

    private static class Token {
        public final String lexeme;
        public final Kind kind;

        public Token(String lexeme, Kind kind) {
            this.lexeme = lexeme;
            this.kind = kind;
        }

        private static enum Kind {
            IDENTIFIER,
            LPAREN,
            RPAREN,
            COLON;

        }
    }
}

