/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;

public abstract class ObjectStack {
    protected int len = 0;

    public final void push(Object state) {
        this.enqueueInner(state);
        ++this.len;
    }

    public final Object pop() {
        if (this.len == 0) {
            return null;
        }
        Object state = this.dequeueInner();
        --this.len;
        return state;
    }

    public final synchronized void spush(Object state) {
        this.enqueueInner(state);
        ++this.len;
    }

    public final synchronized void spush(Object[] states) {
        int i = 0;
        while (i < states.length) {
            this.enqueueInner(states[i]);
            ++i;
        }
        this.len += states.length;
    }

    public final synchronized Object spop() {
        Object state = this.dequeueInner();
        --this.len;
        return state;
    }

    public final synchronized Object[] spop(int cnt) {
        Object[] states = new Object[cnt];
        int idx = 0;
        while (idx < cnt && this.len > 0) {
            states[idx] = this.dequeueInner();
            --this.len;
            ++idx;
        }
        if (idx == cnt) {
            return states;
        }
        Object[] res = new Object[idx];
        int i = 0;
        while (i < idx) {
            res[i] = states[i];
            ++i;
        }
        return res;
    }

    public final int size() {
        return this.len;
    }

    abstract void enqueueInner(Object var1);

    abstract Object dequeueInner();

    public abstract void beginChkpt() throws IOException;

    public abstract void commitChkpt() throws IOException;

    public abstract void recover() throws IOException;
}

