/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import tlc2.TLC;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Simulator;

public class TLCGlobals {
    public static final int DEFAULT_CHECKPOINT_DURATION = 1800042;
    public static String versionOfTLC = "Version 2.20 of Day Month 20??";
    public static int enumBound = 2000;
    public static int setBound = 1000000;
    private static int numWorkers = 1;
    public static double livenessThreshold = 0.1;
    public static double livenessGraphSizeThreshold = 0.1;
    public static double livenessRatio = 0.2;
    public static String lnCheck = "default";
    public static AbstractChecker mainChecker = null;
    public static Simulator simulator = null;
    public static final char coverageIndent = '|';
    public static int coverageInterval = -1;
    public static int DFIDMax = -1;
    public static boolean continuation = false;
    public static boolean printDiffsOnly = false;
    public static boolean warn = true;
    public static final int progressInterval = Math.max(Math.abs(Integer.getInteger(String.valueOf(TLC.class.getName()) + ".progressInterval", 60)), 1) * 1000;
    public static long chkptDuration = Integer.getInteger(String.valueOf(TLCGlobals.class.getName()) + ".chkpt", 1800042).intValue();
    private static boolean forceChkpt = false;
    private static long lastChkpt = System.currentTimeMillis();
    public static final String metaRoot = "states";
    public static String metaDir = null;
    public static boolean useView = false;
    public static boolean useGZIP = false;
    public static boolean debug = false;
    public static boolean tool = false;
    public static boolean expand = true;

    public static boolean doLiveness() {
        return !lnCheck.equals("final") && !lnCheck.equals("seqfinal") && !lnCheck.equals("off");
    }

    public static boolean doSequentialLiveness() {
        return lnCheck.startsWith("seq");
    }

    public static synchronized void setNumWorkers(int n) {
        numWorkers = n;
    }

    public static synchronized int getNumWorkers() {
        return numWorkers;
    }

    public static synchronized void incNumWorkers(int n) {
        numWorkers += n;
    }

    public static void incNumWorkers() {
        TLCGlobals.incNumWorkers(1);
    }

    public static void decNumWorkers() {
        TLCGlobals.incNumWorkers(-1);
    }

    public static final boolean isCoverageEnabled() {
        return coverageInterval >= 0;
    }

    public static void forceChkpt() {
        forceChkpt = true;
    }

    public static boolean chkptExplicitlyEnabled() {
        return chkptDuration > 0L && chkptDuration != 1800042L;
    }

    public static boolean doCheckPoint() {
        if (forceChkpt) {
            forceChkpt = false;
            return true;
        }
        if (chkptDuration == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastChkpt >= chkptDuration) {
            lastChkpt = now;
            return true;
        }
        return false;
    }

    public static boolean isValidSetSize(int bound) {
        return bound >= 1;
    }

    public static String getRevision() {
        return TLCGlobals.getManifestValue("X-Git-ShortRevision");
    }

    public static String getRevisionOrDev() {
        return TLCGlobals.getRevision() == null ? "development" : TLCGlobals.getRevision();
    }

    public static Date getBuildDate() {
        try {
            String manifestValue = TLCGlobals.getManifestValue("Build-TimeStamp");
            if (manifestValue == null) {
                return new Date();
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.parse(manifestValue);
        }
        catch (NullPointerException | ParseException e) {
            return new Date();
        }
    }

    public static int getSCMCommits() {
        try {
            return Integer.parseInt(TLCGlobals.getManifestValue("X-Git-Commits-Count"));
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getManifestValue(String key) {
        try {
            Manifest manifest;
            Attributes attributes;
            Enumeration<URL> resources = TLCGlobals.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            do {
                if (resources.hasMoreElements()) continue;
                return null;
            } while (!"TLA+ Tools".equals((attributes = (manifest = new Manifest(resources.nextElement().openStream())).getMainAttributes()).getValue("Implementation-Title")));
            if (attributes.getValue(key) == null) return null;
            return attributes.getValue(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getInstallLocation() {
        try {
            return new File(TLC.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            return "unknown";
        }
    }

    public static synchronized void reset() {
        mainChecker = null;
        simulator = null;
        metaDir = null;
        numWorkers = 1;
        livenessThreshold = 0.1;
        livenessGraphSizeThreshold = 0.1;
        livenessRatio = 0.2;
        lnCheck = "default";
        coverageInterval = -1;
        DFIDMax = -1;
        continuation = false;
        printDiffsOnly = false;
        warn = true;
        useView = false;
        useGZIP = false;
        debug = false;
        tool = false;
        expand = true;
        forceChkpt = false;
        lastChkpt = System.currentTimeMillis();
        if (tlc2.module.TLC.OUTPUT != null) {
            try {
                tlc2.module.TLC.OUTPUT.flush();
                tlc2.module.TLC.OUTPUT.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            tlc2.module.TLC.OUTPUT = null;
        }
    }

    public static final class Coverage {
        private static final int coverage = Integer.getInteger(String.valueOf(TLCGlobals.class.getName()) + ".coverage", 0);

        public static boolean isVariableEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return (coverage & 2) > 0;
        }

        public static boolean isActionEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return (coverage & 1) > 0;
        }

        public static boolean isEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return coverage > 0;
        }
    }
}

