/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;

public interface FilenameToStream {
    public File resolve(String var1, boolean var2);

    public String getFullPath();

    public boolean isStandardModule(String var1);

    default public boolean isLibraryModule(String moduleName) {
        return this.isStandardModule(moduleName);
    }

    public static boolean isInJar(String aString) {
        return aString.startsWith("jar:") || aString.endsWith(".jar");
    }

    public static boolean isArchive(String aString) {
        return FilenameToStream.isInJar(aString) || aString.endsWith(".zip");
    }

    public static Path getTempDirectory() {
        try {
            return Files.createTempDirectory("tlc-", new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class TLAFile
    extends File {
        private static final String ROOT_PATH_REGEX = "^([a-zA-Z]+:)?" + (File.separatorChar == '\\' ? "\\\\" : File.separator);
        private static final Pattern ROOT_PATH_PATTERN = Pattern.compile(ROOT_PATH_REGEX);
        private final boolean isLibraryModule;
        private final transient FilenameToStream resolver;
        private final URI libraryPath;

        public TLAFile(String pathname, FilenameToStream fts) {
            this(pathname, false, fts);
        }

        public TLAFile(String pathname, boolean isLibraryModule, FilenameToStream fts) {
            super(pathname);
            this.isLibraryModule = isLibraryModule;
            this.libraryPath = this.exists() ? this.toURI() : null;
            this.resolver = fts;
        }

        public TLAFile(Path path, boolean isLibraryModule, FilenameToStream fts) {
            this(path.toFile().toString(), isLibraryModule, fts);
        }

        public TLAFile(String parent, String child, FilenameToStream fts) {
            super(parent, ROOT_PATH_PATTERN.matcher(parent).find() && child.startsWith(parent) ? child.substring(parent.length()) : child);
            this.libraryPath = this.exists() ? this.toURI() : null;
            this.isLibraryModule = false;
            this.resolver = fts;
        }

        public TLAFile(String pathname, URL location, boolean isLibraryModule, FilenameToStream fts) {
            super(pathname);
            this.libraryPath = TLAFile.toNullOrURI(location);
            this.isLibraryModule = isLibraryModule;
            this.resolver = fts;
        }

        public TLAFile(Path path, URL location, boolean isLibraryModule, FilenameToStream fts) {
            this(path.toFile().toString(), location, isLibraryModule, fts);
        }

        private static URI toNullOrURI(URL location) {
            try {
                return location.toURI();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public boolean isLibraryModule() {
            return this.isLibraryModule;
        }

        public File getModuleOverride() {
            File moduleOverride = this.resolver.resolve(this.getName().replaceAll(".tla$", ".class"), false);
            if (moduleOverride.exists()) {
                return moduleOverride;
            }
            return null;
        }

        public URI getLibraryPath() {
            return this.libraryPath;
        }

        public boolean hasLibraryPath() {
            return this.libraryPath != null;
        }
    }
}

