/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.List;
import tla2sany.st.Location;
import tlc2.model.MCState;
import tlc2.model.MCVariable;

public class Utils {
    public static MCState buildState(int ordinal, String name, String location, String ... assignments) {
        MCVariable[] variables = new MCVariable[assignments.length];
        int i = 0;
        while (i < assignments.length) {
            String assignment = assignments[i];
            String[] split = assignment.split("=");
            variables[i] = new MCVariable(split[0].trim(), split[1].trim());
            ++i;
        }
        return new MCState(variables, name, Utils.toLabelFormat(name, location), Location.parseLocation(location), false, false, ordinal);
    }

    public static String toLabelFormat(String name, String location) {
        String label = String.format("%s %s", name, location).trim();
        return String.format("<%s>", label);
    }

    public static List<String> toTlcOutputFormat(MCState state) {
        ArrayList<String> inputLines = new ArrayList<String>();
        inputLines.add(String.format("%d: %s", state.getStateNumber(), state.getLabel()));
        MCVariable[] mCVariableArray = state.getVariables();
        int n = mCVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            MCVariable variable = mCVariableArray[n2];
            inputLines.add(String.format("/\\ %s = %s", variable.getName(), variable.getValueAsString()));
            ++n2;
        }
        return inputLines;
    }
}

