/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ContinueResponse;
import tla2sany.st.Location;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCActionStackFrame;
import tlc2.debug.TLCDebugger;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.tool.Action;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;

public final class TLCStepActionStackFrame
extends TLCActionStackFrame {
    private IDebugTarget.StepDirection step = IDebugTarget.StepDirection.Continue;

    public TLCStepActionStackFrame(TLCStackFrame f, Tool tool, TLCState s, Action a, TLCState t) {
        super(f, f.getNode(), f.getContext(), tool, s, a, t);
    }

    @Override
    public boolean handle(TLCDebugger debugger) {
        if (this.tool.getMode() != Tool.Mode.Simulation) {
            return false;
        }
        return debugger.getGranularity() == IDebugTarget.Granularity.State;
    }

    @Override
    public CompletableFuture<ContinueResponse> continue_(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Continue;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(new ContinueResponse());
    }

    @Override
    public CompletableFuture<Void> stepOver(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Over;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepOut(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Out;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepIn(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.In;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> reverseContinue(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepBack(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public IDebugTarget.StepDirection getStepDirection() {
        return this.step;
    }

    @Override
    public boolean matches(TLCSourceBreakpoint bp) {
        Action nextPred;
        Location loc;
        return this.tool.getMode() == Tool.Mode.Simulation && (loc = (nextPred = this.tool.getSpecProcessor().getNextPred()).getDefinition()).includes(bp.getLocation());
    }

    @Override
    public void preHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.NO_STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.State);
    }

    @Override
    public void postHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
    }

    private static class TLCCapabilities
    extends Capabilities {
        public static final Capabilities STEP_BACK = new TLCCapabilities(true);
        public static final Capabilities NO_STEP_BACK = new TLCCapabilities(false);

        public TLCCapabilities(boolean reverse) {
            this.setSupportsStepBack(reverse);
        }
    }
}

