/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tlc2.output.IMessagePrinterRecorder;

public class TestMPRecorder
implements IMessagePrinterRecorder {
    private final Map<Integer, List<Object>> records = new HashMap<Integer, List<Object>>();

    @Override
    public void record(int code, Object ... objects) {
        if (!this.records.containsKey(code)) {
            this.records.put(code, new ArrayList());
        }
        this.records.get(code).add(objects);
    }

    public boolean recorded(int code) {
        return this.records.containsKey(code);
    }

    public List<Object> getRecords(int code) {
        return this.records.get(code);
    }

    private List<Object> getRecordsOrDefault(int code, List<Object> defaultValue) {
        return this.records.getOrDefault(code, defaultValue);
    }

    public int getRecordAsInt(int code) {
        return Integer.parseInt(((String[])this.records.get(code).get(0))[0]);
    }

    public List<String[]> getRecordAsStringArray(int code) {
        List l = this.records.getOrDefault(code, new ArrayList());
        ArrayList<String[]> strs = new ArrayList<String[]>(l.size());
        for (Object o : l) {
            strs.add((String[])o);
        }
        return strs;
    }

    public boolean recordedWithStringValue(int code, String str) {
        try {
            return this.recordedWithStringValueAt(code, str, 0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean recordedWithSubStringValue(int code, String substring) {
        return this.recordedWithSubStringValue(code, substring, 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean recordedWithSubStringValue(int code, String substring, int idx) {
        try {
            Object object = this.records.get(code).get(0);
            if (object instanceof String[]) {
                String[] strs;
                String[] stringArray = strs = (String[])object;
                int n = strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string.contains(substring)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (object instanceof String) {
                return ((String)object).contains(substring);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean recordedWithStringValueAt(int code, String str, int idx) {
        try {
            Object object = this.records.get(code).get(0);
            if (object instanceof String[]) {
                String[] strs = (String[])object;
                return strs[idx].equals(str);
            }
            if (object instanceof String) {
                return object.equals(str);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean recordedWithStringValues(int code, String ... strings) {
        int i = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!this.recordedWithStringValueAt(code, string, i++)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getCoverageRecords() {
        List<Object> coverages = this.getRecords(2221);
        String out = "";
        if (coverages == null) {
            return out;
        }
        for (Object o : coverages) {
            String[] coverage = (String[])o;
            out = String.valueOf(out) + coverage[0] + ": " + Integer.parseInt(coverage[1]) + "\n";
        }
        return out;
    }

    public List<Coverage> getActionCoverage() {
        List<Object> init = this.getRecordsOrDefault(2773, new ArrayList<Object>(0));
        List<Object> next = this.getRecordsOrDefault(2772, new ArrayList<Object>(0));
        List<Object> prop = this.getRecordsOrDefault(2774, new ArrayList<Object>(0));
        List<Object> con = this.getRecordsOrDefault(2778, new ArrayList<Object>(0));
        init.addAll(next);
        init.addAll(prop);
        init.addAll(con);
        return init.stream().map(o -> (String[])o).map(a -> new Coverage((String[])a)).filter(Coverage::isAction).collect(Collectors.toList());
    }

    public List<Coverage> getZeroCoverage() {
        return this.getCoverage(2221, o -> o.isZero());
    }

    public List<Coverage> getNonZeroCoverage() {
        return this.getCoverage(2221, o -> !o.isZero());
    }

    public List<Coverage> getCostCoverage() {
        return this.getCoverage(2775, o -> !o.isZero());
    }

    private List<Coverage> getCoverage(int code, Predicate<? super Coverage> p) {
        List<Object> coverages = this.getRecordsOrDefault(code, new ArrayList<Object>(0));
        return coverages.stream().map(o -> (String[])o).map(a -> new Coverage((String[])a)).filter(p).collect(Collectors.toList());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.records.size());
        for (Integer key : this.records.keySet()) {
            List<Object> list = this.records.get(key);
            for (Object elem : list) {
                if (elem instanceof String[]) {
                    String[] strs;
                    String[] stringArray = strs = (String[])elem;
                    int n = strs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        buf.append(key);
                        buf.append(" -> ");
                        buf.append(s);
                        buf.append("\n");
                        ++n2;
                    }
                    continue;
                }
                if (!(elem instanceof String)) continue;
                buf.append(key);
                buf.append(" -> ");
                buf.append(elem);
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static class Coverage {
        private final String line;
        private final long count;
        private final long cost;
        private final int level;
        private final boolean isAction;

        public Coverage(String[] line) {
            this.isAction = line[0].startsWith("<");
            this.line = line[0].replace("|", "").trim();
            this.level = line[0].length() - this.line.length();
            if (line.length == 1) {
                this.count = -1L;
                this.cost = -1L;
            } else if (line.length == 2) {
                this.count = Long.valueOf(line[1].trim());
                this.cost = -1L;
            } else if (line.length == 3) {
                this.count = Long.valueOf(line[1].trim());
                this.cost = Long.valueOf(line[2].trim());
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String getLine() {
            return this.line;
        }

        public long getCount() {
            return this.count;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isZero() {
            return this.count == 0L;
        }

        public boolean isCoverage() {
            return !this.isAction;
        }

        public boolean isCost() {
            return this.cost >= 0L;
        }

        public boolean isAction() {
            return this.isAction;
        }

        public String toString() {
            return "Coverage [line=" + this.line + ", count=" + this.count + ", cost=" + this.cost + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.count ^ this.count >>> 32);
            result = 31 * result + (int)(this.cost ^ this.cost >>> 32);
            result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coverage other = (Coverage)obj;
            if (this.count != other.count) {
                return false;
            }
            if (this.cost != other.cost) {
                return false;
            }
            return !(this.line == null ? other.line != null : !this.line.equals(other.line));
        }
    }
}

