/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.StandardModules;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportable;
import tlc2.value.IValue;
import tlc2.value.Values;

public abstract class SemanticNode
implements ASTConstants,
ExploreNode,
LevelConstants,
Comparable<SemanticNode>,
XMLExportable {
    private static final Object[] EmptyArr = new Object[0];
    private static final AtomicInteger uid = new AtomicInteger();
    protected static Errors errors;
    public final int myUID = uid.getAndIncrement();
    public TreeNode stn;
    private Object[] tools;
    private int kind;
    public static final SemanticNode nullSN;

    static {
        nullSN = new NullSemanticNode();
    }

    public SemanticNode(int kind, TreeNode stn) {
        this.kind = kind;
        this.stn = stn;
        this.tools = EmptyArr;
    }

    public static void setError(Errors errs) {
        errors = errs;
    }

    public static String levelToString(int level) {
        switch (level) {
            case 0: {
                return String.valueOf(level) + " (Constant)";
            }
            case 1: {
                return String.valueOf(level) + " (Variable)";
            }
            case 2: {
                return String.valueOf(level) + " (Action)";
            }
            case 3: {
                return String.valueOf(level) + " (Temporal)";
            }
        }
        return String.valueOf(level) + " (Illegal)";
    }

    public final int getUid() {
        return this.myUID;
    }

    public final Object getToolObject(int toolId) {
        if (this.tools.length <= toolId) {
            return null;
        }
        return this.tools[toolId];
    }

    public final void setToolObject(int toolId, Object obj) {
        if (this.tools.length <= toolId) {
            Object[] newTools = new Object[toolId + 1];
            System.arraycopy(this.tools, 0, newTools, 0, this.tools.length);
            this.tools = newTools;
        }
        this.tools[toolId] = obj;
    }

    public final int getKind() {
        return this.kind;
    }

    public final void setKind(int k) {
        this.kind = k;
    }

    public final TreeNode getTreeNode() {
        return this.stn;
    }

    public String[] getPreComments() {
        return ((SyntaxTreeNode)this.stn).getAttachedComments();
    }

    public String getPreCommentsAsString() {
        return SyntaxTreeNode.PreCommentToString(this.getPreComments());
    }

    public SemanticNode[] getChildren() {
        return null;
    }

    public List<SemanticNode> getListOfChildren() {
        SemanticNode[] children = this.getChildren();
        if (children == null) {
            return new ArrayList<SemanticNode>();
        }
        return Arrays.asList(children).stream().filter(c -> c != null).collect(Collectors.toList());
    }

    public <T> ChildrenVisitor<T> walkChildren(ChildrenVisitor<T> visitor) {
        visitor.preVisit(this);
        for (SemanticNode c : this.getListOfChildren()) {
            if (visitor.preempt(c)) continue;
            c.walkChildren(visitor);
        }
        return visitor.postVisit(this);
    }

    public LinkedList<SemanticNode> pathTo(final Location location) {
        ChildrenVisitor<LinkedList<SemanticNode>> visitor = this.walkChildren(new ChildrenVisitor<LinkedList<SemanticNode>>(){
            LinkedList<SemanticNode> pathToLoc;

            @Override
            public LinkedList<SemanticNode> get() {
                if (this.pathToLoc == null) {
                    return new LinkedList<SemanticNode>();
                }
                return this.pathToLoc;
            }

            @Override
            public void preVisit(SemanticNode node) {
                block4: {
                    block5: {
                        block3: {
                            if (!location.equals(node.getLocation())) break block3;
                            this.pathToLoc = new LinkedList();
                            break block4;
                        }
                        if (!(node instanceof OpDefNode)) break block5;
                        OpDefNode odn = (OpDefNode)node;
                        FormalParamNode[] formalParamNodeArray = odn.getParams();
                        int n = formalParamNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FormalParamNode param = formalParamNodeArray[n2];
                            if (location.equals(param.getLocation())) {
                                this.pathToLoc = new LinkedList();
                                this.pathToLoc.add(param);
                            }
                            ++n2;
                        }
                        break block4;
                    }
                    if (!(node instanceof OpApplNode)) break block4;
                    OpApplNode oan = (OpApplNode)node;
                    for (FormalParamNode fpn : oan.getQuantSymbolLists()) {
                        if (!location.equals(fpn.getLocation())) continue;
                        this.pathToLoc = new LinkedList();
                        this.pathToLoc.add(fpn);
                    }
                }
            }

            @Override
            public boolean preempt(SemanticNode node) {
                return this.pathToLoc != null || !node.getLocation().includes(location);
            }

            @Override
            public ChildrenVisitor<LinkedList<SemanticNode>> postVisit(SemanticNode node) {
                if (this.pathToLoc != null) {
                    this.pathToLoc.add(node);
                }
                return this;
            }
        });
        return visitor.get();
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    @Override
    public String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "  uid: " + this.myUID + "  kind: " + (this.kind == -1 ? "<none>" : kinds[this.kind]) + this.getPreCommentsAsString();
    }

    public boolean isBuiltIn() {
        return Context.isBuiltIn(this);
    }

    public boolean isStandardModule() {
        return StandardModules.isDefinedInStandardModule(this);
    }

    public final Location getLocation() {
        if (this.stn != null) {
            return this.stn.getLocation();
        }
        return Location.nullLoc;
    }

    @Override
    public int compareTo(SemanticNode s) {
        Location loc1 = this.stn.getLocation();
        Location loc2 = s.stn.getLocation();
        if (loc1.beginLine() < loc2.beginLine()) {
            return -1;
        }
        if (loc1.beginLine() > loc2.beginLine()) {
            return 1;
        }
        if (loc1.beginColumn() == loc2.beginColumn()) {
            return 0;
        }
        return loc1.beginColumn() < loc2.beginColumn() ? -1 : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.kind;
        result = 31 * result + this.myUID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SemanticNode other = (SemanticNode)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return this.myUID == other.myUID;
    }

    public final void toString(StringBuffer sb, String padding) {
        TreeNode treeNode = this.getTreeNode();
        if (treeNode instanceof SyntaxTreeNode && System.getProperty(String.valueOf(SemanticNode.class.getName()) + ".showPlainFormulae") != null) {
            SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
            sb.append(stn.getHumanReadableImage());
        } else {
            sb.append(this.getLocation());
        }
    }

    public String toString() {
        TreeNode treeNode = this.getTreeNode();
        if (treeNode instanceof SyntaxTreeNode && System.getProperty(String.valueOf(SemanticNode.class.getName()) + ".showPlainFormulae") != null) {
            SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
            return stn.getHumanReadableImage();
        }
        return this.getLocation().toString();
    }

    public String getHumanReadableImage() {
        return this.getLocation().toString();
    }

    public String toString(IValue aValue) {
        return Values.ppr(aValue.toString());
    }

    protected Element getSemanticElement(Document doc, SymbolContext context) {
        throw new UnsupportedOperationException("xml export is not yet supported for: " + this.getClass() + " with toString: " + this.toString(100));
    }

    protected Element getLocationElement(Document doc) {
        Location loc = this.getLocation();
        Element e = doc.createElement("location");
        Element ecol = doc.createElement("column");
        Element eline = doc.createElement("line");
        Element fname = doc.createElement("filename");
        Element bl = doc.createElement("begin");
        Element el = doc.createElement("end");
        Element bc = doc.createElement("begin");
        Element ec = doc.createElement("end");
        bc.appendChild(doc.createTextNode(Integer.toString(loc.beginColumn())));
        ec.appendChild(doc.createTextNode(Integer.toString(loc.endColumn())));
        bl.appendChild(doc.createTextNode(Integer.toString(loc.beginLine())));
        el.appendChild(doc.createTextNode(Integer.toString(loc.endLine())));
        fname.appendChild(doc.createTextNode(this.stn.getFilename()));
        ecol.appendChild(bc);
        ecol.appendChild(ec);
        eline.appendChild(bl);
        eline.appendChild(el);
        e.appendChild(ecol);
        e.appendChild(eline);
        e.appendChild(fname);
        return e;
    }

    protected Element appendElement(Document doc, String el, Element e2) {
        Element e = doc.createElement(el);
        e.appendChild(e2);
        return e;
    }

    protected Element appendText(Document doc, String el, String txt) {
        Element e = doc.createElement(el);
        Text n = doc.createTextNode(txt);
        e.appendChild(n);
        return e;
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        try {
            Element e = this.getSemanticElement(doc, context);
            try {
                Element loc = this.getLocationElement(doc);
                e.insertBefore(loc, e.getFirstChild());
            }
            catch (UnsupportedOperationException uoe) {
                uoe.printStackTrace();
                throw uoe;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    public static class ChildrenVisitor<T> {
        public void preVisit(SemanticNode node) {
        }

        public boolean preempt(SemanticNode node) {
            return true;
        }

        public ChildrenVisitor<T> postVisit(SemanticNode node) {
            return this;
        }

        public T get() {
            return null;
        }
    }

    private static class NullSemanticNode
    extends SemanticNode {
        private NullSemanticNode() {
            super(Integer.MIN_VALUE, SyntaxTreeNode.nullSTN);
        }

        @Override
        public String levelDataToString() {
            return Integer.toString(Integer.MIN_VALUE);
        }
    }
}

