/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import tla2sany.semantic.AbortException;
import tla2sany.st.Location;
import tla2sany.utilities.Vector;

public class Errors {
    private boolean succeed = true;
    private int numAborts = 0;
    private int numErrors = 0;
    private int numWarnings = 0;
    private Vector warnings = new Vector();
    private Vector errors = new Vector();
    private Vector aborts = new Vector();

    public String[] getAborts() {
        return this.StringVectortoStringArray(this.aborts);
    }

    public String[] getErrors() {
        return this.StringVectortoStringArray(this.errors);
    }

    public String[] getWarnings() {
        return this.StringVectortoStringArray(this.warnings);
    }

    private String[] StringVectortoStringArray(Vector vec) {
        String[] retVal = new String[vec.size()];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = (String)vec.elementAt(i);
            ++i;
        }
        return retVal;
    }

    public final void addWarning(Location loc, String str) {
        if (loc == null) {
            loc = Location.nullLoc;
        }
        int i = this.warnings.size() - 1;
        while (i >= 0) {
            if ((String.valueOf(loc.toString()) + "\n\n" + str).equals(this.warnings.elementAt(i))) break;
            --i;
        }
        if (i < 0) {
            this.warnings.addElement(String.valueOf(loc.toString()) + "\n\n" + str);
            ++this.numWarnings;
        }
    }

    public final void addError(Location loc, String str) {
        if (loc == null) {
            loc = Location.nullLoc;
        }
        int i = this.errors.size() - 1;
        while (i >= 0) {
            if ((String.valueOf(loc.toString()) + "\n\n" + str).equals(this.errors.elementAt(i))) break;
            --i;
        }
        if (i < 0) {
            this.errors.addElement(String.valueOf(loc.toString()) + "\n\n" + str);
            ++this.numErrors;
        }
        this.succeed = false;
    }

    public final void addAbort(Location loc, String str, boolean abort) throws AbortException {
        String errMsg = String.valueOf(loc.toString()) + "\n\n" + str;
        int i = this.aborts.size() - 1;
        while (i >= 0) {
            if (errMsg.equals(this.aborts.elementAt(i))) break;
            --i;
        }
        if (i < 0) {
            this.aborts.addElement(errMsg);
            ++this.numAborts;
        }
        this.succeed = false;
        if (abort) {
            throw new AbortException();
        }
    }

    public final void addAbort(Location loc, String str) throws AbortException {
        this.addAbort(loc, str, true);
    }

    public final void addAbort(String str, boolean abort) throws AbortException {
        this.addAbort(Location.nullLoc, str, abort);
    }

    public final void addAbort(String str) throws AbortException {
        this.addAbort(Location.nullLoc, str, true);
    }

    public final boolean isSuccess() {
        return this.succeed;
    }

    public final boolean isFailure() {
        return !this.succeed;
    }

    public final int getNumErrors() {
        return this.numErrors;
    }

    public final int getNumAbortsAndErrors() {
        return this.numAborts + this.numErrors;
    }

    public final int getNumMessages() {
        return this.numAborts + this.numErrors + this.numWarnings;
    }

    public final String toString() {
        StringBuffer ret = new StringBuffer("");
        ret.append(this.numAborts > 0 ? "*** Abort messages: " + this.numAborts + "\n\n" : "");
        int i = 0;
        while (i < this.aborts.size()) {
            ret.append(this.aborts.elementAt(i) + "\n\n\n");
            ++i;
        }
        ret.append(this.numErrors > 0 ? "*** Errors: " + this.numErrors + "\n\n" : "");
        i = 0;
        while (i < this.errors.size()) {
            ret.append(this.errors.elementAt(i) + "\n\n\n");
            ++i;
        }
        ret.append(this.numWarnings > 0 ? "*** Warnings: " + this.numWarnings + "\n\n" : "");
        i = 0;
        while (i < this.warnings.size()) {
            ret.append(this.warnings.elementAt(i) + "\n\n\n");
            ++i;
        }
        return ret.toString();
    }
}

