/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PcalDebug;

class PcalCharReader {
    private Vector vec;
    private String currentLine = null;
    protected int line = 0;
    private int column = 0;
    private int vcolumn = 0;
    private int lastLine = 0;
    private int lastColumn = 0;
    private boolean tabToSpaces = false;

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.vcolumn;
    }

    public char getNextChar() {
        if (this.currentLine == null) {
            return '\t';
        }
        if (this.tabToSpaces) {
            ++this.vcolumn;
            if (this.vcolumn % 8 == 0) {
                this.tabToSpaces = false;
            }
            return ' ';
        }
        if (this.line > this.lastLine || this.line == this.lastLine && this.column >= this.lastColumn) {
            return '\t';
        }
        if (this.currentLine.length() == this.column) {
            ++this.line;
            this.column = 0;
            this.vcolumn = 0;
            this.currentLine = this.line >= this.vec.size() ? null : (String)this.vec.elementAt(this.line);
            return '\n';
        }
        char readChar = this.currentLine.charAt(this.column);
        ++this.column;
        ++this.vcolumn;
        if (readChar == '\t') {
            if (this.vcolumn % 8 != 0) {
                this.tabToSpaces = true;
            }
            return ' ';
        }
        return readChar;
    }

    public void backspace() {
        if (this.column == 0) {
            if (this.line == 0) {
                PcalDebug.ReportBug("PcalCharReader.backspace trying to move past beginning of reader");
            }
            --this.line;
            this.currentLine = (String)this.vec.elementAt(this.line);
            this.column = 0;
            this.vcolumn = 0;
            while (this.column < this.currentLine.length() - 1) {
                char c = this.getNextChar();
            }
        } else {
            --this.column;
            --this.vcolumn;
        }
    }

    public String peek() {
        char next = this.getNextChar();
        while (next == ' ' || next == '\n') {
            next = this.getNextChar();
        }
        if (next == '\t') {
            return "\t";
        }
        this.backspace();
        return String.valueOf(this.currentLine.substring(this.column)) + "\n";
    }

    public PcalCharReader(Vector vector, int firstLine, int firstCol, int lastLine, int lastCol) {
        this.vec = vector;
        this.line = firstLine;
        this.column = firstCol;
        this.lastLine = lastLine;
        this.lastColumn = lastCol;
        if (firstLine < vector.size()) {
            int i = 0;
            String ln = (String)vector.elementAt(firstLine);
            while (i < firstCol) {
                this.vcolumn = ln.charAt(i) == '\t' ? (this.vcolumn / 8 + 1) * 8 : ++this.vcolumn;
                ++i;
            }
        }
        if (firstLine < vector.size()) {
            this.currentLine = (String)vector.elementAt(firstLine);
        }
    }
}

