/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import tlc2.util.Combinatorics;

@State(value=Scope.Benchmark)
public class CombinatoricsBenchmark {
    private static List<BigInteger> bincoef = new ArrayList<BigInteger>(187489);
    private static List<BigInteger> slowBincoef = new ArrayList<BigInteger>(187489);

    @Benchmark
    @Warmup(iterations=3, time=1)
    @Measurement(iterations=3, time=1)
    @BenchmarkMode(value={Mode.Throughput})
    public List<BigInteger> bigChoose() {
        int n = 63;
        while (n < 496) {
            int k = 63;
            while (k < 496) {
                bincoef.add(Combinatorics.bigChoose(n, k));
                ++k;
            }
            ++n;
        }
        return bincoef;
    }

    @Benchmark
    @Warmup(iterations=3, time=1)
    @Measurement(iterations=3, time=1)
    @BenchmarkMode(value={Mode.Throughput})
    public List<BigInteger> slowBigChoose() {
        int n = 63;
        while (n < 496) {
            int k = 63;
            while (k < 496) {
                slowBincoef.add(Combinatorics.slowBigChoose(n, k));
                ++k;
            }
            ++n;
        }
        return slowBincoef;
    }
}

