/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.xml.SymbolContext;
import tlc2.TLCGlobals;
import tlc2.tool.coverage.OpApplNodeWrapper;
import util.TestPrintStream;
import util.ToolIO;
import util.UniqueString;

public class OpApplNodeWrapperTest {
    @Before
    public void setup() {
        TLCGlobals.coverageInterval = 1;
        ToolIO.out = new TestPrintStream();
    }

    @Test
    public void testReportCoverage01() {
        OpApplNodeWrapper root = new OpApplNodeWrapper();
        root.report();
        ((TestPrintStream)ToolIO.out).assertEmpty();
        root.addChild(new OpApplNodeWrapper());
    }

    @Test
    public void testReportCoverage02() {
        OpApplNodeWrapper root = new OpApplNodeWrapper();
        root.incInvocations(42L);
        root.addChild(this.getNode(23L));
        root.addChild(this.getNode(24L));
        root.addChild(this.getNode(0L));
        root.report();
        ((TestPrintStream)ToolIO.out).assertContains("  Unknown location: 42\n  |In module --TLA+ BUILTINS--: 23\n  |In module --TLA+ BUILTINS--: 24");
    }

    @Test
    public void testReportCoverage03() {
        OpApplNodeWrapper root = new OpApplNodeWrapper();
        root.incInvocations(42L);
        OpApplNodeWrapper childA = this.getNode(23L);
        childA.addChild(this.getNode(546L));
        root.addChild(childA);
        OpApplNodeWrapper childB = this.getNode(24L);
        root.addChild(childB);
        childB.addChild(this.getNode(0L));
        OpApplNodeWrapper childC = this.getNode(0L);
        root.addChild(childC);
        childC.addChild(this.getNode(17L));
        root.report();
        ((TestPrintStream)ToolIO.out).assertContains("  Unknown location: 42\n  |In module --TLA+ BUILTINS--: 23\n  ||In module --TLA+ BUILTINS--: 546\n  |In module --TLA+ BUILTINS--: 24\n  |In module --TLA+ BUILTINS--: 17");
    }

    @Test
    public void testReportCoverage04() {
        OpApplNodeWrapper root = new OpApplNodeWrapper();
        root.incInvocations(1L);
        OpApplNodeWrapper childA = this.getNode(1L);
        root.addChild(childA);
        childA.addChild(this.getNode(131072L));
        OpApplNodeWrapper cChildA = this.getNode(131072L);
        childA.addChild(cChildA);
        cChildA.addChild(this.getNode(1L));
        OpApplNodeWrapper childB = this.getNode(1L);
        root.addChild(childB);
        root.report();
        ((TestPrintStream)ToolIO.out).assertContains("  Unknown location: 1\n  |In module --TLA+ BUILTINS--: 1\n  ||In module --TLA+ BUILTINS--: 131072\n  ||In module --TLA+ BUILTINS--: 131072\n  |||In module --TLA+ BUILTINS--: 1\n  |In module --TLA+ BUILTINS--: 1");
    }

    private OpApplNodeWrapper getNode(long count) {
        DummySymbolNode sn = new DummySymbolNode(Long.toString(count));
        DummyOpApplNode node = new DummyOpApplNode(sn);
        return new OpApplNodeWrapper((OpApplNode)node, count);
    }

    private static class DummyOpApplNode
    extends OpApplNode {
        public DummyOpApplNode(SymbolNode sn) {
            super(sn);
        }
    }

    private static class DummySymbolNode
    extends SymbolNode {
        protected DummySymbolNode(String name) {
            super(1, SyntaxTreeNode.nullSTN, UniqueString.uniqueStringOf(name));
        }

        @Override
        public int getArity() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean isLocal() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean match(OpApplNode test, ModuleNode mn) throws AbortException {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        protected Element getSymbolElement(Document doc, SymbolContext context) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        protected String getNodeRef() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

