/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.DFIDWorker;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.IWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.tool.fp.dfid.MemFPIntSet;
import tlc2.util.IStateWriter;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.SetOfStates;
import util.Assert;
import util.FileUtil;
import util.UniqueString;

public class DFIDModelChecker
extends AbstractChecker {
    public TLCState[] theInitStates;
    public long[] theInitFPs;
    public FPIntSet theFPSet;
    private final AtomicLong numOfGenStates;
    protected final ThreadLocal<Integer> threadLocal = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    protected static final int INITIAL_CAPACITY = 16;

    public DFIDModelChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, long startTime) throws EvalException, IOException {
        super(tool, metadir, stateWriter, deadlock, fromChkpt, startTime);
        Assert.check(TLCGlobals.getNumWorkers() == 1, 1000, "Depth-First Iterative Deepening mode does not support multiple workers (https://github.com/tlaplus/tlaplus/issues/548).  Please run TLC with a single worker.");
        Assert.check(!this.checkLiveness, 1000, "Depth-First Iterative Deepening mode does not support checking liveness properties (https://github.com/tlaplus/tlaplus/issues/548).  Please check liveness properties in Breadth-First-Search mode.");
        this.theInitStates = null;
        this.theInitFPs = null;
        this.theFPSet = new MemFPIntSet();
        this.theFPSet.init(TLCGlobals.getNumWorkers(), this.metadir, this.tool.getRootFile());
        this.workers = new DFIDWorker[TLCGlobals.getNumWorkers()];
        this.numOfGenStates = new AtomicLong(0L);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected int modelCheckImpl() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final int checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                return MP.printError(2104, assumps[i].toString());
            }
            catch (Exception e) {
                return MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
            }
        }
        return 0;
    }

    @Override
    public final int doInit(boolean ignoreCancel) throws Throwable {
        return this.doInit(this.tool, ignoreCancel);
    }

    private final int doInit(ITool tool, boolean ignoreCancel) throws Throwable {
        TLCState curState = null;
        try {
            StateVec states = tool.getInitStates();
            this.numOfGenStates.set(states.size());
            long l = this.numOfGenStates.get();
            this.theInitStates = new TLCState[(int)l];
            this.theInitFPs = new long[(int)l];
            int idx = 0;
            int i = 0;
            while ((long)i < l) {
                long fp;
                curState = states.elementAt(i);
                if (!tool.isGoodState(curState)) {
                    return MP.printError(2106, curState.toString());
                }
                boolean inModel = tool.isInModel(curState);
                int status = 0;
                if (inModel && (status = this.theFPSet.setStatus(fp = curState.fingerPrint(), 0)) == 0) {
                    this.theInitStates[idx] = curState;
                    this.theInitFPs[idx++] = fp;
                    this.allStateWriter.writeState(curState);
                    if (this.checkLiveness) {
                        this.liveCheck.addInitState(tool, curState, fp);
                    }
                }
                if (status == 0) {
                    int j;
                    for (j = 0; j < tool.getInvariants().length; ++j) {
                        if (tool.isValid(tool.getInvariants()[j], curState)) continue;
                        MP.printError(2107, new String[]{tool.getInvNames()[j], tool.evalAlias(curState, curState).toString()});
                        if (TLCGlobals.continuation) continue;
                        return 2107;
                    }
                    for (j = 0; j < tool.getImpliedInits().length; ++j) {
                        if (tool.isValid(tool.getImpliedInits()[j], curState)) continue;
                        return MP.printError(2108, new String[]{tool.getImpliedInitNames()[j], tool.evalAlias(curState, curState).toString()});
                    }
                }
                ++i;
            }
            if ((long)idx < this.numOfGenStates.get()) {
                TLCState[] stateTemp = new TLCState[idx];
                long[] fpTemp = new long[idx];
                System.arraycopy(this.theInitStates, 0, stateTemp, 0, idx);
                System.arraycopy(this.theInitFPs, 0, fpTemp, 0, idx);
                this.theInitStates = stateTemp;
                this.theInitFPs = fpTemp;
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                return MP.printError(1002);
            }
            this.errState = curState;
            throw e;
        }
        return 0;
    }

    public final boolean doNext(TLCState curState, long cfp, boolean isLeaf, StateVec states, LongVec fps) throws Throwable {
        return this.doNext(this.tool, curState, cfp, isLeaf, states, fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doNext(ITool tool, TLCState curState, long cfp, boolean isLeaf, StateVec states, LongVec fps) throws Throwable {
        boolean deadLocked = true;
        TLCState succState = null;
        SetOfStates liveNextStates = null;
        if (this.checkLiveness && isLeaf) {
            liveNextStates = new SetOfStates(16 * this.threadLocal.get());
        }
        try {
            int k = 0;
            boolean allSuccDone = true;
            boolean allSuccNonLeaf = true;
            for (int i = 0; i < tool.getActions().length; ++i) {
                StateVec nextStates = tool.getNextStates(tool.getActions()[i], curState);
                int sz = nextStates.size();
                this.numOfGenStates.getAndAdd(sz);
                deadLocked = deadLocked && sz == 0;
                for (int j = 0; j < sz; ++j) {
                    DFIDModelChecker dFIDModelChecker;
                    int len;
                    succState = nextStates.elementAt(j);
                    if (!tool.isGoodState(succState)) {
                        DFIDModelChecker dFIDModelChecker2 = this;
                        synchronized (dFIDModelChecker2) {
                            int errorCode = 2109;
                            if (this.setErrState(curState, succState, false, 2109)) {
                                Set<OpDeclNode> unassigned = succState.getUnassigned();
                                String[] parameters = tool.getActions().length == 1 ? new String[]{unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))} : new String[]{tool.getActions()[i].getName().toString(), unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))};
                                this.printTrace(2109, parameters, curState, succState);
                            }
                        }
                        return allSuccNonLeaf;
                    }
                    boolean inModel = tool.isInModel(succState) && tool.isInActions(curState, succState);
                    int status = 0;
                    if (inModel) {
                        long fp = succState.fingerPrint();
                        status = this.theFPSet.setStatus(fp, 0);
                        allSuccDone = allSuccDone && FPIntSet.isDone(status);
                        allSuccNonLeaf = allSuccNonLeaf && !FPIntSet.isLeaf(status);
                        this.allStateWriter.writeState(curState, succState, status == 0);
                        if (!FPIntSet.isCompleted(status)) {
                            states.addElement(succState);
                            fps.addElement(fp);
                        }
                        if (this.checkLiveness && isLeaf) {
                            liveNextStates.put(fp, succState);
                        }
                    }
                    if (status == 0) {
                        try {
                            len = tool.getInvariants().length;
                            for (k = 0; k < len; ++k) {
                                if (tool.isValid(tool.getInvariants()[k], succState)) continue;
                                dFIDModelChecker = this;
                                synchronized (dFIDModelChecker) {
                                    if (TLCGlobals.continuation) {
                                        this.printTrace(2110, new String[]{tool.getInvNames()[k]}, curState, succState);
                                        break;
                                    }
                                    if (this.setErrState(curState, succState, false, 2110)) {
                                        this.printTrace(2110, new String[]{tool.getInvNames()[k]}, curState, succState);
                                        this.notify();
                                    }
                                    return allSuccNonLeaf;
                                }
                            }
                            if (k < len) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            dFIDModelChecker = this;
                            synchronized (dFIDModelChecker) {
                                if (this.setErrState(curState, succState, true, 2111)) {
                                    this.printTrace(2111, new String[]{tool.getInvNames()[k]}, curState, succState);
                                    this.notify();
                                }
                                return allSuccNonLeaf;
                            }
                        }
                    }
                    try {
                        len = tool.getImpliedActions().length;
                        for (k = 0; k < len; ++k) {
                            if (tool.isValid(tool.getImpliedActions()[k], curState, succState)) continue;
                            dFIDModelChecker = this;
                            synchronized (dFIDModelChecker) {
                                if (TLCGlobals.continuation) {
                                    this.printTrace(2112, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                    break;
                                }
                                if (this.setErrState(curState, succState, false, 2112)) {
                                    this.printTrace(2112, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                    this.notify();
                                }
                                return allSuccNonLeaf;
                            }
                        }
                        if (k >= len) continue;
                    }
                    catch (Exception e) {
                        dFIDModelChecker = this;
                        synchronized (dFIDModelChecker) {
                            if (this.setErrState(curState, succState, true, 2113)) {
                                this.printTrace(2113, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                this.notify();
                            }
                        }
                        return allSuccNonLeaf;
                    }
                }
                succState = null;
            }
            if (deadLocked && this.checkDeadlock) {
                DFIDModelChecker i = this;
                synchronized (i) {
                    if (this.setErrState(curState, null, false, 2114)) {
                        this.printTrace(2114, null, curState, null);
                        this.notify();
                    }
                }
                return allSuccNonLeaf;
            }
            if (this.checkLiveness && isLeaf) {
                long curStateFP = curState.fingerPrint();
                liveNextStates.put(curStateFP, curState);
                this.allStateWriter.writeState(curState, curState, true, IStateWriter.Visualization.STUTTERING);
                this.liveCheck.addNextState(tool, curState, curStateFP, liveNextStates);
                int multiplier = this.threadLocal.get();
                if (liveNextStates.capacity() > multiplier * 16) {
                    this.threadLocal.set(multiplier + 1);
                }
            }
            if (allSuccDone || isLeaf && allSuccNonLeaf) {
                this.theFPSet.setStatus(cfp, 1);
            }
            return allSuccNonLeaf;
        }
        catch (Throwable e) {
            boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError;
            DFIDModelChecker dFIDModelChecker = this;
            synchronized (dFIDModelChecker) {
                int errorCode = e instanceof StackOverflowError ? 1005 : (e instanceof OutOfMemoryError ? 1001 : 1000);
                if (this.setErrState(curState, succState, !keep, errorCode)) {
                    String[] parameters = null;
                    if (errorCode == 1000) {
                        parameters = new String[]{MP.ECGeneralMsg("computing the set of next states", e)};
                    }
                    this.printTrace(errorCode, parameters, curState, succState);
                    this.notifyAll();
                }
            }
            throw e;
        }
    }

    private final void printTrace(int errorCode, String[] parameters, TLCState s1, TLCState s2) {
        if (2110 == errorCode) {
            ((DFIDWorker)this.workers[IdThread.GetId()]).printInvariantTrace(errorCode, parameters, s1, s2);
        } else {
            ((DFIDWorker)this.workers[IdThread.GetId()]).printErrorTrace(errorCode, parameters, s1, s2);
        }
    }

    @Override
    public boolean setErrState(TLCState curState, TLCState succState, boolean keep, int errorCode) {
        boolean result = super.setErrState(curState, succState, keep, errorCode);
        if (!result) {
            return false;
        }
        this.setStop(2);
        return true;
    }

    public final void setStop(int code) {
        for (int i = 0; i < this.workers.length; ++i) {
            ((DFIDWorker)this.workers[i]).setStop(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doPeriodicWork() throws Exception {
        FPIntSet fPIntSet = this.theFPSet;
        synchronized (fPIntSet) {
            int result;
            if (this.checkLiveness && (result = this.liveCheck.check(this.tool, false)) != 0) {
                return result;
            }
            if (TLCGlobals.doCheckPoint()) {
                MP.printMessage(2195, this.metadir);
                this.theFPSet.beginChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.beginChkpt();
                }
                UniqueString.internTbl.beginChkpt(this.metadir);
                this.theFPSet.commitChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.commitChkpt();
                }
                UniqueString.internTbl.commitChkpt(this.metadir);
                MP.printMessage(2196);
            }
        }
        return 0;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.theFPSet.recover();
            if (this.checkLiveness) {
                this.liveCheck.recover();
            }
            MP.printMessage(2203, String.valueOf(this.theFPSet.size()));
            recovered = true;
            this.numOfGenStates.set(this.theFPSet.size());
        }
        return recovered;
    }

    protected final void cleanup(boolean success) throws IOException {
        this.theFPSet.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        this.allStateWriter.close();
        FileUtil.deleteDir(this.metadir, success);
    }

    public final void printSummary(boolean success) throws IOException {
        this.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            MP.printMessage(2206, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
        }
        MP.printMessage(2204, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
    }

    private final void reportSuccess() throws IOException {
        DFIDModelChecker.reportSuccess(this.theFPSet.size(), this.theFPSet.checkFPs(), this.numOfGenStates.get());
    }

    @Override
    protected IWorker[] startWorkers(AbstractChecker checker, int checkIndex) {
        int i;
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new DFIDWorker(i, checkIndex, checker);
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        return this.workers;
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        MP.printMessage(2206, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
        if (count == 0) {
            this.reportCoverage(this.workers);
            count = TLCGlobals.coverageInterval / 60000;
        } else {
            --count;
        }
        this.wait(60000L);
    }
}

