/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.Region;

public class TLAToken {
    public String string;
    public int column;
    public int type;
    public Region source;
    public static final int BUILTIN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int IDENT = 4;
    public static final int ADDED = 5;
    private Vector beginSubst = new Vector(2);
    private Vector endSubst = new Vector(2);
    private boolean isAppended = false;

    public Vector getBeginSubst() {
        return this.beginSubst;
    }

    public void setBeginSubst(Vector beginSubst) {
        this.beginSubst = beginSubst;
    }

    public Vector getEndSubst() {
        return this.endSubst;
    }

    public void setEndSubst(Vector endSubst) {
        this.endSubst = endSubst;
    }

    public boolean isAppended() {
        return this.isAppended;
    }

    public TLAToken(String str, int col, int typ) {
        this.string = str;
        this.column = col;
        this.type = typ;
        this.source = null;
    }

    public TLAToken(String str, int col, int typ, int line) {
        this.string = str;
        this.column = col;
        this.type = typ;
        this.source = new Region(line, col, str.length());
    }

    public TLAToken(String str, int col, int typ, Region src) {
        this.string = str;
        this.column = col;
        this.type = typ;
        this.source = src;
    }

    public TLAToken(String str, int col, int typ, boolean appended) {
        this.string = str;
        this.column = col;
        this.type = typ;
        this.source = null;
        this.isAppended = true;
    }

    public TLAToken() {
        this.string = "";
        this.column = 0;
        this.type = 0;
    }

    public int getWidth() {
        if (this.string == null) {
            return 0;
        }
        if (this.type == 3) {
            return this.string.length() + 2;
        }
        return this.string.length();
    }

    public String toString() {
        String typeName = "";
        switch (this.type) {
            case 1: {
                typeName = "BUILTIN";
                break;
            }
            case 2: {
                typeName = "NUMBER";
                break;
            }
            case 3: {
                typeName = "STRING";
                break;
            }
            case 4: {
                typeName = "IDENT";
            }
        }
        String str = "\"" + this.string + "\"";
        if (this.string == null) {
            str = "null";
        }
        String result = "[str |-> " + str + ", type |-> " + typeName + ", col |-> " + this.column + ", source |->" + (this.source == null ? "null" : this.source.toString()) + ", beginSub |-> " + this.beginSubst.toString() + ", endSub |-> " + this.endSubst.toString() + "]";
        return result;
    }

    public TLAToken Clone() {
        TLAToken result = new TLAToken(this.string, this.column, this.type);
        result.source = this.source;
        result.beginSubst = (Vector)this.beginSubst.clone();
        result.endSubst = (Vector)this.endSubst.clone();
        result.isAppended = this.isAppended;
        return result;
    }
}

