/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLCGlobals;
import tlc2.module.TLCGetSet;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.impl.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import tlc2.util.SetOfStates;
import tlc2.util.Vect;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Value;
import util.FileUtil;
import util.UniqueString;

public class SimulationWorker
extends IdThread
implements INextStateFunctor {
    protected static final boolean coverage = TLCGlobals.isCoverageEnabled();
    private final RandomGenerator localRng;
    private TLCState curState;
    private StateVec initStates;
    private final BlockingQueue<SimulationWorkerResult> resultQueue;
    private long traceCnt = 0L;
    private long globalTraceCnt = 0L;
    private final long maxTraceNum;
    private final int maxTraceDepth;
    private final boolean checkDeadlock;
    private final String traceFile;
    private final LongAdder numOfGenStates;
    private final AtomicLong numOfGenTraces;
    private final AtomicLong welfordM2AndMean;
    private final ITool tool;
    private final ILiveCheck liveCheck;
    final long[][] actionStats;
    private final String traceActions;
    private final Map<UniqueString, IntValue> behaviorStats = new HashMap<UniqueString, IntValue>();
    private volatile boolean stopped = false;
    private final StateVec nextStates = new StateVec(1);

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck) {
        this(id, tool, resultQueue, seed, maxTraceDepth, maxTraceNum, null, checkDeadlock, traceFile, liveCheck, new LongAdder(), new AtomicLong(), new AtomicLong());
    }

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, String traceActions, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck, LongAdder numOfGenStates, AtomicLong numOfGenTraces, AtomicLong m2AndMean) {
        super(id);
        this.traceActions = traceActions;
        this.localRng = new RandomGenerator(seed);
        this.tool = tool;
        this.maxTraceDepth = maxTraceDepth;
        this.maxTraceNum = maxTraceNum;
        this.resultQueue = resultQueue;
        this.checkDeadlock = checkDeadlock;
        this.traceFile = traceFile;
        this.liveCheck = liveCheck;
        this.numOfGenStates = numOfGenStates;
        this.numOfGenTraces = numOfGenTraces;
        this.welfordM2AndMean = m2AndMean;
        Vect<Action> initAndNext = this.tool.getSpecActions();
        int len = initAndNext.size();
        for (int i = 0; i < initAndNext.size(); ++i) {
            this.behaviorStats.put(initAndNext.elementAt(i).getName(), IntValue.ValZero);
        }
        this.actionStats = traceActions != null ? new long[len][len] : new long[1][1];
    }

    @Override
    public final void run() {
        boolean run2 = true;
        while (run2) {
            run2 = this.simulateAndReport();
        }
    }

    protected boolean simulateAndReport() {
        try {
            this.globalTraceCnt = this.numOfGenTraces.incrementAndGet();
            Optional<SimulationWorkerError> res = this.simulateRandomTrace();
            ++this.traceCnt;
            if (res.isPresent()) {
                SimulationWorkerError err = res.get();
                this.resultQueue.put(SimulationWorkerResult.Error(this.myGetId(), err));
            }
            if (this.traceCnt >= this.maxTraceNum) {
                this.resultQueue.put(SimulationWorkerResult.OK(this.myGetId()));
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            this.resultQueue.offer(SimulationWorkerResult.OK(this.myGetId()));
            return false;
        }
        catch (Exception e) {
            SimulationWorkerError err = new SimulationWorkerError(0, null, this.curState, this.getTrace(), e);
            this.resultQueue.offer(SimulationWorkerResult.Error(this.myGetId(), err));
            return false;
        }
    }

    private final void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted() || this.stopped) {
            throw new InterruptedException();
        }
    }

    public final void setStopped() {
        this.stopped = true;
    }

    private final TLCState randomState(RandomGenerator rng, StateVec states) {
        int len = states.size();
        if (len > 0) {
            int index = (int)Math.floor(rng.nextDouble() * (double)len);
            return states.elementAt(index);
        }
        return null;
    }

    @Override
    public Object setElement(TLCState s) {
        this.nextStates.clear();
        this.nextStates.addElement(s);
        return this;
    }

    @Override
    public Object addElement(TLCState s, Action a, TLCState t) {
        if (coverage) {
            a.cm.incInvocations();
        }
        this.numOfGenStates.increment();
        t.setPredecessor(s).setAction(a);
        if (!this.tool.isGoodState(t)) {
            Set<OpDeclNode> unassigned = t.getUnassigned();
            String[] parameters = this.tool.getActions().length == 1 ? new String[]{unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))} : new String[]{a.getName().toString(), unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))};
            throw new SimulationWorkerError(2109, parameters, t, this.getTrace());
        }
        int idx = 0;
        try {
            for (idx = 0; idx < this.tool.getInvariants().length; ++idx) {
                if (this.tool.isValid(this.tool.getInvariants()[idx], t)) continue;
                throw new SimulationWorkerError(2110, new String[]{this.tool.getInvNames()[idx]}, t, this.getTrace());
            }
        }
        catch (Exception e) {
            if (e instanceof SimulationWorkerError) {
                throw e;
            }
            throw new SimulationWorkerError(2111, new String[]{this.tool.getInvNames()[idx], e.getMessage()}, t, this.getTrace());
        }
        try {
            for (idx = 0; idx < this.tool.getImpliedActions().length; ++idx) {
                if (this.tool.isValid(this.tool.getImpliedActions()[idx], this.curState, t)) continue;
                throw new SimulationWorkerError(2112, new String[]{this.tool.getImpliedActNames()[idx]}, t, this.getTrace());
            }
        }
        catch (Exception e) {
            if (e instanceof SimulationWorkerError) {
                throw e;
            }
            throw new SimulationWorkerError(2113, new String[]{this.tool.getImpliedActNames()[idx], e.getMessage()}, t, this.getTrace());
        }
        if (this.tool.isInModel(t) && this.tool.isInActions(s, t)) {
            if (coverage) {
                a.cm.incSecondary();
            }
            return this.nextStates.addElement(t);
        }
        return this;
    }

    @Override
    public boolean hasStates() {
        assert (Tool.isProbabilistic());
        return !this.nextStates.isEmpty();
    }

    @Override
    public SetOfStates getStates() {
        return new SetOfStates(this.nextStates);
    }

    protected int getNextActionIndex(RandomGenerator rng, Action[] actions, TLCState curState) {
        return (int)Math.floor(this.localRng.nextDouble() * (double)actions.length);
    }

    protected int getNextActionAltIndex(int index, int p, Action[] actions, TLCState curState) {
        return (index + p) % actions.length;
    }

    private Optional<SimulationWorkerError> simulateRandomTrace() throws Exception {
        this.curState = this.randomState(this.localRng, this.initStates);
        SimulationWorker.setCurrentState(this.curState);
        Action[] actions = this.tool.getActions();
        int len = actions.length;
        for (int traceIdx = 0; traceIdx < this.maxTraceDepth; ++traceIdx) {
            this.checkForInterrupt();
            this.nextStates.clear();
            int index = this.getNextActionIndex(this.localRng, actions, this.curState);
            int p = this.localRng.nextPrime();
            for (int i = 0; i < len; ++i) {
                try {
                    this.tool.getNextStates(this, this.curState, actions[index]);
                }
                catch (SimulationWorkerError swe) {
                    return Optional.of(swe);
                }
                if (!this.nextStates.empty()) break;
                index = this.getNextActionAltIndex(index, p, actions, this.curState);
            }
            if (this.nextStates.empty()) {
                if (!this.checkDeadlock) break;
                return Optional.of(new SimulationWorkerError(2114, null, this.curState, this.getTrace(), null));
            }
            TLCState s1 = this.randomState(this.localRng, this.nextStates);
            s1.execCallable();
            if (this.traceActions != null) {
                long[] lArray = this.actionStats[this.curState.getAction().getId()];
                int n = s1.getAction().getId();
                lArray[n] = lArray[n] + 1L;
            }
            this.curState = s1;
            SimulationWorker.setCurrentState(this.curState);
        }
        this.checkForInterrupt();
        this.liveCheck.checkTrace(this.tool.getLiveness(), new Supplier<StateVec>(){

            @Override
            public StateVec get() {
                return SimulationWorker.this.getTrace();
            }
        });
        this.welfordM2AndMean.accumulateAndGet(Math.min(this.maxTraceDepth, this.curState.getLevel()), (acc, tl) -> {
            int mean = (int)(acc & 0xFFFFFFFFL);
            long m2 = acc >>> 32;
            long delta = tl - (long)mean;
            mean = (int)((long)mean + delta / (this.numOfGenTraces.longValue() + 0L));
            return (m2 += delta * (tl - (long)mean)) << 32 | (long)mean & 0xFFFFFFFFL;
        });
        if (this.traceFile != null) {
            String fileName = this.traceFile + "_" + String.valueOf(this.myGetId()) + "_" + this.traceCnt;
            PrintWriter pw = new PrintWriter(FileUtil.newBFOS(fileName));
            pw.println("---------------- MODULE " + fileName + " -----------------");
            StateVec stateTrace = new Supplier<StateVec>(){

                @Override
                public StateVec get() {
                    return SimulationWorker.this.getTrace();
                }
            }.get();
            for (int idx = 0; idx < stateTrace.size(); ++idx) {
                Action curAction = stateTrace.elementAt(idx).getAction();
                if (curAction != null) {
                    pw.println("\\* " + curAction.getLocation());
                }
                pw.println("STATE_" + (idx + 1) + " == ");
                pw.println(stateTrace.elementAt(idx) + "\n");
            }
            pw.println("=================================================");
            pw.close();
        }
        this.postTrace(this.curState);
        return Optional.empty();
    }

    protected boolean postTrace(TLCState finalState) throws FileNotFoundException {
        return true;
    }

    public final long getTraceCnt() {
        return this.traceCnt + 1L;
    }

    public final StateVec getTrace() {
        return this.getTrace(this.curState);
    }

    public final synchronized StateVec getTrace(TLCState s) {
        if (s == null) {
            return new StateVec(0);
        }
        int level = s.getLevel();
        TLCState[] t = new TLCState[level];
        for (int i = level - 1; i >= 0; --i) {
            t[i] = s;
            s = s.getPredecessor();
        }
        assert (t[0] != null && s == null);
        return new StateVec(t);
    }

    public final TLCStateInfo[] getTraceInfo(int level) {
        StateVec stateTrace = this.getTrace();
        assert (0 < level && level <= stateTrace.size());
        TLCStateInfo[] trace = new TLCStateInfo[level];
        for (int i = 0; i < trace.length; ++i) {
            TLCState s = stateTrace.elementAt(i);
            trace[i] = new TLCStateInfo(s);
        }
        return trace;
    }

    public void setInitialStates(StateVec initStates) {
        this.initStates = initStates;
    }

    public void start(StateVec initStates) {
        this.setInitialStates(initStates);
        this.start();
    }

    public final RandomGenerator getRNG() {
        return this.localRng;
    }

    public Value getWorkerStatistics(TLCState s) {
        UniqueString[] n = new UniqueString[2];
        Value[] v = new Value[n.length];
        this.behaviorStats.replaceAll((key, val) -> IntValue.ValZero);
        while (s != null && !s.isInitial()) {
            this.behaviorStats.merge(s.getAction().getName(), IntValue.ValOne, IntValue::sum);
            s = s.getPredecessor();
        }
        n[0] = TLCGetSet.SPEC_ACTIONS;
        v[0] = new RecordValue(this.behaviorStats);
        n[1] = TLCGetSet.ID;
        v[1] = TLCGetSet.narrowToIntValue(this.globalTraceCnt);
        return new RecordValue(n, v, false);
    }

    public static class SimulationWorkerError
    extends INextStateFunctor.InvariantViolatedException {
        public int errorCode;
        public final String[] parameters;
        public final TLCState state;
        public final StateVec stateTrace;
        public final Exception exception;

        public SimulationWorkerError(int errorCode, String[] parameters, TLCState state, StateVec stateTrace) {
            this(errorCode, parameters, state, stateTrace, null);
        }

        public SimulationWorkerError(int errorCode, String[] parameters, TLCState state, StateVec stateTrace, Exception e) {
            this.errorCode = errorCode;
            this.parameters = parameters;
            this.state = state;
            this.stateTrace = stateTrace;
            this.exception = e;
        }

        @Override
        public String getMessage() {
            return MP.getMessage(this.errorCode, this.parameters);
        }

        public boolean hasTrace() {
            return this.stateTrace != null && !this.stateTrace.empty();
        }

        public List<TLCStateInfo> getTrace() {
            ArrayList<TLCStateInfo> trace = new ArrayList<TLCStateInfo>();
            for (int j = 0; j < this.stateTrace.size(); ++j) {
                TLCState state = this.stateTrace.elementAt(j);
                trace.add(new TLCStateInfo(state, state.getAction()));
            }
            return trace;
        }
    }

    public static class SimulationWorkerResult {
        private int workerId;
        private Optional<SimulationWorkerError> error = Optional.empty();

        static SimulationWorkerResult OK(int workerId) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.workerId = workerId;
            return res;
        }

        static SimulationWorkerResult Error(int workerId, SimulationWorkerError err) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.error = Optional.of(err);
            res.workerId = workerId;
            return res;
        }

        public boolean isError() {
            return this.error.isPresent();
        }

        public SimulationWorkerError error() {
            return this.error.get();
        }

        public int workerId() {
            return this.workerId;
        }
    }
}

