/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import tla2sany.semantic.SymbolNode;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public final class Context
implements Iterator<Context> {
    private final SymbolNode name;
    private final Object value;
    private final Context next;
    public static final Context Empty = new Context(null, null, null);
    private static final Context BaseBranch = new Context(null, null, Empty);

    private Context(SymbolNode name, Object value, Context next) {
        this.name = name;
        this.value = value;
        this.next = next;
    }

    public static Context branch(Context base) {
        if (base == Empty) {
            return BaseBranch;
        }
        return new Context(null, null, base);
    }

    public final Context cons(SymbolNode name, Object value) {
        return new Context(name, value, this);
    }

    public final Object lookup(SymbolNode var) {
        Context cur = this;
        while (cur != Empty) {
            if (var == cur.name) {
                return cur.value;
            }
            cur = cur.next;
        }
        return null;
    }

    public final Object lookup(Function<SymbolNode, Boolean> f) {
        Context cur = this;
        while (cur != Empty) {
            if (f.apply(cur.name).booleanValue()) {
                return cur.value;
            }
            cur = cur.next;
        }
        return null;
    }

    public final SymbolNode lookupName(Function<SymbolNode, Boolean> f) {
        Context cur = this;
        while (cur != Empty) {
            if (f.apply(cur.name).booleanValue()) {
                return cur.name;
            }
            cur = cur.next;
        }
        return null;
    }

    public final Object lookup(SymbolNode var, boolean cutoff) {
        Context cur = this;
        while (cur != Empty) {
            if (cur.name != null) {
                if (var == cur.name) {
                    return cur.value;
                }
            } else if (cutoff) {
                assert (cur.value == null);
                return null;
            }
            cur = cur.next;
        }
        return null;
    }

    public final Map<UniqueString, Value> toMap() {
        if (this.name == null) {
            if (this == Empty) {
                return new HashMap<UniqueString, Value>();
            }
            return this.next.toMap();
        }
        HashMap<UniqueString, Value> res = new HashMap<UniqueString, Value>();
        res.put(this.name.getName(), this.value instanceof Value ? (Value)this.value : new StringValue(this.value.toString()));
        Context cur = this.next;
        while (cur.name != null) {
            res.put(cur.name.getName(), cur.value instanceof Value ? (Value)cur.value : new StringValue(cur.value.toString()));
            cur = cur.next;
        }
        res.putAll(cur.toMap());
        return res;
    }

    public final StringBuffer toString(StringBuffer sb) {
        if (this.name == null) {
            if (this == Empty) {
                return sb;
            }
            return this.next.toString(sb);
        }
        sb.append(this.name.getName());
        sb.append("->");
        sb.append(this.value);
        Context cur = this.next;
        while (cur.name != null) {
            sb.append(", ");
            sb.append(cur.name.getName());
            sb.append("->");
            sb.append(cur.value);
            cur = cur.next;
        }
        cur.toString(sb);
        return sb;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb = this.toString(sb);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Context next() {
        return this.next;
    }

    public final SymbolNode getName() {
        return this.name;
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isEmpty() {
        return this == Empty;
    }

    public final boolean isDeepEmpty() {
        return this.isEmpty() || this == BaseBranch;
    }

    public final int depth() {
        int depth = 1;
        Context child = this.next();
        while (child.hasNext()) {
            ++depth;
            child = child.next();
        }
        return depth;
    }

    public Context deepCopy() {
        if (this == Empty) {
            return this;
        }
        return new Context(this.name, this.value, this.next.deepCopy());
    }
}

