/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.ConcurrentTLCTrace;
import tlc2.tool.EvalException;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IWorker;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.WorkerException;
import tlc2.tool.fp.FPSet;
import tlc2.tool.impl.CallStackTool;
import tlc2.tool.impl.Tool;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.IStateWriter;
import tlc2.util.IdThread;
import tlc2.util.SetOfStates;
import tlc2.util.statistics.FixedSizedBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.impl.CounterExample;
import util.Assert;
import util.FileUtil;
import util.WrongInvocationException;

public final class Worker
extends IdThread
implements IWorker,
INextStateFunctor {
    protected static final boolean coverage = TLCGlobals.isCoverageEnabled();
    private static final int INITIAL_CAPACITY = 16;
    private final ModelChecker tlc;
    private final Tool tool;
    private final Tool.Mode mode;
    private final IStateQueue squeue;
    private final FPSet theFPSet;
    private final IStateWriter allStateWriter;
    private final IBucketStatistics outDegree;
    private final String filename;
    private final BufferedRandomAccessFile raf;
    private final boolean checkDeadlock;
    private long lastPtr;
    private long statesGenerated;
    private int unseenSuccessorStates = 0;
    private volatile int maxLevel = 0;
    private int multiplier = 1;
    private SetOfStates setOfStates;
    private final boolean checkLiveness;

    public Worker(int id, AbstractChecker tlc, String metadir, String specFile) throws IOException {
        super(id);
        this.setName("TLC Worker " + id);
        this.tlc = (ModelChecker)tlc;
        this.checkLiveness = this.tlc.checkLiveness;
        this.checkDeadlock = this.tlc.checkDeadlock;
        this.tool = (Tool)this.tlc.tool;
        this.mode = this.tool.getMode();
        this.squeue = this.tlc.theStateQueue;
        this.theFPSet = this.tlc.theFPSet;
        this.allStateWriter = this.tlc.allStateWriter;
        this.outDegree = new FixedSizedBucketStatistics(this.getName(), 32);
        this.setName("TLCWorkerThread-" + String.format("%03d", id));
        this.filename = metadir + FileUtil.separator + specFile + "-" + this.myGetId();
        this.raf = new BufferedRandomAccessFile(this.filename + ".st", "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TLCState curState = null;
        try {
            while (true) {
                if ((curState = this.squeue.sDequeue()) == null) {
                    ModelChecker modelChecker = this.tlc;
                    synchronized (modelChecker) {
                        int ec;
                        if (!this.tlc.setDone() && (ec = this.tool.checkPostCondition()) != 0) {
                            this.tlc.setError(true, ec);
                        }
                        this.tlc.notify();
                    }
                    this.squeue.finishAll();
                    return;
                }
                Worker.setCurrentState(curState);
                if (this.checkLiveness || this.mode == Tool.Mode.MC_DEBUG) {
                    this.setOfStates = this.createSetOfStates();
                }
                long preNext = this.statesGenerated;
                try {
                    this.tool.getNextStates(this, curState);
                }
                catch (WrappingRuntimeException e) {
                    this.tlc.doNextFailed(curState, e.unwrapState(), e.unwrapExp());
                }
                catch (Throwable notExpectedToHappen) {
                    this.tlc.doNextFailed(curState, null, notExpectedToHappen);
                }
                if (this.checkDeadlock && preNext == this.statesGenerated) {
                    this.doNextSetErr(curState, null, false, 2114, null);
                }
                if (this.checkLiveness) {
                    try {
                        this.doNextCheckLiveness(curState, this.setOfStates);
                    }
                    catch (Throwable e) {
                        this.tlc.doNextFailed(curState, null, e);
                    }
                }
                this.outDegree.addSample(this.unseenSuccessorStates);
                this.unseenSuccessorStates = 0;
            }
        }
        catch (Throwable e) {
            Worker.resetCurrentState();
            ModelChecker modelChecker = this.tlc;
            synchronized (modelChecker) {
                if (this.tlc.setErrState(curState, null, true, 1000)) {
                    MP.printError(1000, e);
                }
                this.squeue.finishAll();
                this.tlc.notify();
            }
            return;
        }
    }

    private final void doNextCheckLiveness(TLCState curState, SetOfStates liveNextStates) throws IOException {
        long curStateFP = curState.fingerPrint();
        liveNextStates.put(curStateFP, curState);
        this.tlc.allStateWriter.writeState(curState, curState, true, IStateWriter.Visualization.STUTTERING);
        try {
            this.tlc.liveCheck.addNextState(this.tlc.tool.getLiveness(), curState, curStateFP, liveNextStates);
        }
        catch (EvalException | Assert.TLCRuntimeException origExp) {
            ModelChecker modelChecker = this.tlc;
            synchronized (modelChecker) {
                block9: {
                    if (this.tlc.printedLivenessErrorStack) {
                        return;
                    }
                    this.tlc.printedLivenessErrorStack = true;
                    liveNextStates.resetNext();
                    CallStackTool cTool = new CallStackTool(this.tlc.tool.getLiveness());
                    try {
                        this.tlc.liveCheck.addNextState(cTool, curState, curStateFP, liveNextStates);
                        Assert.fail(1000, origExp);
                    }
                    catch (EvalException | Assert.TLCRuntimeException rerunExp) {
                        if (!cTool.hasCallStack()) break block9;
                        this.tlc.keepCallStack = false;
                        MP.printError(2103, cTool.toString());
                    }
                }
                throw origExp;
            }
        }
        if (liveNextStates.capacity() > this.multiplier * 16) {
            ++this.multiplier;
        }
    }

    private final SetOfStates createSetOfStates() {
        return new SetOfStates(this.multiplier * 16);
    }

    @Override
    public SetOfStates getStates() {
        return this.setOfStates;
    }

    final void incrementStatesGenerated(long l) {
        this.statesGenerated += l;
    }

    final long getStatesGenerated() {
        return this.statesGenerated;
    }

    public final IBucketStatistics getOutDegree() {
        return this.outDegree;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    final void setLevel(int level) {
        this.maxLevel = level;
    }

    public final synchronized void writeState(TLCState initialState, long fp) throws IOException {
        this.lastPtr = this.raf.getFilePointer();
        this.raf.writeLongNat(1L);
        this.raf.writeShortNat(this.myGetId());
        this.raf.writeLong(fp);
        initialState.workerId = (short)this.myGetId();
        initialState.uid = this.lastPtr;
    }

    public final synchronized void writeState(TLCState curState, long sucStateFp, TLCState sucState) throws IOException {
        this.maxLevel = Math.max(curState.getLevel() + 1, this.maxLevel);
        this.lastPtr = this.raf.getFilePointer();
        this.raf.writeLongNat(curState.uid);
        this.raf.writeShortNat(curState.workerId);
        this.raf.writeLong(sucStateFp);
        sucState.workerId = (short)this.myGetId();
        sucState.uid = this.lastPtr;
        sucState.setPredecessor(curState);
        ++this.unseenSuccessorStates;
    }

    public final synchronized ConcurrentTLCTrace.Record readStateRecord(long ptr) throws IOException {
        this.raf.mark();
        this.raf.seek(ptr);
        long prev = this.raf.readLongNat();
        assert (0L <= ptr);
        int worker = this.raf.readShortNat();
        assert (0 <= worker && worker < this.tlc.workers.length);
        long fp = this.raf.readLong();
        assert (this.tlc.theFPSet.contains(fp));
        this.raf.seek(this.raf.getMark());
        return new ConcurrentTLCTrace.Record(prev, worker, fp);
    }

    public final synchronized void beginChkpt() throws IOException {
        this.raf.flush();
        DataOutputStream dos = FileUtil.newDFOS(this.filename + ".tmp");
        dos.writeLong(this.raf.getFilePointer());
        dos.writeLong(this.lastPtr);
        dos.close();
    }

    public final synchronized void commitChkpt() throws IOException {
        File oldChkpt = new File(this.filename + ".chkpt");
        File newChkpt = new File(this.filename + ".tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("Trace.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public final void recover() throws IOException {
        DataInputStream dis = FileUtil.newDFIS(this.filename + ".chkpt");
        long filePos = dis.readLong();
        this.lastPtr = dis.readLong();
        dis.close();
        this.raf.seek(filePos);
    }

    public final Enumerator elements() throws IOException {
        return new Enumerator();
    }

    @Override
    public final Object addElement(TLCState state) {
        throw new WrongInvocationException("tlc2.tool.Worker.addElement(TLCState) should not be called");
    }

    @Override
    public final Object addElement(TLCState curState, Action action, TLCState succState) {
        if (coverage) {
            action.cm.incInvocations();
        }
        ++this.statesGenerated;
        try {
            if (!this.tool.isGoodState(succState)) {
                this.doNextSetErr(curState, succState, action);
                throw new INextStateFunctor.InvariantViolatedException();
            }
            boolean inModel = this.tool.isInModel(succState.setPredecessor(curState).setAction(action)) && this.tool.isInActions(curState, succState);
            boolean unseen = true;
            if (inModel) {
                boolean bl = unseen = !this.isSeenState(curState, succState, action);
            }
            if (unseen && this.doNextCheckInvariants(curState, succState)) {
                throw new INextStateFunctor.InvariantViolatedException();
            }
            if (this.doNextCheckImplied(curState, succState)) {
                throw new INextStateFunctor.InvariantViolatedException();
            }
            if (inModel && unseen) {
                this.squeue.sEnqueue(succState);
            }
            return this;
        }
        catch (Exception e) {
            throw new WrappingRuntimeException(e, succState);
        }
    }

    private final boolean isSeenState(TLCState curState, TLCState succState, Action action) throws IOException {
        long fp = succState.fingerPrint();
        boolean seen = this.theFPSet.put(fp);
        this.allStateWriter.writeState(curState, succState, !seen, action);
        if (!seen) {
            this.writeState(curState, fp, succState);
            if (coverage) {
                action.cm.incSecondary();
            }
        }
        if (this.checkLiveness || this.mode == Tool.Mode.MC_DEBUG) {
            this.setOfStates.put(fp, succState);
        }
        return seen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doNextCheckInvariants(TLCState curState, TLCState succState) throws IOException, WorkerException, Exception {
        int k = 0;
        try {
            for (k = 0; k < this.tool.getInvariants().length; ++k) {
                if (this.tool.isValid(this.tool.getInvariants()[k], succState)) continue;
                if (TLCGlobals.continuation) {
                    ModelChecker modelChecker = this.tlc;
                    synchronized (modelChecker) {
                        MP.printError(2110, this.tool.getInvNames()[k]);
                        this.tlc.trace.printTrace(curState, succState);
                        return false;
                    }
                }
                return this.doNextSetErr(curState, succState, false, 2110, this.tool.getInvNames()[k]);
            }
        }
        catch (Exception e) {
            this.tlc.doNextEvalFailed(curState, succState, 2111, this.tool.getInvNames()[k], e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doNextCheckImplied(TLCState curState, TLCState succState) throws IOException, WorkerException, Exception {
        int k = 0;
        try {
            for (k = 0; k < this.tool.getImpliedActions().length; ++k) {
                if (this.tool.isValid(this.tool.getImpliedActions()[k], curState, succState)) continue;
                if (TLCGlobals.continuation) {
                    ModelChecker modelChecker = this.tlc;
                    synchronized (modelChecker) {
                        MP.printError(2112, this.tool.getImpliedActNames()[k]);
                        this.tlc.trace.printTrace(curState, succState);
                        return false;
                    }
                }
                return this.doNextSetErr(curState, succState, false, 2112, this.tool.getImpliedActNames()[k]);
            }
        }
        catch (Exception e) {
            this.tlc.doNextEvalFailed(curState, succState, 2113, this.tool.getImpliedActNames()[k], e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doNextSetErr(TLCState curState, TLCState succState, boolean keep, int ec, String param) throws IOException, WorkerException {
        ModelChecker modelChecker = this.tlc;
        synchronized (modelChecker) {
            boolean doNextSetErr = this.tlc.doNextSetErr(curState, succState, keep, ec, param);
            this.doPostCondition(curState, succState);
            return doNextSetErr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doNextSetErr(TLCState curState, TLCState succState, Action action) throws IOException, WorkerException {
        ModelChecker modelChecker = this.tlc;
        synchronized (modelChecker) {
            boolean doNextSetErr = this.tlc.doNextSetErr(curState, succState, action);
            this.doPostCondition(curState, succState);
            return doNextSetErr;
        }
    }

    private final void doPostCondition(TLCState curState, TLCState succState) throws IOException {
        LinkedList<TLCStateInfo> trace = new LinkedList<TLCStateInfo>();
        if (curState.isInitial() && succState == null) {
            trace.add(this.tool.getState(curState.fingerPrint()));
        } else if (succState == null) {
            trace.addAll(Arrays.asList(this.tlc.getTraceInfo(curState)));
            trace.add(this.tool.getState(curState, ((TLCStateInfo)trace.getLast()).state));
        } else {
            trace.addAll(Arrays.asList(this.tlc.getTraceInfo(succState)));
            trace.add(this.tool.getState(succState, curState));
        }
        this.tool.checkPostConditionWithCounterExample(new CounterExample(trace));
    }

    private static class WrappingRuntimeException
    extends RuntimeException {
        private final Exception e;
        private final TLCState state;

        public WrappingRuntimeException(Exception e, TLCState state) {
            this.e = e;
            this.state = state;
        }

        public TLCState unwrapState() {
            return this.state;
        }

        public Exception unwrapExp() {
            return this.e;
        }
    }

    public class Enumerator {
        private final long len;
        private final BufferedRandomAccessFile enumRaf;

        Enumerator() throws IOException {
            this.len = Worker.this.raf.getFilePointer();
            this.enumRaf = new BufferedRandomAccessFile(Worker.this.filename + ".st", "r");
        }

        public boolean hasMoreFP() {
            long fpos = this.enumRaf.getFilePointer();
            return fpos < this.len;
        }

        public long nextFP() throws IOException {
            this.enumRaf.readLongNat();
            this.enumRaf.readShortNat();
            return this.enumRaf.readLong();
        }

        public void close() throws IOException {
            this.enumRaf.close();
        }
    }
}

