/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MethodValue;
import util.UniqueString;

public interface SymbolNodeValueLookupProvider {
    default public SymbolNode getVar(SemanticNode expr, Context c, boolean cutoff, int forToolId) {
        SymbolNode opNode;
        if (expr instanceof OpApplNode && (opNode = ((OpApplNode)expr).getOperator()).getArity() == 0) {
            boolean isVarDecl = opNode.getKind() == 3;
            Object val = this.lookup(opNode, c, cutoff && isVarDecl, forToolId);
            if (val instanceof LazyValue) {
                LazyValue lval = (LazyValue)val;
                return this.getVar(lval.expr, lval.con, cutoff, forToolId);
            }
            if (val instanceof OpDefNode) {
                return this.getVar(((OpDefNode)val).getBody(), c, cutoff, forToolId);
            }
            if (isVarDecl) {
                return opNode;
            }
        }
        return null;
    }

    default public Object lookup(SymbolNode opNode, Context c, boolean cutoff, int forToolId) {
        boolean isVarDecl = opNode.getKind() == 3;
        Object result = c.lookup(opNode, cutoff && isVarDecl);
        if (result != null) {
            return result;
        }
        result = opNode.getToolObject(forToolId);
        if (result != null) {
            return WorkerValue.mux(result);
        }
        if (opNode.getKind() == 5) {
            ExprNode body = ((OpDefNode)opNode).getBody();
            result = body.getToolObject(forToolId);
            while (result == null && body.getKind() == 13) {
                body = ((SubstInNode)body).getBody();
                result = body.getToolObject(forToolId);
            }
            if (result != null) {
                return result;
            }
        }
        return opNode;
    }

    default public Object getVal(ExprOrOpArgNode expr, Context c, boolean cachable, int forToolId) {
        return this.getVal(expr, c, cachable, CostModel.DO_NOT_RECORD, forToolId);
    }

    default public Object getVal(ExprOrOpArgNode expr, Context c, boolean cachable, CostModel cm, int forToolId) {
        if (expr instanceof ExprNode) {
            return new LazyValue(expr, c, cachable, cm);
        }
        SymbolNode opNode = ((OpArgNode)expr).getOp();
        return this.lookup(opNode, c, false, forToolId);
    }

    default public Context getOpContext(OpDefNode opDef, ExprOrOpArgNode[] args, Context c, boolean cachable, int forToolId) {
        return this.getOpContext(opDef, args, c, cachable, CostModel.DO_NOT_RECORD, forToolId);
    }

    default public Context getOpContext(OpDefNode opDef, ExprOrOpArgNode[] args, Context c, boolean cachable, CostModel cm, int forToolId) {
        FormalParamNode[] formals = opDef.getParams();
        int alen = args.length;
        Context c1 = c;
        for (int i = 0; i < alen; ++i) {
            Object aval = this.getVal(args[i], c, cachable, cm, forToolId);
            c1 = c1.cons(formals[i], aval);
        }
        return c1;
    }

    default public int getLevelBound(SemanticNode expr, Context c, int forToolId) {
        switch (expr.getKind()) {
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                return this.getLevelBoundAppl(expr1, c, forToolId);
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                int letLen = letDefs.length;
                Context c1 = c;
                int level = 0;
                for (int i = 0; i < letLen; ++i) {
                    OpDefNode opDef = letDefs[i];
                    level = Math.max(level, this.getLevelBound(opDef.getBody(), c1, forToolId));
                    c1 = c1.cons(opDef, IntValue.ValOne);
                }
                return Math.max(level, this.getLevelBound(expr1.getBody(), c1, forToolId));
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, forToolId));
                }
                return this.getLevelBound(expr1.getBody(), c1, forToolId);
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, forToolId));
                }
                return this.getLevelBound(expr1.getBody(), c1, forToolId);
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                return this.getLevelBound(expr1.getBody(), c, forToolId);
            }
        }
        return 0;
    }

    default public int getLevelBoundAppl(OpApplNode expr, Context c, int forToolId) {
        SymbolNode opNode = expr.getOperator();
        UniqueString opName = opNode.getName();
        int opcode = BuiltInOPs.getOpCode(opName);
        if (BuiltInOPs.isTemporal(opcode)) {
            return 3;
        }
        if (BuiltInOPs.isAction(opcode)) {
            return 2;
        }
        if (opcode == 34) {
            return 1;
        }
        int level = 0;
        ExprNode[] bnds = expr.getBdedQuantBounds();
        for (int i = 0; i < bnds.length; ++i) {
            level = Math.max(level, this.getLevelBound(bnds[i], c, forToolId));
        }
        if (opcode == 16) {
            FormalParamNode fname = expr.getUnbdedQuantSymbols()[0];
            c = c.cons(fname, IntValue.ValOne);
        }
        ExprOrOpArgNode[] args = expr.getArgs();
        int alen = args.length;
        for (int i = 0; i < alen; ++i) {
            if (args[i] == null) continue;
            level = Math.max(level, this.getLevelBound(args[i], c, forToolId));
        }
        if (opcode == 0) {
            if (opName.getVarLoc() >= 0) {
                return 1;
            }
            Object val = this.lookup(opNode, c, false, forToolId);
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                c = c.cons(opNode, IntValue.ValOne);
                level = Math.max(level, this.getLevelBound(opDef.getBody(), c, forToolId));
            } else if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                level = Math.max(level, this.getLevelBound(lv.expr, lv.con, forToolId));
            } else if (val instanceof EvaluatingValue) {
                EvaluatingValue ev = (EvaluatingValue)val;
                level = Math.max(level, ev.getMinLevel());
            } else if (val instanceof MethodValue) {
                MethodValue mv = (MethodValue)val;
                level = Math.max(level, mv.getMinLevel());
            }
        }
        return level;
    }
}

